/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.io;

import java.util.Locale;
import javax.inject.Inject;
import org.junit.Test;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.io.DirectoryEntryJsonWriter;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@Deploy(value={"org.nuxeo.ecm.directory", "org.nuxeo.ecm.directory.sql"})
@LocalDeploy(value={"org.nuxeo.ecm.directory.resolver.test:test-directory-resolver-contrib.xml"})
public class DirectoryEntryJsonWriterTest
extends AbstractJsonWriterTest.External<DirectoryEntryJsonWriter, DirectoryEntry> {
    @Inject
    private DirectoryService directoryService;

    public DirectoryEntryJsonWriterTest() {
        super(DirectoryEntryJsonWriter.class, DirectoryEntry.class);
    }

    @Test
    public void test() throws Exception {
        String directoryName = "referencedDirectory1";
        Directory directory = this.directoryService.getDirectory(directoryName);
        try (Session session = directory.getSession();){
            DocumentModel entryModel = session.getEntry("123");
            DirectoryEntry entry = new DirectoryEntry(directoryName, entryModel);
            JsonAssert json = this.jsonAssert(entry);
            json.isObject();
            json.properties(3);
            json.has("entity-type").isEquals("directoryEntry");
            json.has("directoryName").isEquals(directoryName);
            json = json.has("properties").isObject();
            json.properties(2);
            json.has("id").isEquals("123");
            json.has("label").isEquals("Label123");
        }
    }

    @Test
    public void testTranslated() throws Exception {
        String directoryName = "referencedDirectory1";
        Directory directory = this.directoryService.getDirectory(directoryName);
        try (Session session = directory.getSession();){
            DocumentModel entryModel = session.getEntry("678");
            DirectoryEntry entry = new DirectoryEntry(directoryName, entryModel);
            JsonAssert json = this.jsonAssert(entry, RenderingContext.CtxBuilder.locale((Locale)Locale.FRENCH).translate("directoryEntry", new String[]{"label"}).get());
            json.isObject();
            json = json.has("properties").isObject();
            json.has("label").isEquals("hi, it works");
            json = this.jsonAssert(entry);
            json.isObject();
            json = json.has("properties").isObject();
            json.has("label").isEquals("label.test.translated.entry");
            json = this.jsonAssert(entry, RenderingContext.CtxBuilder.translate((String)"directoryEntry", (String[])new String[]{"label"}).get());
            json.isObject();
            json = json.has("properties").isObject();
            json.has("label").isEquals("in english please");
        }
    }

    @Test
    public void testFetched() throws Exception {
        String directoryName = "referencedDirectory1";
        Directory directory = this.directoryService.getDirectory(directoryName);
        try (Session session = directory.getSession();){
            DocumentModel entryModel = session.getEntry("789");
            DirectoryEntry entry = new DirectoryEntry(directoryName, entryModel);
            JsonAssert json = this.jsonAssert(entry, RenderingContext.CtxBuilder.fetch((String)"directoryEntry", (String[])new String[]{"label"}).get());
            json.isObject();
            json = json.has("properties").isObject();
            json = json.has("label").isObject();
            json.properties(3);
            json.has("entity-type").isEquals("directoryEntry");
            json.has("directoryName").isEquals(directoryName);
            json = json.has("properties").isObject();
            json.properties(2);
            json.has("id").isEquals("123");
            json.has("label").isEquals("Label123");
            json = this.jsonAssert(entry, RenderingContext.CtxBuilder.get());
            json.isObject();
            json = json.has("properties").isObject();
            json = json.has("label").isEquals("123");
        }
    }
}

