/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.io;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.junit.Test;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.io.DirectoryEntryListJsonWriter;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@Deploy(value={"org.nuxeo.ecm.directory", "org.nuxeo.ecm.directory.sql"})
@LocalDeploy(value={"org.nuxeo.ecm.directory.resolver.test:test-directory-resolver-contrib.xml"})
public class DirectoryEntryListJsonWriterTest
extends AbstractJsonWriterTest.External<DirectoryEntryListJsonWriter, List<DirectoryEntry>> {
    @Inject
    private DirectoryService directoryService;

    public DirectoryEntryListJsonWriterTest() {
        super(DirectoryEntryListJsonWriter.class, List.class, (Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{DirectoryEntry.class}));
    }

    @Test
    public void test() throws Exception {
        String dirName = "referencedDirectory1";
        Directory directory = this.directoryService.getDirectory(dirName);
        try (Session session = directory.getSession();){
            DocumentModelList entryModels = session.query(new HashMap());
            ArrayList<DirectoryEntry> entries = new ArrayList<DirectoryEntry>();
            for (DocumentModel entryModel : entryModels) {
                entries.add(new DirectoryEntry(dirName, entryModel));
            }
            JsonAssert json = this.jsonAssert(entries);
            json.isObject();
            json.properties(2);
            json.has("entity-type").isEquals("directoryEntries");
            json = json.has("entries").length(entries.size());
            String entryType = "directoryEntry";
            json.childrenContains("entity-type", new String[]{entryType, entryType, entryType, entryType, entryType, entryType, entryType});
            json.childrenContains("directoryName", new String[]{dirName, dirName, dirName, dirName, dirName, dirName, dirName});
            json.childrenContains("properties.id", new String[]{"123", "234", "345", "456", "567", "678", "789"});
        }
    }
}

