/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.registry.MarshallerHelper;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@Deploy(value={"org.nuxeo.ecm.directory", "org.nuxeo.ecm.directory.sql", "org.nuxeo.ecm.core.io"})
@LocalDeploy(value={"org.nuxeo.ecm.directory.resolver.test:test-directory-resolver-contrib.xml"})
public class DocumentFetchJsonDirectoryEntryTest {
    @Inject
    private DirectoryService directoryService;
    @Inject
    private MarshallerRegistry marshallerRegistry;
    @Inject
    private CoreSession coreSession;

    @Test
    public void testReadScalar() throws Exception {
        String jsonDirectory;
        DocumentModel docInput = this.coreSession.createDocumentModel("/", "test", "DirectoryReferencer");
        docInput.setPropertyValue("dr:directory1Ref", (Serializable)((Object)"123"));
        docInput = this.coreSession.createDocument(docInput);
        String jsonDoc = MarshallerHelper.objectToJson((Object)docInput, (RenderingContext)RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).get());
        String directoryName = "referencedDirectory1";
        Directory directory = this.directoryService.getDirectory(directoryName);
        try (Session session = directory.getSession();){
            DocumentModel entryDoc = session.getEntry("234");
            DirectoryEntry entry = new DirectoryEntry(directoryName, entryDoc);
            jsonDirectory = MarshallerHelper.objectToJson((Object)entry, (RenderingContext)RenderingContext.CtxBuilder.get());
        }
        String newJsonDoc = jsonDoc.replace("\"123\"", jsonDirectory);
        Reader reader = this.marshallerRegistry.getReader(RenderingContext.CtxBuilder.session((CoreSession)this.coreSession).get(), DocumentModel.class, MediaType.APPLICATION_JSON_TYPE);
        ByteArrayInputStream input = new ByteArrayInputStream(newJsonDoc.getBytes());
        DocumentModel docUpdate = (DocumentModel)reader.read(DocumentModel.class, DocumentModel.class, MediaType.APPLICATION_JSON_TYPE, (InputStream)input);
        this.coreSession.saveDocument(docUpdate);
        DocumentModel docTest = this.coreSession.getDocument((DocumentRef)new PathRef("/test"));
        Assert.assertEquals((Object)"234", (Object)docTest.getPropertyValue("dr:directory1Ref"));
    }

    @Test
    public void testArrayProperty() throws Exception {
        String jsonDirectory;
        DocumentModel docInput = this.coreSession.createDocumentModel("/", "test", "DirectoryReferencer");
        docInput.setPropertyValue("dr:directory3Refs", (Serializable)new String[]{"123", "234"});
        docInput = this.coreSession.createDocument(docInput);
        String jsonDoc = MarshallerHelper.objectToJson((Object)docInput, (RenderingContext)RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).get());
        String directoryName = "referencedDirectory1";
        Directory directory = this.directoryService.getDirectory(directoryName);
        try (Session session = directory.getSession();){
            DocumentModel entryDoc = session.getEntry("345");
            DirectoryEntry entry = new DirectoryEntry(directoryName, entryDoc);
            jsonDirectory = MarshallerHelper.objectToJson((Object)entry, (RenderingContext)RenderingContext.CtxBuilder.get());
        }
        String newJsonDoc = jsonDoc.replace("\"123\"", jsonDirectory);
        Reader reader = this.marshallerRegistry.getReader(RenderingContext.CtxBuilder.session((CoreSession)this.coreSession).get(), DocumentModel.class, MediaType.APPLICATION_JSON_TYPE);
        ByteArrayInputStream input = new ByteArrayInputStream(newJsonDoc.getBytes());
        DocumentModel docUpdate = (DocumentModel)reader.read(DocumentModel.class, DocumentModel.class, MediaType.APPLICATION_JSON_TYPE, (InputStream)input);
        this.coreSession.saveDocument(docUpdate);
        DocumentModel docTest = this.coreSession.getDocument((DocumentRef)new PathRef("/test"));
        List<String> values = Arrays.asList((String[])docTest.getPropertyValue("dr:directory3Refs"));
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("234"));
        Assert.assertTrue((boolean)values.contains("345"));
    }
}

