/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.service;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.memory.MemoryDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-sql-directories-schema-override.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-bundle.xml"})
public class TestDirectoryServiceRegistration {
    @Inject
    protected RuntimeHarness harness;
    @Inject
    protected DirectoryService directoryService;

    @Test
    public void testOverride() throws Exception {
        Directory dir = this.directoryService.getDirectory("userDirectory");
        Assert.assertTrue((boolean)(dir instanceof SQLDirectory));
        this.harness.deployContrib("org.nuxeo.ecm.directory.sql.tests", "test-directories-memory-factory.xml");
        this.harness.deployContrib("org.nuxeo.ecm.directory.sql.tests", "test-directories-several-factories.xml");
        dir = this.directoryService.getDirectory("userDirectory");
        Assert.assertTrue((boolean)(dir instanceof MemoryDirectory));
    }
}

