/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.local.LoginStack;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.login.test.ClientLoginFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.SimpleFeature;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Features(value={CoreFeature.class, ClientLoginFeature.class})
@Deploy(value={"org.nuxeo.ecm.directory.api", "org.nuxeo.ecm.directory", "org.nuxeo.ecm.core.schema", "org.nuxeo.ecm.directory.types.contrib", "org.nuxeo.ecm.directory.sql"})
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql:nxdirectory-ds.xml"})
public class SQLDirectoryFeature
extends SimpleFeature {
    public static final String USER_DIRECTORY_NAME = "userDirectory";
    public static final String GROUP_DIRECTORY_NAME = "groupDirectory";
    Granularity granularity;
    protected Map<String, Map<String, Map<String, Object>>> allDirectoryData;

    public void configure(FeaturesRunner runner, Binder binder) {
        this.bindDirectory(binder, USER_DIRECTORY_NAME);
        this.bindDirectory(binder, GROUP_DIRECTORY_NAME);
    }

    protected void bindDirectory(Binder binder, final String name) {
        binder.bind(Directory.class).annotatedWith((Annotation)Names.named((String)name)).toProvider((Provider)new Provider<Directory>(){

            public Directory get() {
                return ((DirectoryService)Framework.getService(DirectoryService.class)).getDirectory(name);
            }
        });
    }

    public void beforeRun(FeaturesRunner runner) throws Exception {
        this.granularity = ((CoreFeature)runner.getFeature(CoreFeature.class)).getGranularity();
    }

    public void beforeSetup(FeaturesRunner runner) throws Exception {
        if (this.granularity != Granularity.METHOD) {
            return;
        }
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        this.allDirectoryData = new HashMap<String, Map<String, Map<String, Object>>>();
        for (Directory dir : directoryService.getDirectories()) {
            HashMap<String, Map> data = new HashMap<String, Map>();
            Session session = dir.getSession();
            Throwable throwable = null;
            try {
                DocumentModelList entries = session.query(Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap(), true);
                for (DocumentModel entry : entries) {
                    DataModel dm = entry.getDataModel(dir.getSchema());
                    data.put(entry.getId(), dm.getMap());
                }
                this.allDirectoryData.put(dir.getName(), data);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session == null) continue;
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                session.close();
            }
        }
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTeardown(FeaturesRunner runner) throws Exception {
        if (this.granularity != Granularity.METHOD) {
            return;
        }
        if (this.allDirectoryData == null) {
            return;
        }
        LoginStack loginStack = ClientLoginModule.getThreadLocalLogin();
        loginStack.push((Principal)new SystemPrincipal(null), null, null);
        try {
            DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
            for (Directory directory : directoryService.getDirectories()) {
                Session session = directory.getSession();
                Throwable throwable = null;
                try {
                    List ids = session.getProjection(Collections.emptyMap(), directory.getIdField());
                    for (String id : ids) {
                        session.deleteEntry(id);
                    }
                }
                catch (Throwable ids) {
                    throwable = ids;
                    throw ids;
                }
                finally {
                    if (session == null) continue;
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable ids) {
                            throwable.addSuppressed(ids);
                        }
                        continue;
                    }
                    session.close();
                }
            }
            for (Map.Entry entry : this.allDirectoryData.entrySet()) {
                String directoryName = (String)entry.getKey();
                Directory directory = directoryService.getDirectory(directoryName);
                Collection data = ((Map)entry.getValue()).values();
                Session session = directory.getSession();
                Throwable throwable = null;
                try {
                    for (Map map : data) {
                        try {
                            session.createEntry(map);
                        }
                        catch (DirectoryException e) {
                            if (e.getMessage().contains("already exists") || e.getMessage().contains("Missing id")) continue;
                            throw e;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (session == null) continue;
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    session.close();
                }
            }
        }
        finally {
            loginStack.pop();
        }
        this.allDirectoryData = null;
    }
}

