/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.PasswordHelper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RepositoryConfig(cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-sql-directories-schema-override.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-bundle.xml"})
public abstract class SQLDirectoryTestSuite {
    protected static final String USER_DIR = "userDirectory";
    protected static final String GROUP_DIR = "groupDirectory";
    protected static final String SCHEMA = "user";
    @Inject
    protected DirectoryService directoryService;

    public static Calendar getCalendar(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, milliseconds);
        return cal;
    }

    public static Calendar stripMillis(Calendar calendar) {
        return SQLDirectoryTestSuite.getCalendar(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), 0);
    }

    public static void assertCalendarEquals(Calendar expected, Calendar actual) throws Exception {
        if (expected.equals(actual)) {
            return;
        }
        if (SQLDirectoryTestSuite.stripMillis(expected).equals(SQLDirectoryTestSuite.stripMillis(actual))) {
            return;
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public Session getSession() throws Exception {
        return this.directoryService.open(USER_DIR);
    }

    public SQLDirectory getSQLDirectory() throws Exception {
        return (SQLDirectory)this.directoryService.getDirectory(USER_DIR);
    }

    @Test
    public void testTableReference() throws Exception {
        Reference membersRef = this.directoryService.getDirectory(GROUP_DIR).getReference("members");
        List administrators = membersRef.getTargetIdsForSource("administrators");
        Assert.assertEquals((long)1L, (long)administrators.size());
        Assert.assertTrue((boolean)administrators.contains("Administrator"));
        membersRef.addLinks("administrators", Arrays.asList("user_1"));
        administrators = membersRef.getTargetIdsForSource("administrators");
        Assert.assertEquals((long)2L, (long)administrators.size());
        Assert.assertTrue((boolean)administrators.contains("Administrator"));
        Assert.assertTrue((boolean)administrators.contains("user_1"));
        membersRef.addLinks("administrators", Arrays.asList("user_1", "user_2"));
        administrators = membersRef.getTargetIdsForSource("administrators");
        Assert.assertEquals((long)3L, (long)administrators.size());
        Assert.assertTrue((boolean)administrators.contains("Administrator"));
        Assert.assertTrue((boolean)administrators.contains("user_1"));
        Assert.assertTrue((boolean)administrators.contains("user_2"));
        membersRef.removeLinksForTarget("Administrator");
        administrators = membersRef.getTargetIdsForSource("administrators");
        Assert.assertEquals((long)2L, (long)administrators.size());
        Assert.assertTrue((boolean)administrators.contains("user_1"));
        Assert.assertTrue((boolean)administrators.contains("user_2"));
        membersRef.removeLinksForSource("administrators");
        administrators = membersRef.getTargetIdsForSource("administrators");
        Assert.assertEquals((long)0L, (long)administrators.size());
        membersRef.setTargetIdsForSource("administrators", Arrays.asList("user_1", "user_2"));
        administrators = membersRef.getTargetIdsForSource("administrators");
        Assert.assertEquals((long)2L, (long)administrators.size());
        Assert.assertTrue((boolean)administrators.contains("user_1"));
        Assert.assertTrue((boolean)administrators.contains("user_2"));
        membersRef.setTargetIdsForSource("administrators", Arrays.asList("user_1", "Administrator"));
        administrators = membersRef.getTargetIdsForSource("administrators");
        Assert.assertEquals((long)2L, (long)administrators.size());
        Assert.assertTrue((boolean)administrators.contains("user_1"));
        Assert.assertTrue((boolean)administrators.contains("Administrator"));
        membersRef.setSourceIdsForTarget("Administrator", Arrays.asList("members"));
        administrators = membersRef.getTargetIdsForSource("administrators");
        Assert.assertEquals((long)1L, (long)administrators.size());
        Assert.assertTrue((boolean)administrators.contains("user_1"));
        administrators = membersRef.getSourceIdsForTarget("Administrator");
        Assert.assertEquals((long)1L, (long)administrators.size());
        Assert.assertTrue((boolean)administrators.contains("members"));
        membersRef.setTargetIdsForSource("administrators", Arrays.asList("Administrator"));
        membersRef.setTargetIdsForSource("members", Arrays.asList("user_1"));
    }

    @Test
    public void testCreateEntry() throws Exception {
        List groups;
        try (Session session = this.getSession();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("username", "user_0");
            map.put("password", "pass_0");
            map.put("intField", 5L);
            map.put("dateField", SQLDirectoryTestSuite.getCalendar(1982, 3, 25, 16, 30, 47, 0));
            map.put("groups", Arrays.asList("members", "administrators"));
            DocumentModel dm = session.createEntry(map);
            Assert.assertNotNull((Object)dm);
            Assert.assertEquals((Object)"user_0", (Object)dm.getId());
            String[] schemaNames = dm.getSchemas();
            Assert.assertEquals((long)1L, (long)schemaNames.length);
            Assert.assertEquals((Object)SCHEMA, (Object)schemaNames[0]);
            Assert.assertEquals((Object)"user_0", (Object)dm.getProperty(SCHEMA, "username"));
            Assert.assertEquals((Object)"pass_0", (Object)dm.getProperty(SCHEMA, "password"));
            Assert.assertEquals((Object)5L, (Object)dm.getProperty(SCHEMA, "intField"));
            SQLDirectoryTestSuite.assertCalendarEquals(SQLDirectoryTestSuite.getCalendar(1982, 3, 25, 16, 30, 47, 0), (Calendar)dm.getProperty(SCHEMA, "dateField"));
            groups = (List)dm.getProperty(SCHEMA, "groups");
            Assert.assertEquals((long)2L, (long)groups.size());
            Assert.assertTrue((boolean)groups.contains("administrators"));
            Assert.assertTrue((boolean)groups.contains("members"));
        }
        session = this.getSession();
        var2_2 = null;
        try {
            DocumentModel dm = session.getEntry("user_0");
            Assert.assertNotNull((Object)dm);
            Assert.assertEquals((Object)"user_0", (Object)dm.getId());
            String[] schemaNames = dm.getSchemas();
            Assert.assertEquals((long)1L, (long)schemaNames.length);
            Assert.assertEquals((Object)SCHEMA, (Object)schemaNames[0]);
            Assert.assertEquals((Object)"user_0", (Object)dm.getProperty(SCHEMA, "username"));
            String password = (String)dm.getProperty(SCHEMA, "password");
            Assert.assertFalse((boolean)"pass_0".equals(password));
            Assert.assertTrue((boolean)PasswordHelper.verifyPassword((String)"pass_0", (String)password));
            Assert.assertEquals((Object)5L, (Object)dm.getProperty(SCHEMA, "intField"));
            SQLDirectoryTestSuite.assertCalendarEquals(SQLDirectoryTestSuite.getCalendar(1982, 3, 25, 16, 30, 47, 0), (Calendar)dm.getProperty(SCHEMA, "dateField"));
            groups = (List)dm.getProperty(SCHEMA, "groups");
            Assert.assertEquals((long)2L, (long)groups.size());
            Assert.assertTrue((boolean)groups.contains("administrators"));
            Assert.assertTrue((boolean)groups.contains("members"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    @Test
    public void testGetEntry() throws Exception {
        try (Session session = this.getSession();){
            DocumentModel dm = session.getEntry("user_1");
            Assert.assertEquals((Object)"user_1", (Object)dm.getProperty(SCHEMA, "username"));
            Assert.assertEquals((Object)3L, (Object)dm.getProperty(SCHEMA, "intField"));
            SQLDirectoryTestSuite.assertCalendarEquals(SQLDirectoryTestSuite.getCalendar(2007, 9, 7, 14, 36, 28, 0), (Calendar)dm.getProperty(SCHEMA, "dateField"));
            Assert.assertNull((Object)dm.getProperty(SCHEMA, "company"));
            List groups = (List)dm.getProperty(SCHEMA, "groups");
            Assert.assertEquals((long)2L, (long)groups.size());
            Assert.assertTrue((boolean)groups.contains("group_1"));
            Assert.assertTrue((boolean)groups.contains("members"));
            dm = session.getEntry("Administrator");
            Assert.assertEquals((Object)"Administrator", (Object)dm.getProperty(SCHEMA, "username"));
            Assert.assertEquals((Object)10L, (Object)dm.getProperty(SCHEMA, "intField"));
            SQLDirectoryTestSuite.assertCalendarEquals(SQLDirectoryTestSuite.getCalendar(1982, 3, 25, 16, 30, 47, 123), (Calendar)dm.getProperty(SCHEMA, "dateField"));
            Assert.assertTrue((boolean)((Boolean)dm.getProperty(SCHEMA, "booleanField")));
            groups = (List)dm.getProperty(SCHEMA, "groups");
            Assert.assertEquals((long)1L, (long)groups.size());
            Assert.assertTrue((boolean)groups.contains("administrators"));
        }
    }

    @Test
    public void testGetEntries() throws Exception {
        try (Session session = this.getSession();){
            DocumentModelList entries = session.getEntries();
            Assert.assertEquals((long)3L, (long)entries.size());
            HashMap<String, DocumentModel> entryMap = new HashMap<String, DocumentModel>();
            for (DocumentModel entry : entries) {
                entryMap.put(entry.getId(), entry);
            }
            DocumentModel dm = (DocumentModel)entryMap.get("user_1");
            Assert.assertNotNull((Object)dm);
            Assert.assertEquals((Object)"user_1", (Object)dm.getProperty(SCHEMA, "username"));
            SQLDirectoryTestSuite.assertCalendarEquals(SQLDirectoryTestSuite.getCalendar(2007, 9, 7, 14, 36, 28, 0), (Calendar)dm.getProperty(SCHEMA, "dateField"));
            Assert.assertEquals((Object)3L, (Object)dm.getProperty(SCHEMA, "intField"));
            Assert.assertTrue((boolean)((Boolean)dm.getProperty(SCHEMA, "booleanField")));
            dm = (DocumentModel)entryMap.get("Administrator");
            Assert.assertNotNull((Object)dm);
            Assert.assertEquals((Object)"Administrator", (Object)dm.getProperty(SCHEMA, "username"));
            Assert.assertEquals((Object)10L, (Object)dm.getProperty(SCHEMA, "intField"));
            SQLDirectoryTestSuite.assertCalendarEquals(SQLDirectoryTestSuite.getCalendar(1982, 3, 25, 16, 30, 47, 123), (Calendar)dm.getProperty(SCHEMA, "dateField"));
            dm = (DocumentModel)entryMap.get("user_3");
            Assert.assertFalse((boolean)((Boolean)dm.getProperty(SCHEMA, "booleanField")));
        }
        session = this.directoryService.open(GROUP_DIR);
        var2_2 = null;
        try {
            DocumentModel doc = session.getEntry("administrators");
            Assert.assertEquals((Object)"administrators", (Object)doc.getPropertyValue("group:groupname"));
            Assert.assertEquals((Object)"Administrators group", (Object)doc.getPropertyValue("group:grouplabel"));
            doc = session.getEntry("group_1");
            Assert.assertEquals((Object)"group_1", (Object)doc.getPropertyValue("group:groupname"));
            Serializable label = doc.getPropertyValue("group:grouplabel");
            if (label != null) {
                Assert.assertEquals((Object)"", (Object)label);
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    @Test
    public void testUpdateEntry() throws Exception {
        String password;
        DocumentModel dm;
        try (Session session = this.getSession();){
            dm = session.getEntry("user_1");
            dm.setProperty(SCHEMA, "username", (Object)"user_2");
            dm.setProperty(SCHEMA, "password", (Object)"pass_2");
            dm.setProperty(SCHEMA, "intField", (Object)2L);
            dm.setProperty(SCHEMA, "dateField", (Object)SQLDirectoryTestSuite.getCalendar(2001, 2, 3, 4, 5, 6, 7));
            dm.setProperty(SCHEMA, "groups", Arrays.asList("administrators", "members"));
            session.updateEntry(dm);
        }
        session = this.getSession();
        var2_2 = null;
        try {
            dm = session.getEntry("user_1");
            Assert.assertEquals((Object)"user_1", (Object)dm.getProperty(SCHEMA, "username"));
            password = (String)dm.getProperty(SCHEMA, "password");
            Assert.assertFalse((boolean)"pass_2".equals(password));
            Assert.assertTrue((boolean)PasswordHelper.verifyPassword((String)"pass_2", (String)password));
            Assert.assertEquals((Object)2L, (Object)dm.getProperty(SCHEMA, "intField"));
            SQLDirectoryTestSuite.assertCalendarEquals(SQLDirectoryTestSuite.getCalendar(2001, 2, 3, 4, 5, 6, 7), (Calendar)dm.getProperty(SCHEMA, "dateField"));
            List groups = (List)dm.getProperty(SCHEMA, "groups");
            Assert.assertEquals((long)2L, (long)groups.size());
            Assert.assertTrue((boolean)groups.contains("administrators"));
            Assert.assertTrue((boolean)groups.contains("members"));
            Assert.assertNull((Object)session.getEntry("user_2"));
            dm.setProperty(SCHEMA, "company", (Object)"foo");
            session.updateEntry(dm);
        }
        catch (Throwable dm2) {
            var2_2 = dm2;
            throw dm2;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable dm2) {
                        var2_2.addSuppressed(dm2);
                    }
                } else {
                    session.close();
                }
            }
        }
        session = this.getSession();
        var2_2 = null;
        try {
            dm = session.getEntry("user_1");
            password = (String)dm.getProperty(SCHEMA, "password");
            Assert.assertFalse((boolean)"pass_2".equals(password));
            Assert.assertTrue((boolean)PasswordHelper.verifyPassword((String)"pass_2", (String)password));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    @Test
    public void testDeleteEntry() throws Exception {
        DocumentModel dm;
        try (Session session = this.getSession();){
            dm = session.getEntry("user_1");
            session.deleteEntry(dm);
        }
        session = this.getSession();
        var2_2 = null;
        try {
            dm = session.getEntry("user_1");
            Assert.assertNull((Object)dm);
        }
        catch (Throwable dm2) {
            var2_2 = dm2;
            throw dm2;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable dm2) {
                        var2_2.addSuppressed(dm2);
                    }
                } else {
                    session.close();
                }
            }
        }
        session = this.directoryService.open(GROUP_DIR);
        var2_2 = null;
        try {
            DocumentModel group1 = session.getEntry("group_1");
            List members = (List)group1.getProperty("group", "members");
            Assert.assertTrue((boolean)members.isEmpty());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    @Test
    @Ignore
    public void testDeleteEntryExtended() throws Exception {
        try (Session session = this.getSession();){
            HashMap<String, String> entryMap = new HashMap<String, String>();
            entryMap.put("username", "user_1");
            entryMap.put("email", "second@email");
            DocumentModel dm = session.createEntry(entryMap);
            Assert.assertNotNull((Object)dm);
            Assert.assertEquals((long)3L, (long)session.getEntries().size());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("email", "nosuchemail");
            session.deleteEntry("user_1", map);
            Assert.assertEquals((long)3L, (long)session.getEntries().size());
            map.put("email", "e@m");
            session.deleteEntry("user_1", map);
            Assert.assertEquals((long)2L, (long)session.getEntries().size());
            dm = session.getEntry("user_1");
            Assert.assertEquals((Object)"second@email", (Object)dm.getProperty(SCHEMA, "email"));
            map.clear();
            map.put("company", null);
            session.deleteEntry("user_1", map);
            Assert.assertEquals((long)1L, (long)session.getEntries().size());
        }
    }

    @Test
    public void testQuery1() throws Exception {
        try (Session session = this.getSession();){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("username", "user_1");
            filter.put("firstName", "f");
            DocumentModelList list = session.query(filter);
            Assert.assertEquals((long)1L, (long)list.size());
            DocumentModel docModel = (DocumentModel)list.get(0);
            Assert.assertNotNull((Object)docModel);
            Assert.assertEquals((Object)"user_1", (Object)docModel.getProperty(SCHEMA, "username"));
            Assert.assertEquals((Object)"f", (Object)docModel.getProperty(SCHEMA, "firstName"));
            List groups = (List)docModel.getProperty(SCHEMA, "groups");
            Assert.assertTrue((boolean)groups.isEmpty());
            list = session.query(filter, null, null, true);
            Assert.assertEquals((long)1L, (long)list.size());
            docModel = (DocumentModel)list.get(0);
            Assert.assertNotNull((Object)docModel);
            Assert.assertEquals((Object)"user_1", (Object)docModel.getProperty(SCHEMA, "username"));
            Assert.assertEquals((Object)"f", (Object)docModel.getProperty(SCHEMA, "firstName"));
            groups = (List)docModel.getProperty(SCHEMA, "groups");
            Assert.assertEquals((long)2L, (long)groups.size());
            Assert.assertTrue((boolean)groups.contains("members"));
            Assert.assertTrue((boolean)groups.contains("group_1"));
        }
    }

    @Test
    public void testQuerySubAny() throws Exception {
        try (Session session = this.getSession();){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("username", "er_");
            HashSet<String> set = new HashSet<String>();
            set.add("username");
            DocumentModelList list = session.query(filter, set);
            Assert.assertEquals((long)2L, (long)list.size());
            HashSet<String> usernames = new HashSet<String>();
            for (DocumentModel docModel : list) {
                usernames.add((String)docModel.getProperty(SCHEMA, "username"));
            }
            HashSet<String> expectedUsernames = new HashSet<String>(Arrays.asList("user_1", "user_3"));
            Assert.assertEquals(expectedUsernames, usernames);
        }
    }

    @Test
    public void testQuery2() throws Exception {
        try (Session session = this.getSession();){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("username", "user_1");
            filter.put("password", "pass_x");
            DocumentModelList list = session.query(filter);
            Assert.assertEquals((long)0L, (long)list.size());
        }
    }

    @Test
    public void testQueryCaseInsensitive() throws Exception {
        try (Session session = this.getSession();){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("username", "admini");
            DocumentModelList list = session.query(filter, filter.keySet());
            Assert.assertEquals((long)1L, (long)list.size());
            DocumentModel dm = (DocumentModel)list.get(0);
            Assert.assertEquals((Object)"Administrator", (Object)dm.getProperty(SCHEMA, "username"));
        }
    }

    @Test
    public void testGetProjection() throws Exception {
        try (Session session = this.getSession();){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("username", "user_1");
            List list = session.getProjection(filter, "firstName");
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertTrue((boolean)list.contains("f"));
        }
    }

    @Test
    public void testSearch() throws Exception {
        try (Session session = this.getSession();){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("username", "u");
            List users = session.getProjection(filter, "username");
            Assert.assertEquals((long)0L, (long)users.size());
            users = session.getProjection(filter, filter.keySet(), "username");
            Assert.assertEquals((long)2L, (long)users.size());
            Assert.assertTrue((boolean)users.contains("user_1"));
            filter.put("username", "v");
            users = session.getProjection(filter, filter.keySet(), "username");
            Assert.assertEquals((long)0L, (long)users.size());
            filter.put("username", "*");
            users = session.getProjection(filter, "username");
            Assert.assertEquals((long)0L, (long)users.size());
            filter.put("username", "");
            users = session.getProjection(filter, filter.keySet(), "username");
            Assert.assertEquals((long)3L, (long)users.size());
            Assert.assertTrue((boolean)users.contains("user_1"));
            Assert.assertTrue((boolean)users.contains("Administrator"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsAuthenticating() throws Exception {
        try (Session session = this.getSession();){
            Assert.assertTrue((boolean)session.isAuthenticating());
            SQLDirectoryDescriptor config = this.getSQLDirectory().getDescriptor();
            try {
                config.passwordField = "SomeStrangePassordField";
                Assert.assertFalse((boolean)session.isAuthenticating());
            }
            finally {
                config.passwordField = "password";
            }
        }
    }

    @Test
    public void testAuthenticate() throws Exception {
        try (Session session = this.getSession();){
            Assert.assertTrue((boolean)session.authenticate("Administrator", "Administrator"));
            Assert.assertTrue((boolean)session.authenticate("user_1", "pass_1"));
            Assert.assertTrue((boolean)session.authenticate("user_3", "pass_3"));
            Assert.assertFalse((boolean)session.authenticate("Administrator", "WrongPassword"));
            Assert.assertFalse((boolean)session.authenticate(SCHEMA, ".asdf'23423"));
            Assert.assertFalse((boolean)session.authenticate("NonExistingUser", "whatever"));
        }
    }

    @Test
    public void testCreateFromModel() throws Exception {
        try (Session session = this.getSession();){
            String schema = SCHEMA;
            DocumentModel entry = BaseSession.createEntryModel(null, (String)schema, null, null);
            entry.setProperty(SCHEMA, "username", (Object)"yo");
            Assert.assertNull((Object)session.getEntry("yo"));
            session.createEntry(entry);
            Assert.assertNotNull((Object)session.getEntry("yo"));
            entry.setProperty(SCHEMA, "username", (Object)"Administrator");
            try {
                Assert.assertTrue((boolean)session.hasEntry("Administrator"));
                entry = session.createEntry(entry);
                session.getEntry("Administrator");
                Assert.fail((String)"Should raise an error, entry already exists");
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testHasEntry() throws Exception {
        try (Session session = this.getSession();){
            Assert.assertTrue((boolean)session.hasEntry("Administrator"));
            Assert.assertFalse((boolean)session.hasEntry("foo"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    @LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-sql-directories-alteration-config.xml"})
    public void testColumnCreation() throws Exception {
        AbstractDirectory dirtmp1 = null;
        AbstractDirectory dirtmp2 = null;
        try {
            dirtmp1 = (AbstractDirectory)this.directoryService.getDirectory("tmpdirectory1");
            Assert.assertNotNull((Object)dirtmp1);
            Session session = dirtmp1.getSession();
            String schema1 = "tmpschema1";
            DocumentModel entry = BaseSession.createEntryModel(null, (String)schema1, null, null);
            entry.setProperty(schema1, "id", (Object)"john");
            entry.setProperty(schema1, "label", (Object)"monLabel");
            Assert.assertNull((Object)session.getEntry("john"));
            entry = session.createEntry(entry);
            Assert.assertEquals((Object)"john", (Object)entry.getId());
            Assert.assertNotNull((Object)session.getEntry("john"));
            dirtmp2 = (AbstractDirectory)this.directoryService.getDirectory("tmpdirectory2");
            Assert.assertNotNull((Object)dirtmp2);
            session = dirtmp2.getSession();
            Assert.assertNotNull((Object)session.getEntry("john"));
        }
        finally {
            if (dirtmp1 != null) {
                dirtmp1.shutdown();
            }
            if (dirtmp2 != null) {
                dirtmp2.shutdown();
            }
        }
    }
}

