/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.InMemoryCacheImpl;
import org.nuxeo.ecm.directory.DirectoryCache;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.ecm.directory.sql.SQLDirectoryTestSuite;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@Deploy(value={"org.nuxeo.ecm.core.cache"})
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:sql-directory-default-user-contrib.xml"})
public class TestCacheFallbackOnSQLDirectory
extends SQLDirectoryTestSuite {
    @Test
    public void testGetFromCache() throws DirectoryException, Exception {
        Session sqlSession = this.getSQLDirectory().getSession();
        DirectoryCache cache = this.getSQLDirectory().getCache();
        Assert.assertNotNull((Object)cache.getEntryCache());
        Assert.assertEquals((Object)("cache-" + this.getSQLDirectory().getName()), (Object)cache.getEntryCache().getName());
        Assert.assertEquals(InMemoryCacheImpl.class, ((CacheAttributesChecker)cache.getEntryCache()).getCache().getClass());
        Assert.assertNotNull((Object)cache.getEntryCacheWithoutReferences());
        Assert.assertEquals((Object)("cacheWithoutReference-" + this.getSQLDirectory().getName()), (Object)cache.getEntryCacheWithoutReferences().getName());
        MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        Counter hitsCounter = metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", "userDirectory", "cache", "hits"}));
        Counter missesCounter = metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", "userDirectory", "cache", "misses"}));
        long baseHitsCount = hitsCounter.getCount();
        long baseMissesCount = missesCounter.getCount();
        DocumentModel entry = sqlSession.getEntry("user_1");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)baseHitsCount, (long)hitsCounter.getCount());
        Assert.assertEquals((long)(baseMissesCount + 1L), (long)missesCounter.getCount());
        entry = sqlSession.getEntry("user_1");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)(baseHitsCount + 1L), (long)hitsCounter.getCount());
        Assert.assertEquals((long)(baseMissesCount + 1L), (long)missesCounter.getCount());
        entry = sqlSession.getEntry("user_3");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)(baseHitsCount + 1L), (long)hitsCounter.getCount());
        Assert.assertEquals((long)(baseMissesCount + 2L), (long)missesCounter.getCount());
        entry = sqlSession.getEntry("user_3");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)(baseHitsCount + 2L), (long)hitsCounter.getCount());
        Assert.assertEquals((long)(baseMissesCount + 2L), (long)missesCounter.getCount());
        sqlSession.close();
    }
}

