/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.redis.RedisFeature;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.directory.DirectoryCache;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.ecm.directory.sql.SQLDirectoryTestSuite;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@Deploy(value={"org.nuxeo.ecm.core.cache"})
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:sql-directory-cache-config.xml"})
public class TestCachedSQLDirectory
extends SQLDirectoryTestSuite {
    protected static final String REDIS_CACHE_CONFIG = "sql-directory-redis-cache-config.xml";
    protected static final String ENTRY_CACHE_NAME = "sql-entry-cache";
    protected static final String ENTRY_CACHE_WITHOUT_REFERENCES_NAME = "sql-entry-cache-without-references";
    @Inject
    protected RuntimeHarness harness;

    @Before
    public void setUp() throws Exception {
        if (RedisFeature.setup((RuntimeHarness)this.harness)) {
            this.harness.deployTestContrib("org.nuxeo.ecm.directory.sql.tests", REDIS_CACHE_CONFIG);
            ((WorkManager)Framework.getService(WorkManager.class)).init();
        }
        SQLDirectory dir = this.getSQLDirectory();
        DirectoryCache cache = dir.getCache();
        cache.setEntryCacheName(ENTRY_CACHE_NAME);
        cache.setEntryCacheWithoutReferencesName(ENTRY_CACHE_WITHOUT_REFERENCES_NAME);
    }

    @Test
    public void testGetFromCache() throws DirectoryException, Exception {
        Session sqlSession = this.getSQLDirectory().getSession();
        MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        Counter hitsCounter = metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", "userDirectory", "cache", "hits"}));
        Counter negativeHitsCounter = metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", "userDirectory", "cache", "neghits"}));
        Counter missesCounter = metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", "userDirectory", "cache", "misses"}));
        long baseHitsCount = hitsCounter.getCount();
        long baseNegativeHitsCount = negativeHitsCounter.getCount();
        long baseMissesCount = missesCounter.getCount();
        DocumentModel entry = sqlSession.getEntry("user_1");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)baseHitsCount, (long)hitsCounter.getCount());
        Assert.assertEquals((long)baseNegativeHitsCount, (long)negativeHitsCounter.getCount());
        Assert.assertEquals((long)(baseMissesCount + 1L), (long)missesCounter.getCount());
        entry = sqlSession.getEntry("user_1");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)(baseHitsCount + 1L), (long)hitsCounter.getCount());
        Assert.assertEquals((long)baseNegativeHitsCount, (long)negativeHitsCounter.getCount());
        Assert.assertEquals((long)(baseMissesCount + 1L), (long)missesCounter.getCount());
        entry = sqlSession.getEntry("user_1");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)(baseHitsCount + 2L), (long)hitsCounter.getCount());
        Assert.assertEquals((long)baseNegativeHitsCount, (long)negativeHitsCounter.getCount());
        Assert.assertEquals((long)(baseMissesCount + 1L), (long)missesCounter.getCount());
    }

    @Test
    public void testNegativeCaching() throws Exception {
        DirectoryCache cache = this.getSQLDirectory().getCache();
        cache.setNegativeCaching(Boolean.TRUE);
        try {
            this.doTestNegativeCaching();
        }
        finally {
            cache.setNegativeCaching(null);
        }
    }

    protected void doTestNegativeCaching() throws Exception {
        Session sqlSession = this.getSQLDirectory().getSession();
        MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        Counter hitsCounter = metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", "userDirectory", "cache", "hits"}));
        Counter negativeHitsCounter = metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", "userDirectory", "cache", "neghits"}));
        Counter missesCounter = metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", "userDirectory", "cache", "misses"}));
        long baseHitsCount = hitsCounter.getCount();
        long baseNegativeHitsCount = negativeHitsCounter.getCount();
        long baseMissesCount = missesCounter.getCount();
        DocumentModel entry = sqlSession.getEntry("NO_SUCH_USER");
        Assert.assertNull((Object)entry);
        Assert.assertEquals((long)baseHitsCount, (long)hitsCounter.getCount());
        Assert.assertEquals((long)baseNegativeHitsCount, (long)negativeHitsCounter.getCount());
        Assert.assertEquals((long)(baseMissesCount + 1L), (long)missesCounter.getCount());
        entry = sqlSession.getEntry("NO_SUCH_USER");
        Assert.assertNull((Object)entry);
        Assert.assertEquals((long)baseHitsCount, (long)hitsCounter.getCount());
        Assert.assertEquals((long)(baseNegativeHitsCount + 1L), (long)negativeHitsCounter.getCount());
        Assert.assertEquals((long)(baseMissesCount + 1L), (long)missesCounter.getCount());
        entry = sqlSession.getEntry("NO_SUCH_USER");
        Assert.assertNull((Object)entry);
        Assert.assertEquals((long)baseHitsCount, (long)hitsCounter.getCount());
        Assert.assertEquals((long)(baseNegativeHitsCount + 2L), (long)negativeHitsCounter.getCount());
        Assert.assertEquals((long)(baseMissesCount + 1L), (long)missesCounter.getCount());
    }
}

