/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-sql-directories-schema-override.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-bundle.xml"})
public class TestDescriptorOverride {
    @Inject
    protected RuntimeHarness harness;
    @Inject
    protected DirectoryService directoryService;

    @Test
    public void testOverride() throws Exception {
        SQLDirectory sqlDir = (SQLDirectory)this.directoryService.getDirectory("userDirectory");
        SQLDirectoryDescriptor config = sqlDir.getDescriptor();
        Assert.assertEquals((Object)"always", (Object)config.getCreateTablePolicy());
        Assert.assertEquals((long)100L, (long)config.getQuerySizeLimit());
        Assert.assertFalse((boolean)config.isAutoincrementIdField());
        Assert.assertTrue((boolean)config.isComputeMultiTenantId());
        Assert.assertNull((Object)config.cacheEntryName);
        Assert.assertNull((Object)config.cacheEntryWithoutReferencesName);
        Assert.assertNull((Object)config.negativeCaching);
        Assert.assertEquals((Object)"test-users.csv", (Object)config.getDataFileName());
        this.harness.deployContrib("org.nuxeo.ecm.directory.sql.tests", "test-sql-directories-override-bundle.xml");
        try {
            sqlDir = (SQLDirectory)this.directoryService.getDirectory("userDirectory");
            config = sqlDir.getDescriptor();
            Assert.assertEquals((Object)"never", (Object)config.getCreateTablePolicy());
            Assert.assertEquals((long)123L, (long)config.getQuerySizeLimit());
            Assert.assertTrue((boolean)config.isAutoincrementIdField());
            Assert.assertFalse((boolean)config.isComputeMultiTenantId());
            Assert.assertEquals((Object)"override-entry-cache", (Object)config.cacheEntryName);
            Assert.assertEquals((Object)"override-entry-cache-wo-ref", (Object)config.cacheEntryWithoutReferencesName);
            Assert.assertEquals((Object)Boolean.TRUE, (Object)config.negativeCaching);
            Assert.assertEquals((Object)"test-users.csv", (Object)config.getDataFileName());
            Assert.assertEquals((long)1L, (long)config.getTableReferences().length);
        }
        finally {
            this.harness.undeployContrib("org.nuxeo.ecm.directory.sql.tests", "test-sql-directories-override-bundle.xml");
        }
    }
}

