/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.HashMap;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:filterDirectoryContrib.xml"})
public class TestFilterDirectories {
    @Inject
    protected DirectoryService directoryService;

    @Test
    public void testFilterDirectory() throws Exception {
        Session unfiltredSession = this.directoryService.open("unfiltredTestDirectory");
        Assert.assertNotNull((Object)unfiltredSession);
        Assert.assertEquals((long)5L, (long)unfiltredSession.getEntries().size());
        Assert.assertNotNull((Object)unfiltredSession.getEntry("1"));
        Assert.assertNotNull((Object)unfiltredSession.getEntry("2"));
        Assert.assertNotNull((Object)unfiltredSession.getEntry("5"));
        HashMap<String, String> queryFilter = new HashMap<String, String>();
        queryFilter.put("lang", "en");
        Assert.assertEquals((long)2L, (long)unfiltredSession.query(queryFilter).size());
        Session filtredSession = this.directoryService.open("filtredTestDirectory");
        Assert.assertNotNull((Object)filtredSession);
        Assert.assertEquals((long)2L, (long)filtredSession.getEntries().size());
        Assert.assertNotNull((Object)filtredSession.getEntry("1"));
        Assert.assertNull((Object)filtredSession.getEntry("2"));
        Assert.assertNull((Object)filtredSession.getEntry("5"));
        Assert.assertEquals((long)1L, (long)filtredSession.query(queryFilter).size());
    }
}

