/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.HashMap;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:intIdDirectory-contrib.xml"})
public class TestIntIdField {
    @Inject
    protected DirectoryService directoryService;

    @Test
    public void testIntIdDirectory() throws Exception {
        try (Session session = this.directoryService.open("testIdDirectory");){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", 1);
            map.put("label", "toto");
            DocumentModel entry = session.createEntry(map);
            Assert.assertNotNull((Object)entry);
            map.put("id", 2);
            map.put("label", "titi");
            DocumentModel entry2 = session.createEntry(map);
            Assert.assertNotNull((Object)entry2);
            Assert.assertNotNull((Object)session.getEntry("1"));
            Assert.assertNotNull((Object)session.getEntry("2"));
            Assert.assertNull((Object)session.getEntry("3"));
        }
    }
}

