/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.ecm.directory.sql.SQLDirectoryTestSuite;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@Deploy(value={"org.nuxeo.ecm.core.cache"})
public class TestNoCachedSQLDirectory
extends SQLDirectoryTestSuite {
    @Test
    public void testGetWithNoCache() throws DirectoryException, Exception {
        Session sqlSession = this.getSQLDirectory().getSession();
        MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        Counter hitsCounter = metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", "userDirectory", "cache", "hits"}));
        Counter missesCounter = metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", "userDirectory", "cache", "misses"}));
        long baseHitsCount = hitsCounter.getCount();
        long baseMissesCount = missesCounter.getCount();
        DocumentModel entry = sqlSession.getEntry("user_1");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)baseHitsCount, (long)hitsCounter.getCount());
        Assert.assertEquals((long)baseMissesCount, (long)missesCounter.getCount());
        entry = sqlSession.getEntry("user_1");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)baseHitsCount, (long)hitsCounter.getCount());
        Assert.assertEquals((long)baseMissesCount, (long)missesCounter.getCount());
        entry = sqlSession.getEntry("user_1");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)baseHitsCount, (long)hitsCounter.getCount());
        Assert.assertEquals((long)baseMissesCount, (long)missesCounter.getCount());
        sqlSession.close();
    }
}

