/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.ecm.directory.sql.filter.SQLBetweenFilter;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:pagingDirectory-contrib.xml"})
public class TestPagingComplexFilterDirectory {
    private static final String DIR = "pagingDirectory";
    @Inject
    protected DirectoryService directoryService;

    @Test
    public void testPaging() {
        try (Session session = this.directoryService.open(DIR);){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("label", "Label");
            HashMap<String, String> order = new HashMap<String, String>();
            order.put("id", "ASC");
            DocumentModelList entries = session.query(filter, filter.keySet());
            Assert.assertEquals((long)12L, (long)entries.size());
            Assert.assertEquals((Object)"1", (Object)((DocumentModel)entries.get(0)).getId());
            entries = session.query(filter, filter.keySet(), order, false, 5, -1);
            Assert.assertEquals((long)5L, (long)entries.size());
            Assert.assertEquals((Object)"1", (Object)((DocumentModel)entries.get(0)).getId());
            entries = session.query(filter, filter.keySet(), order, false, 5, 1);
            Assert.assertEquals((long)5L, (long)entries.size());
            Assert.assertEquals((Object)"2", (Object)((DocumentModel)entries.get(0)).getId());
            entries = session.query(filter, filter.keySet(), order, false, 5, 11);
            Assert.assertEquals((long)1L, (long)entries.size());
            Assert.assertEquals((Object)"12", (Object)((DocumentModel)entries.get(0)).getId());
        }
    }

    @Test
    public void testComplexFilter() {
        try (Session session = this.directoryService.open(DIR);){
            GregorianCalendar d121110 = new DateTime(2012, 11, 10, 0, 0, 0, 0).toGregorianCalendar();
            GregorianCalendar d121211 = new DateTime(2012, 12, 11, 0, 0, 0, 0).toGregorianCalendar();
            GregorianCalendar d121224 = new DateTime(2012, 12, 24, 0, 0, 0, 0).toGregorianCalendar();
            SQLBetweenFilter betweenFilter = new SQLBetweenFilter((Calendar)d121110, (Calendar)d121224);
            HashMap<String, Object> filter = new HashMap<String, Object>();
            filter.put("date", betweenFilter);
            DocumentModelList entries = session.query(filter);
            Assert.assertEquals((long)12L, (long)entries.size());
            betweenFilter = new SQLBetweenFilter((Calendar)d121211, (Calendar)d121224);
            filter.put("date", betweenFilter);
            entries = session.query(filter);
            Assert.assertEquals((long)2L, (long)entries.size());
            filter.put("type", "something");
            entries = session.query(filter);
            Assert.assertEquals((long)1L, (long)entries.size());
        }
    }
}

