/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-sql-directories-schema-override.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-bundle.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-multi-refs.xml"})
public class TestSQLDirectoryMultipleReferences {
    protected static final String USER_DIR = "userDirectory";
    protected static final String GROUP_DIR = "groupDirectory";
    protected static final String SCHEMA = "user";
    @Inject
    protected DirectoryService directoryService;

    public Session getSession() throws Exception {
        return this.directoryService.open(USER_DIR);
    }

    @Test
    public void testGetEntry() throws Exception {
        try (Session session = this.getSession();){
            DocumentModel dm = session.getEntry("user_1");
            List groups = (List)dm.getProperty(SCHEMA, "groups");
            Assert.assertEquals((long)3L, (long)groups.size());
            Assert.assertTrue((boolean)groups.contains("group_1"));
            Assert.assertTrue((boolean)groups.contains("members"));
            Assert.assertTrue((boolean)groups.contains("powerusers"));
        }
    }

    @Test
    public void testCreateEntry() throws Exception {
        try (Session session = this.getSession();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("username", "user_0");
            map.put("groups", Arrays.asList("members", "administrators"));
            session.createEntry(map);
        }
        session = this.getSession();
        var2_2 = null;
        try {
            DocumentModel dm = session.getEntry("user_0");
            Assert.assertEquals((Object)"user_0", (Object)dm.getProperty(SCHEMA, "username"));
            List groups = (List)dm.getProperty(SCHEMA, "groups");
            Assert.assertEquals((long)0L, (long)groups.size());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    @Test
    public void testUpdateEntry() throws Exception {
        DocumentModel dm;
        try (Session session = this.getSession();){
            dm = session.getEntry("user_1");
            dm.setProperty(SCHEMA, "password", (Object)"pass_2");
            dm.setProperty(SCHEMA, "groups", Arrays.asList("administrators", "members"));
            session.updateEntry(dm);
        }
        session = this.getSession();
        var2_2 = null;
        try {
            dm = session.getEntry("user_1");
            Assert.assertEquals((Object)"user_1", (Object)dm.getProperty(SCHEMA, "username"));
            List groups = (List)dm.getProperty(SCHEMA, "groups");
            Assert.assertEquals((long)3L, (long)groups.size());
            Assert.assertTrue((boolean)groups.contains("group_1"));
            Assert.assertTrue((boolean)groups.contains("members"));
            Assert.assertTrue((boolean)groups.contains("powerusers"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }
}

