/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-sql-directories-schema-override.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-bundle.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-schema-prefix.xml"})
public class TestSQLDirectorySchemaPrefix {
    private static final String USER_DIR = "userDirectory";
    private static final String SCHEMA = "user";
    @Inject
    protected DirectoryService directoryService;

    public Session getSession() throws Exception {
        return this.directoryService.open(USER_DIR);
    }

    @Test
    public void testSchemaWithPrefix() throws Exception {
        try (Session session = this.getSession();){
            DocumentModel dm = session.getEntry("user_1");
            Assert.assertEquals((Object)"user_1", (Object)dm.getProperty(SCHEMA, "username"));
        }
    }
}

