/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.security.auth.login.LoginException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectorySecurityException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.ecm.platform.login.test.ClientLoginFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class, ClientLoginFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-sql-directories-schema-override.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-bundle.xml"})
public class TestSQLDirectorySecurityDefault {
    @Inject
    ClientLoginFeature dummyLogin;
    @Inject
    @Named(value="userDirectory")
    Directory directory;
    Session session;

    @Before
    public void setUp() {
        this.session = this.directory.getSession();
    }

    @After
    public void tearDown() throws Exception {
        this.session.close();
    }

    @Test
    public void adminCanCreateEntry() throws Exception {
        this.dummyLogin.login("Administrator");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("username", "user_0");
        map.put("password", "pass_0");
        map.put("groups", Arrays.asList("members", "administrators"));
        DocumentModel entry = this.session.createEntry(map);
        entry = this.session.getEntry(entry.getId());
        Assert.assertNotNull((Object)entry);
        this.dummyLogin.logout();
    }

    @Test
    public void adminCanDeleteEntry() throws Exception {
        this.dummyLogin.login("Administrator");
        DocumentModel entry = this.session.getEntry("user_1");
        Assert.assertNotNull((Object)entry);
        this.session.deleteEntry("user_1");
        entry = this.session.getEntry("user_1");
        Assert.assertNull((Object)entry);
        this.dummyLogin.logout();
    }

    @Test
    public void everyoneCantCreateEntry() throws LoginException {
        this.dummyLogin.login("aUser");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("username", "should-not-create");
        map.put("password", "should-not-create");
        map.put("groups", Arrays.asList("members", "administrators"));
        try {
            this.session.createEntry(map);
            Assert.fail((String)"Should not be able to create entry");
        }
        catch (DirectorySecurityException directorySecurityException) {
            // empty catch block
        }
        this.dummyLogin.logout();
    }

    @Test
    public void everyoneCanGetEntry() throws LoginException {
        this.dummyLogin.login("aUser");
        DocumentModel entry = this.session.getEntry("user_3");
        Assert.assertNotNull((Object)entry);
        this.dummyLogin.logout();
    }

    @Test
    public void everyoneCantDeleteEntry() throws Exception {
        this.dummyLogin.login("aUser");
        DocumentModel entry = this.session.getEntry("user_3");
        Assert.assertNotNull((Object)entry);
        try {
            this.session.deleteEntry("user_3");
            Assert.fail((String)"Should not be able to delete entry");
        }
        catch (DirectorySecurityException directorySecurityException) {
            // empty catch block
        }
        entry = this.session.getEntry("user_3");
        Assert.assertNotNull((Object)entry);
        this.dummyLogin.logout();
    }

    @Test
    public void everyoneCanSearch() throws LoginException {
        this.dummyLogin.login("aUser");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", "user_3");
        DocumentModelList results = this.session.query(map);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        this.dummyLogin.logout();
    }
}

