/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.Calendar;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.ecm.directory.sql.TestSQLDirectory;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-sql-directories-schema-override.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-tsv-bundle.xml"})
public class TestSQLDirectoryWithTSVInit {
    private static final String SCHEMA = "user";
    @Inject
    protected DirectoryService directoryService;

    @Test
    public void testGetEntry() throws Exception {
        try (Session session = this.directoryService.open("userDirectory");){
            DocumentModel dm = session.getEntry("AdministratorTSV");
            Assert.assertNotNull((Object)dm);
            Assert.assertEquals((Object)"AdministratorTSV", (Object)dm.getProperty(SCHEMA, "username"));
            Assert.assertEquals((Object)"AdministratorTSV", (Object)dm.getProperty(SCHEMA, "password"));
            Assert.assertEquals((Object)10L, (Object)dm.getProperty(SCHEMA, "intField"));
            TestSQLDirectory.assertCalendarEquals(TestSQLDirectory.getCalendar(1982, 3, 25, 16, 30, 47, 123), (Calendar)dm.getProperty(SCHEMA, "dateField"));
        }
    }
}

