/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import javax.inject.Inject;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.TransactionalConfig;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={LogCaptureFeature.class, CoreFeature.class})
@Deploy(value={"org.nuxeo.ecm.core.schema", "org.nuxeo.ecm.core.api", "org.nuxeo.ecm.core", "org.nuxeo.ecm.directory", "org.nuxeo.ecm.directory.sql"})
@LocalDeploy(value={"org.nuxeo.ecm.directory:test-sql-directories-schema-override.xml", "org.nuxeo.ecm.directory.sql:test-sql-directories-bundle.xml"})
@LogCaptureFeature.FilterWith(value=CloseSessionFilter.class)
@TransactionalConfig(autoStart=false)
public class TestSessionsAreClosedAutomatically {
    protected Directory userDirectory;
    @Inject
    protected LogCaptureFeature.Result caughtEvents;

    @Before
    public void setSingleDataSourceMode() {
        Framework.getProperties().setProperty("nuxeo.db.singleDataSource", "jdbc/NuxeoTestDS");
    }

    @Before
    public void fetchUserDirectory() throws DirectoryException {
        this.userDirectory = ((DirectoryService)Framework.getService(DirectoryService.class)).getDirectory("userDirectory");
        Assert.assertNotNull((Object)this.userDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void hasNoWarns() throws DirectoryException, LogCaptureFeature.NoLogCaptureFilterException {
        boolean started = TransactionHelper.startTransaction();
        try {
            Session session = this.userDirectory.getSession();
            Throwable throwable = null;
            if (session != null) {
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    session.close();
                }
            }
        }
        finally {
            if (started) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
        Assert.assertTrue((boolean)this.caughtEvents.getCaughtEvents().isEmpty());
    }

    @Test
    public void hasWarnsOnCommit() throws DirectoryException, LogCaptureFeature.NoLogCaptureFilterException {
        boolean started = TransactionHelper.startTransaction();
        try {
            Session session = this.userDirectory.getSession();
        }
        finally {
            if (started) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
        this.caughtEvents.assertHasEvent();
    }

    @Test
    public void hasWarnsOnRollback() throws DirectoryException, LogCaptureFeature.NoLogCaptureFilterException {
        boolean started = TransactionHelper.startTransaction();
        try {
            Session session = this.userDirectory.getSession();
        }
        finally {
            if (started) {
                TransactionHelper.setTransactionRollbackOnly();
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
        this.caughtEvents.assertHasEvent();
    }

    public static class CloseSessionFilter
    implements LogCaptureFeature.Filter {
        public boolean accept(LoggingEvent event) {
            if (!SQLDirectory.class.getName().equals(event.getLogger().getName())) {
                return false;
            }
            if (!Level.WARN.equals((Object)event.getLevel())) {
                return false;
            }
            String msg = event.getMessage().toString();
            return msg.startsWith("Closing a sql directory session");
        }
    }
}

