/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql.localconfig;

import java.io.Serializable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@Deploy(value={"org.nuxeo.ecm.directory", "org.nuxeo.ecm.directory.sql", "org.nuxeo.ecm.directory.types.contrib"})
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-sql-directories-schema-override.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-bundle.xml", "org.nuxeo.ecm.directory.sql.tests:test-sql-directories-for-local-configuration-bundle.xml", "org.nuxeo.ecm.directory.sql.tests:test-types-with-directory-local-configuration.xml"})
public class TestLocalConfigurationForSQLDirectory {
    @Inject
    protected DirectoryService dirService;
    @Inject
    protected CoreSession session;
    DocumentModel workspace;

    @Before
    public void setUp() throws Exception {
        this.initRepository();
    }

    @Test
    public void testShouldReturnUserDirectoryWhenNoContextIsGiven() throws Exception {
        Directory dir = this.dirService.getDirectory("userDirectory");
        Assert.assertEquals((Object)"userDirectory", (Object)dir.getName());
        Session dirSession = this.dirService.open("userDirectory");
        Assert.assertEquals((long)3L, (long)dirSession.getEntries().size());
    }

    @Test
    public void testShouldReturnUserDirectoryWhenContextIsNull() throws Exception {
        Directory dir = this.dirService.getDirectory("userDirectory", null);
        Assert.assertEquals((Object)"userDirectory", (Object)dir.getName());
        Session dirSession = this.dirService.open("userDirectory", null);
        Assert.assertEquals((long)3L, (long)dirSession.getEntries().size());
    }

    @Test
    public void testShouldReturnUserDirectoryWhenNoLocalConfigurationSet() throws Exception {
        Directory dir = this.dirService.getDirectory("userDirectory", this.workspace);
        Assert.assertEquals((Object)"userDirectory", (Object)dir.getName());
        Session dirSession = this.dirService.open("userDirectory", this.workspace);
        Assert.assertEquals((long)3L, (long)dirSession.getEntries().size());
    }

    @Test
    public void testShouldReturnUserDirectoryWhenLocalConfigurationSetIsAnEmptyString() throws Exception {
        this.setDirectorySuffix(this.workspace, "          ");
        Directory dir = this.dirService.getDirectory("userDirectory", this.workspace);
        Assert.assertEquals((Object)"userDirectory", (Object)dir.getName());
        Session dirSession = this.dirService.open("userDirectory", this.workspace);
        Assert.assertEquals((long)3L, (long)dirSession.getEntries().size());
    }

    @Test
    public void testShouldReturnUserDirectoryWithSuffixWhenDirectoryContextIsGiven() throws Exception {
        this.setDirectorySuffix(this.workspace, "domain_a");
        Directory dir = this.dirService.getDirectory("userDirectory", this.workspace);
        Assert.assertEquals((Object)"userDirectory_domain_a", (Object)dir.getName());
        Session dirSession = this.dirService.open("userDirectory", this.workspace);
        Assert.assertEquals((long)1L, (long)dirSession.getEntries().size());
    }

    protected void initRepository() {
        this.workspace = this.session.createDocumentModel("Workspace");
        this.workspace.setPathInfo("/", "default-domain");
        this.session.createDocument(this.workspace);
        this.session.save();
    }

    protected void setDirectorySuffix(DocumentModel doc, String directorySuffix) {
        doc.setPropertyValue("dirconf:suffix", (Serializable)((Object)directorySuffix));
        this.session.saveDocument(doc);
        this.session.save();
    }
}

