/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.support.PlainListenableActionFuture;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;

public abstract class ActionRequestBuilder<Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder, Client extends ElasticsearchClient> {
    protected final Request request;
    private final ThreadPool threadPool;
    protected final Client client;

    protected ActionRequestBuilder(Client client, Request request) {
        this.request = request;
        this.client = client;
        this.threadPool = client.threadPool();
    }

    public Request request() {
        return this.request;
    }

    public final RequestBuilder setListenerThreaded(boolean listenerThreaded) {
        ((ActionRequest)this.request).listenerThreaded(listenerThreaded);
        return (RequestBuilder)this;
    }

    public final RequestBuilder putHeader(String key, Object value) {
        ((TransportMessage)this.request).putHeader(key, value);
        return (RequestBuilder)this;
    }

    public ListenableActionFuture<Response> execute() {
        PlainListenableActionFuture future = new PlainListenableActionFuture(((ActionRequest)this.request).listenerThreaded(), this.threadPool);
        this.execute(future);
        return future;
    }

    public Response get() throws ElasticsearchException {
        return (Response)((ActionResponse)this.execute().actionGet());
    }

    public Response get(TimeValue timeout) throws ElasticsearchException {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public Response get(String timeout) throws ElasticsearchException {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public void execute(ActionListener<Response> listener) {
        this.doExecute(listener);
    }

    protected abstract void doExecute(ActionListener<Response> var1);
}

