/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.support.AdapterActionFuture;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractListenableActionFuture<T, L>
extends AdapterActionFuture<T, L>
implements ListenableActionFuture<T> {
    final boolean listenerThreaded;
    final ThreadPool threadPool;
    volatile Object listeners;
    boolean executedListeners = false;

    protected AbstractListenableActionFuture(boolean listenerThreaded, ThreadPool threadPool) {
        this.listenerThreaded = listenerThreaded;
        this.threadPool = threadPool;
    }

    public boolean listenerThreaded() {
        return false;
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public void addListener(ActionListener<T> listener) {
        this.internalAddListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalAddListener(ActionListener<T> listener) {
        boolean executeImmediate = false;
        AbstractListenableActionFuture abstractListenableActionFuture = this;
        synchronized (abstractListenableActionFuture) {
            if (this.executedListeners) {
                executeImmediate = true;
            } else {
                ActionListener<T> listeners = this.listeners;
                if (listeners == null) {
                    listeners = listener;
                } else if (listeners instanceof List) {
                    ((List)this.listeners).add(listener);
                } else {
                    ActionListener<T> orig = listeners;
                    listeners = Lists.newArrayListWithCapacity(2);
                    ((List)((Object)listeners)).add(orig);
                    ((List)((Object)listeners)).add(listener);
                }
                this.listeners = listeners;
            }
        }
        if (executeImmediate) {
            this.executeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        super.done();
        AbstractListenableActionFuture abstractListenableActionFuture = this;
        synchronized (abstractListenableActionFuture) {
            this.executedListeners = true;
        }
        Object listeners = this.listeners;
        if (listeners != null) {
            if (listeners instanceof List) {
                List list = (List)listeners;
                for (Object listener : list) {
                    this.executeListener((ActionListener)listener);
                }
            } else {
                this.executeListener((ActionListener)listeners);
            }
        }
    }

    private void executeListener(final ActionListener<T> listener) {
        if (this.listenerThreaded) {
            try {
                this.threadPool.executor("listener").execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            listener.onResponse(AbstractListenableActionFuture.this.actionGet());
                        }
                        catch (ElasticsearchException e) {
                            listener.onFailure(e);
                        }
                    }
                });
            }
            catch (EsRejectedExecutionException e) {
                listener.onFailure(e);
            }
        } else {
            try {
                listener.onResponse(this.actionGet());
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        }
    }
}

