/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.instance;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class InstanceShardOperationRequest<T extends InstanceShardOperationRequest>
extends ActionRequest<T>
implements IndicesRequest {
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(1L, TimeUnit.MINUTES);
    protected TimeValue timeout = DEFAULT_TIMEOUT;
    protected String index;
    protected int shardId = -1;

    protected InstanceShardOperationRequest() {
    }

    public InstanceShardOperationRequest(String index) {
        this.index = index;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    public String index() {
        return this.index;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public final T index(String index) {
        this.index = index;
        return (T)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final T timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public final T timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.shardId = in.readInt();
        this.timeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeInt(this.shardId);
        this.timeout.writeTo(out);
    }

    public void beforeLocalFork() {
    }
}

