/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.support;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.TransportMessage;

public class Headers {
    public static final String PREFIX = "request.headers";
    public static final Headers EMPTY = new Headers(ImmutableSettings.EMPTY){

        @Override
        public <M extends TransportMessage<?>> M applyTo(M message) {
            return message;
        }
    };
    private final Settings headers;

    @Inject
    public Headers(Settings settings) {
        this.headers = Headers.resolveHeaders(settings);
    }

    public <M extends TransportMessage<?>> M applyTo(M message) {
        for (String key : this.headers.names()) {
            if (message.hasHeader(key)) continue;
            message.putHeader(key, this.headers.get(key));
        }
        return message;
    }

    public Settings headers() {
        return this.headers;
    }

    static Settings resolveHeaders(Settings settings) {
        Settings headers = settings.getAsSettings(PREFIX);
        return headers != null ? headers : ImmutableSettings.EMPTY;
    }
}

