/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public class BlockingClusterStatePublishResponseHandler {
    private final CountDownLatch latch;
    private final Set<DiscoveryNode> pendingNodes = ConcurrentCollections.newConcurrentSet();

    public BlockingClusterStatePublishResponseHandler(Set<DiscoveryNode> publishingToNodes) {
        this.pendingNodes.addAll(publishingToNodes);
        this.latch = new CountDownLatch(this.pendingNodes.size());
    }

    public void onResponse(DiscoveryNode node) {
        boolean found = this.pendingNodes.remove(node);
        assert (found) : "node [" + node + "] already responded or failed";
        this.latch.countDown();
    }

    public void onFailure(DiscoveryNode node, Throwable t) {
        boolean found = this.pendingNodes.remove(node);
        assert (found) : "node [" + node + "] already responded or failed";
        this.latch.countDown();
    }

    public boolean awaitAllNodes(TimeValue timeout) throws InterruptedException {
        boolean success = this.latch.await(timeout.millis(), TimeUnit.MILLISECONDS);
        assert (!success || this.pendingNodes.isEmpty()) : "response count reached 0 but still waiting for some nodes";
        return success;
    }

    public DiscoveryNode[] pendingNodes() {
        return this.pendingNodes.toArray(new DiscoveryNode[0]);
    }
}

