/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local.state.meta;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class LocalAllocateDangledIndices
extends AbstractComponent {
    public static final String ACTION_NAME = "internal:gateway/local/allocate_dangled";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final AllocationService allocationService;

    @Inject
    public LocalAllocateDangledIndices(Settings settings, TransportService transportService, ClusterService clusterService, AllocationService allocationService) {
        super(settings);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        transportService.registerHandler(ACTION_NAME, new AllocateDangledRequestHandler());
    }

    public void allocateDangled(IndexMetaData[] indices, final Listener listener) {
        ClusterState clusterState = this.clusterService.state();
        DiscoveryNode masterNode = clusterState.nodes().masterNode();
        if (masterNode == null) {
            listener.onFailure(new MasterNotDiscoveredException("no master to send allocate dangled request"));
            return;
        }
        AllocateDangledRequest request = new AllocateDangledRequest(this.clusterService.localNode(), indices);
        this.transportService.sendRequest(masterNode, ACTION_NAME, request, new TransportResponseHandler<AllocateDangledResponse>(){

            @Override
            public AllocateDangledResponse newInstance() {
                return new AllocateDangledResponse();
            }

            @Override
            public void handleResponse(AllocateDangledResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }

            @Override
            public String executor() {
                return "same";
            }
        });
    }

    public static class AllocateDangledResponse
    extends TransportResponse {
        private boolean ack;

        AllocateDangledResponse() {
        }

        AllocateDangledResponse(boolean ack) {
            this.ack = ack;
        }

        public boolean ack() {
            return this.ack;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.ack = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.ack);
        }
    }

    static class AllocateDangledRequest
    extends TransportRequest {
        DiscoveryNode fromNode;
        IndexMetaData[] indices;

        AllocateDangledRequest() {
        }

        AllocateDangledRequest(DiscoveryNode fromNode, IndexMetaData[] indices) {
            this.fromNode = fromNode;
            this.indices = indices;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.fromNode = DiscoveryNode.readNode(in);
            this.indices = new IndexMetaData[in.readVInt()];
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = IndexMetaData.Builder.readFrom(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.fromNode.writeTo(out);
            out.writeVInt(this.indices.length);
            for (IndexMetaData indexMetaData : this.indices) {
                IndexMetaData.Builder.writeTo(indexMetaData, out);
            }
        }
    }

    class AllocateDangledRequestHandler
    extends BaseTransportRequestHandler<AllocateDangledRequest> {
        AllocateDangledRequestHandler() {
        }

        @Override
        public AllocateDangledRequest newInstance() {
            return new AllocateDangledRequest();
        }

        @Override
        public void messageReceived(final AllocateDangledRequest request, final TransportChannel channel) throws Exception {
            Object[] indexNames = new String[request.indices.length];
            for (int i = 0; i < request.indices.length; ++i) {
                indexNames[i] = request.indices[i].index();
            }
            LocalAllocateDangledIndices.this.clusterService.submitStateUpdateTask("allocation dangled indices " + Arrays.toString(indexNames), new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    if (currentState.blocks().disableStatePersistence()) {
                        return currentState;
                    }
                    MetaData.Builder metaData = MetaData.builder(currentState.metaData());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                    boolean importNeeded = false;
                    StringBuilder sb = new StringBuilder();
                    for (IndexMetaData indexMetaData : request.indices) {
                        if (currentState.metaData().hasIndex(indexMetaData.index())) continue;
                        if (currentState.metaData().aliases().containsKey(indexMetaData.index())) {
                            LocalAllocateDangledIndices.this.logger.warn("ignoring dangled index [{}] on node [{}] due to an existing alias with the same name", indexMetaData.index(), request.fromNode);
                            continue;
                        }
                        importNeeded = true;
                        metaData.put(indexMetaData, false);
                        blocks.addBlocks(indexMetaData);
                        routingTableBuilder.addAsRecovery(indexMetaData);
                        sb.append("[").append(indexMetaData.index()).append("/").append((Object)indexMetaData.state()).append("]");
                    }
                    if (!importNeeded) {
                        return currentState;
                    }
                    LocalAllocateDangledIndices.this.logger.info("auto importing dangled indices {} from [{}]", sb.toString(), request.fromNode);
                    ClusterState updatedState = ClusterState.builder(currentState).metaData(metaData).blocks(blocks).routingTable(routingTableBuilder).build();
                    RoutingAllocation.Result routingResult = LocalAllocateDangledIndices.this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTableBuilder).build());
                    return ClusterState.builder(updatedState).routingResult(routingResult).build();
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    LocalAllocateDangledIndices.this.logger.error("unexpected failure during [{}]", t, source);
                    try {
                        channel.sendResponse(t);
                    }
                    catch (Exception e) {
                        LocalAllocateDangledIndices.this.logger.error("failed send response for allocating dangled", e, new Object[0]);
                    }
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    try {
                        channel.sendResponse(new AllocateDangledResponse(true));
                    }
                    catch (IOException e) {
                        LocalAllocateDangledIndices.this.logger.error("failed send response for allocating dangled", e, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    public static interface Listener {
        public void onResponse(AllocateDangledResponse var1);

        public void onFailure(Throwable var1);
    }
}

