/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;

public abstract class FieldsVisitor
extends StoredFieldVisitor {
    protected BytesReference source;
    protected Uid uid;
    protected Map<String, List<Object>> fieldsValues;

    public void postProcess(MapperService mapperService) {
        DocumentMapper documentMapper;
        if (this.uid != null && (documentMapper = mapperService.documentMapper(this.uid.type())) != null) {
            this.postProcess(documentMapper);
            return;
        }
        for (Map.Entry<String, List<Object>> entry : this.fields().entrySet()) {
            FieldMappers fieldMappers = mapperService.indexName(entry.getKey());
            if (fieldMappers == null) continue;
            List<Object> fieldValues = entry.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldMappers.mapper().valueForSearch(fieldValues.get(i)));
            }
        }
    }

    public void postProcess(DocumentMapper documentMapper) {
        for (Map.Entry<String, List<Object>> entry : this.fields().entrySet()) {
            FieldMapper fieldMapper = documentMapper.mappers().indexName(entry.getKey()).mapper();
            if (fieldMapper == null) continue;
            List<Object> fieldValues = entry.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldMapper.valueForSearch(fieldValues.get(i)));
            }
        }
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        if ("_source".equals(fieldInfo.name)) {
            this.source = new BytesArray(value);
        } else {
            this.addValue(fieldInfo.name, new BytesRef(value));
        }
    }

    public void stringField(FieldInfo fieldInfo, String value) throws IOException {
        if ("_uid".equals(fieldInfo.name)) {
            this.uid = Uid.createUid(value);
        } else {
            this.addValue(fieldInfo.name, value);
        }
    }

    public void intField(FieldInfo fieldInfo, int value) throws IOException {
        this.addValue(fieldInfo.name, value);
    }

    public void longField(FieldInfo fieldInfo, long value) throws IOException {
        this.addValue(fieldInfo.name, value);
    }

    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
        this.addValue(fieldInfo.name, Float.valueOf(value));
    }

    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
        this.addValue(fieldInfo.name, value);
    }

    public BytesReference source() {
        return this.source;
    }

    public Uid uid() {
        return this.uid;
    }

    public Map<String, List<Object>> fields() {
        return this.fieldsValues != null ? this.fieldsValues : ImmutableMap.of();
    }

    public void reset() {
        if (this.fieldsValues != null) {
            this.fieldsValues.clear();
        }
        this.source = null;
        this.uid = null;
    }

    void addValue(String name, Object value) {
        List<Object> values;
        if (this.fieldsValues == null) {
            this.fieldsValues = Maps.newHashMap();
        }
        if ((values = this.fieldsValues.get(name)) == null) {
            values = new ArrayList<Object>(2);
            this.fieldsValues.put(name, values);
        }
        values.add(value);
    }
}

