/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class FsStats
implements Iterable<Info>,
Streamable,
ToXContent {
    long timestamp;
    Info total;
    Info[] infos;

    FsStats() {
    }

    public FsStats(long timestamp, Info[] infos) {
        this.timestamp = timestamp;
        this.infos = infos;
        this.total = null;
    }

    public Info getTotal() {
        return this.total();
    }

    public Info total() {
        if (this.total != null) {
            return this.total;
        }
        Info res = new Info();
        HashSet<String> seenDevices = new HashSet<String>(this.infos.length);
        for (Info subInfo : this.infos) {
            if (subInfo.dev != null && !seenDevices.add(subInfo.dev)) continue;
            res.add(subInfo);
        }
        this.total = res;
        return res;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Iterator<Info> iterator() {
        return Iterators.forArray(this.infos);
    }

    public static FsStats readFsStats(StreamInput in) throws IOException {
        FsStats stats = new FsStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.infos = new Info[in.readVInt()];
        for (int i = 0; i < this.infos.length; ++i) {
            this.infos[i] = Info.readInfoFrom(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeVInt(this.infos.length);
        for (Info info : this.infos) {
            info.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.FS);
        builder.field(Fields.TIMESTAMP, this.timestamp);
        builder.field(Fields.TOTAL);
        this.total().toXContent(builder, params);
        builder.startArray(Fields.DATA);
        for (Info info : this.infos) {
            info.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString FS = new XContentBuilderString("fs");
        static final XContentBuilderString TIMESTAMP = new XContentBuilderString("timestamp");
        static final XContentBuilderString DATA = new XContentBuilderString("data");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");

        Fields() {
        }
    }

    public static class Info
    implements Streamable,
    ToXContent {
        String path;
        @Nullable
        String mount;
        @Nullable
        String dev;
        long total = -1L;
        long free = -1L;
        long available = -1L;
        long diskReads = -1L;
        long diskWrites = -1L;
        long diskReadBytes = -1L;
        long diskWriteBytes = -1L;
        double diskQueue = -1.0;
        double diskServiceTime = -1.0;

        public Info() {
        }

        public Info(String path, @Nullable String mount, @Nullable String dev, long total, long free, long available, long diskReads, long diskWrites, long diskReadBytes, long diskWriteBytes, double diskQueue, double diskServiceTime) {
            this.path = path;
            this.mount = mount;
            this.dev = dev;
            this.total = total;
            this.free = free;
            this.available = available;
            this.diskReads = diskReads;
            this.diskWrites = diskWrites;
            this.diskReadBytes = diskReadBytes;
            this.diskWriteBytes = diskWriteBytes;
            this.diskQueue = diskQueue;
            this.diskServiceTime = diskServiceTime;
        }

        public static Info readInfoFrom(StreamInput in) throws IOException {
            Info i = new Info();
            i.readFrom(in);
            return i;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.path = in.readOptionalString();
            this.mount = in.readOptionalString();
            this.dev = in.readOptionalString();
            this.total = in.readLong();
            this.free = in.readLong();
            this.available = in.readLong();
            this.diskReads = in.readLong();
            this.diskWrites = in.readLong();
            this.diskReadBytes = in.readLong();
            this.diskWriteBytes = in.readLong();
            this.diskQueue = in.readDouble();
            this.diskServiceTime = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.path);
            out.writeOptionalString(this.mount);
            out.writeOptionalString(this.dev);
            out.writeLong(this.total);
            out.writeLong(this.free);
            out.writeLong(this.available);
            out.writeLong(this.diskReads);
            out.writeLong(this.diskWrites);
            out.writeLong(this.diskReadBytes);
            out.writeLong(this.diskWriteBytes);
            out.writeDouble(this.diskQueue);
            out.writeDouble(this.diskServiceTime);
        }

        public String getPath() {
            return this.path;
        }

        public String getMount() {
            return this.mount;
        }

        public String getDev() {
            return this.dev;
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getAvailable() {
            return new ByteSizeValue(this.available);
        }

        public long getDiskReads() {
            return this.diskReads;
        }

        public long getDiskWrites() {
            return this.diskWrites;
        }

        public long getDiskReadSizeInBytes() {
            return this.diskReadBytes;
        }

        public ByteSizeValue getDiskReadSizeSize() {
            return new ByteSizeValue(this.diskReadBytes);
        }

        public long getDiskWriteSizeInBytes() {
            return this.diskWriteBytes;
        }

        public ByteSizeValue getDiskWriteSizeSize() {
            return new ByteSizeValue(this.diskWriteBytes);
        }

        public double getDiskQueue() {
            return this.diskQueue;
        }

        public double getDiskServiceTime() {
            return this.diskServiceTime;
        }

        private long addLong(long current, long other) {
            if (other == -1L) {
                return current;
            }
            if (current == -1L) {
                return other;
            }
            return current + other;
        }

        private double addDouble(double current, double other) {
            if (other == -1.0) {
                return current;
            }
            if (current == -1.0) {
                return other;
            }
            return current + other;
        }

        public void add(Info info) {
            this.total = this.addLong(this.total, info.total);
            this.free = this.addLong(this.free, info.free);
            this.available = this.addLong(this.available, info.available);
            this.diskReads = this.addLong(this.diskReads, info.diskReads);
            this.diskWrites = this.addLong(this.diskWrites, info.diskWrites);
            this.diskReadBytes = this.addLong(this.diskReadBytes, info.diskReadBytes);
            this.diskWriteBytes = this.addLong(this.diskWriteBytes, info.diskWriteBytes);
            this.diskQueue = this.addDouble(this.diskQueue, info.diskQueue);
            this.diskServiceTime = this.addDouble(this.diskServiceTime, info.diskServiceTime);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.path != null) {
                builder.field(Fields.PATH, this.path, XContentBuilder.FieldCaseConversion.NONE);
            }
            if (this.mount != null) {
                builder.field(Fields.MOUNT, this.mount, XContentBuilder.FieldCaseConversion.NONE);
            }
            if (this.dev != null) {
                builder.field(Fields.DEV, this.dev, XContentBuilder.FieldCaseConversion.NONE);
            }
            if (this.total != -1L) {
                builder.byteSizeField(Fields.TOTAL_IN_BYTES, Fields.TOTAL, this.total);
            }
            if (this.free != -1L) {
                builder.byteSizeField(Fields.FREE_IN_BYTES, Fields.FREE, this.free);
            }
            if (this.available != -1L) {
                builder.byteSizeField(Fields.AVAILABLE_IN_BYTES, Fields.AVAILABLE, this.available);
            }
            long iop = -1L;
            if (this.diskReads != -1L) {
                iop = this.diskReads;
                builder.field(Fields.DISK_READS, this.diskReads);
            }
            if (this.diskWrites != -1L) {
                iop = iop != -1L ? (iop += this.diskWrites) : this.diskWrites;
                builder.field(Fields.DISK_WRITES, this.diskWrites);
            }
            if (iop != -1L) {
                builder.field(Fields.DISK_IO_OP, iop);
            }
            long ioBytes = -1L;
            if (this.diskReadBytes != -1L) {
                ioBytes = this.diskReadBytes;
                builder.byteSizeField(Fields.DISK_READ_SIZE_IN_BYTES, Fields.DISK_READ_SIZE, this.diskReadBytes);
            }
            if (this.diskWriteBytes != -1L) {
                ioBytes = ioBytes != -1L ? (ioBytes += this.diskWriteBytes) : this.diskWriteBytes;
                builder.byteSizeField(Fields.DISK_WRITE_SIZE_IN_BYTES, Fields.DISK_WRITE_SIZE, this.diskWriteBytes);
            }
            if (ioBytes != -1L) {
                builder.byteSizeField(Fields.DISK_IO_IN_BYTES, Fields.DISK_IO_SIZE, ioBytes);
            }
            if (this.diskQueue != -1.0) {
                builder.field(Fields.DISK_QUEUE, Strings.format1Decimals(this.diskQueue, ""));
            }
            if (this.diskServiceTime != -1.0) {
                builder.field(Fields.DISK_SERVICE_TIME, Strings.format1Decimals(this.diskServiceTime, ""));
            }
            builder.endObject();
            return builder;
        }

        static final class Fields {
            static final XContentBuilderString PATH = new XContentBuilderString("path");
            static final XContentBuilderString MOUNT = new XContentBuilderString("mount");
            static final XContentBuilderString DEV = new XContentBuilderString("dev");
            static final XContentBuilderString TOTAL = new XContentBuilderString("total");
            static final XContentBuilderString TOTAL_IN_BYTES = new XContentBuilderString("total_in_bytes");
            static final XContentBuilderString FREE = new XContentBuilderString("free");
            static final XContentBuilderString FREE_IN_BYTES = new XContentBuilderString("free_in_bytes");
            static final XContentBuilderString AVAILABLE = new XContentBuilderString("available");
            static final XContentBuilderString AVAILABLE_IN_BYTES = new XContentBuilderString("available_in_bytes");
            static final XContentBuilderString DISK_READS = new XContentBuilderString("disk_reads");
            static final XContentBuilderString DISK_WRITES = new XContentBuilderString("disk_writes");
            static final XContentBuilderString DISK_IO_OP = new XContentBuilderString("disk_io_op");
            static final XContentBuilderString DISK_READ_SIZE = new XContentBuilderString("disk_read_size");
            static final XContentBuilderString DISK_READ_SIZE_IN_BYTES = new XContentBuilderString("disk_read_size_in_bytes");
            static final XContentBuilderString DISK_WRITE_SIZE = new XContentBuilderString("disk_write_size");
            static final XContentBuilderString DISK_WRITE_SIZE_IN_BYTES = new XContentBuilderString("disk_write_size_in_bytes");
            static final XContentBuilderString DISK_IO_SIZE = new XContentBuilderString("disk_io_size");
            static final XContentBuilderString DISK_IO_IN_BYTES = new XContentBuilderString("disk_io_size_in_bytes");
            static final XContentBuilderString DISK_QUEUE = new XContentBuilderString("disk_queue");
            static final XContentBuilderString DISK_SERVICE_TIME = new XContentBuilderString("disk_service_time");

            Fields() {
            }
        }
    }
}

