/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.runtime.api.Framework;

public class FulltextConfiguration {
    private static final Log log = LogFactory.getLog(FulltextConfiguration.class);
    public static final String ROOT_TYPE = "Root";
    public static final String PROP_TYPE_STRING = "string";
    public static final String PROP_TYPE_BLOB = "blob";
    public static final String FULLTEXT_DEFAULT_INDEX = "default";
    public final Set<String> indexNames = new LinkedHashSet<String>();
    public final Map<String, String> fieldToIndexName = new HashMap<String, String>();
    public final Set<String> indexesAllSimple = new HashSet<String>();
    public final Set<String> indexesAllBinary = new HashSet<String>();
    public final Map<String, Set<String>> indexesByPropPathSimple = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> indexesByPropPathBinary = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> indexesByPropPathExcludedSimple = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> indexesByPropPathExcludedBinary = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> propPathsByIndexSimple = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> propPathsByIndexBinary = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> propPathsExcludedByIndexSimple = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> propPathsExcludedByIndexBinary = new HashMap<String, Set<String>>();
    public final Set<String> excludedTypes = new HashSet<String>();
    public final Set<String> includedTypes = new HashSet<String>();
    public final boolean fulltextSearchDisabled;

    public FulltextConfiguration(FulltextDescriptor fulltextDescriptor) {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        this.fulltextSearchDisabled = fulltextDescriptor.getFulltextSearchDisabled();
        HashSet<String> allSimplePaths = new HashSet<String>();
        HashSet<String> allBinaryPaths = new HashSet<String>();
        PathsFinder pathsFinder = new PathsFinder(allSimplePaths, allBinaryPaths);
        for (Schema schema : schemaManager.getSchemas()) {
            pathsFinder.walkSchema(schema);
        }
        List<FulltextDescriptor.FulltextIndexDescriptor> descs = fulltextDescriptor.getFulltextIndexes();
        if (descs == null) {
            descs = new ArrayList<FulltextDescriptor.FulltextIndexDescriptor>(1);
        }
        if (descs.isEmpty()) {
            descs.add(new FulltextDescriptor.FulltextIndexDescriptor());
        }
        for (FulltextDescriptor.FulltextIndexDescriptor desc : descs) {
            String name = desc.name == null ? FULLTEXT_DEFAULT_INDEX : desc.name;
            this.indexNames.add(name);
            if (desc.fields == null) {
                desc.fields = new HashSet<String>();
            }
            if (desc.excludeFields == null) {
                desc.excludeFields = new HashSet<String>();
            }
            if (desc.fields.size() == 1 && desc.excludeFields.isEmpty()) {
                this.fieldToIndexName.put(desc.fields.iterator().next(), name);
            }
            if (desc.fieldType != null) {
                if (desc.fieldType.equals(PROP_TYPE_STRING)) {
                    this.indexesAllSimple.add(name);
                } else if (desc.fieldType.equals(PROP_TYPE_BLOB)) {
                    this.indexesAllBinary.add(name);
                } else {
                    log.error((Object)("Ignoring unknow repository fulltext configuration fieldType: " + desc.fieldType));
                }
            }
            if (desc.fields.isEmpty() && desc.fieldType == null) {
                this.indexesAllSimple.add(name);
                this.indexesAllBinary.add(name);
            }
            if (this.indexesAllSimple.contains(name)) {
                this.propPathsByIndexSimple.put(name, new HashSet<String>(allSimplePaths));
                for (String path : allSimplePaths) {
                    this.indexesByPropPathSimple.computeIfAbsent(path, p -> new HashSet()).add(name);
                }
            }
            if (this.indexesAllBinary.contains(name)) {
                this.propPathsByIndexBinary.put(name, new HashSet<String>(allBinaryPaths));
                for (String path : allBinaryPaths) {
                    this.indexesByPropPathBinary.computeIfAbsent(path, p -> new HashSet()).add(name);
                }
            }
            if (fulltextDescriptor.getFulltextExcludedTypes() != null) {
                this.excludedTypes.addAll(fulltextDescriptor.getFulltextExcludedTypes());
            }
            if (fulltextDescriptor.getFulltextIncludedTypes() != null) {
                this.includedTypes.addAll(fulltextDescriptor.getFulltextIncludedTypes());
            }
            for (Set fields : Arrays.asList(desc.fields, desc.excludeFields)) {
                boolean include = fields == desc.fields;
                for (String path : fields) {
                    Map<String, Set<String>> propPathsByIndex;
                    Map<String, Set<String>> indexesByPropPath;
                    Field field = schemaManager.getField(path);
                    if (field == null && !path.contains(":")) {
                        int slash = path.indexOf(47);
                        String first = slash == -1 ? path : path.substring(0, slash);
                        for (Schema schema : schemaManager.getSchemas()) {
                            if (schema.getNamespace().hasPrefix() || schema.getField(first) == null) continue;
                            path = schema.getName() + ":" + path;
                            field = schemaManager.getField(path);
                            break;
                        }
                    }
                    if (field == null) {
                        log.error((Object)String.format("Ignoring unknown property '%s' in fulltext configuration: %s", path, name));
                        continue;
                    }
                    Type baseType = this.getBaseType(field.getType());
                    if (baseType instanceof ComplexType && TypeConstants.isContentType((Type)baseType)) {
                        baseType = ((ComplexType)baseType).getField("data").getType();
                    }
                    if (baseType instanceof StringType) {
                        indexesByPropPath = include ? this.indexesByPropPathSimple : this.indexesByPropPathExcludedSimple;
                        propPathsByIndex = include ? this.propPathsByIndexSimple : this.propPathsExcludedByIndexSimple;
                    } else if (baseType instanceof BinaryType) {
                        indexesByPropPath = include ? this.indexesByPropPathBinary : this.indexesByPropPathExcludedBinary;
                        Map<String, Set<String>> map = propPathsByIndex = include ? this.propPathsByIndexBinary : this.propPathsExcludedByIndexBinary;
                        if (!path.endsWith("/data")) {
                            path = path + "/data";
                        }
                    } else {
                        log.error((Object)String.format("Ignoring property '%s' with bad type %s in fulltext configuration: %s", path, field.getType(), name));
                        continue;
                    }
                    indexesByPropPath.computeIfAbsent(path, p -> new HashSet()).add(name);
                    propPathsByIndex.computeIfAbsent(name, n -> new HashSet()).add(path);
                }
            }
        }
        for (DocumentType documentType : schemaManager.getDocumentTypes()) {
            if (!documentType.hasFacet("NotFulltextIndexable")) continue;
            this.excludedTypes.add(documentType.getName());
        }
    }

    protected Type getBaseType(Type type) {
        if (type instanceof SimpleTypeImpl) {
            return this.getBaseType(type.getSuperType());
        }
        if (type instanceof ListType) {
            return this.getBaseType(((ListType)type).getFieldType());
        }
        return type;
    }

    public boolean isFulltextIndexable(String typeName) {
        if (ROOT_TYPE.equals(typeName)) {
            return false;
        }
        return this.includedTypes.contains(typeName) || this.includedTypes.isEmpty() && !this.excludedTypes.contains(typeName);
    }

    public static class PathsFinder {
        protected final Set<String> simplePaths;
        protected final Set<String> binaryPaths;

        public PathsFinder(Set<String> simplePaths, Set<String> binaryPaths) {
            this.simplePaths = simplePaths;
            this.binaryPaths = binaryPaths;
        }

        public void walkSchema(Schema schema) {
            String addPrefix = schema.getNamespace().hasPrefix() ? null : schema.getName();
            this.walkComplexType((ComplexType)schema, null, addPrefix);
        }

        protected void walkComplexType(ComplexType complexType, String path, String addPrefix) {
            for (Field field : complexType.getFields()) {
                String name = field.getName().getPrefixedName();
                String fieldPath = path == null ? name : path + '/' + name;
                this.walkType(field.getType(), fieldPath, addPrefix);
            }
        }

        protected void walkType(Type type, String path, String addPrefix) {
            if (type.isSimpleType()) {
                this.walkSimpleType(type, path, addPrefix);
            } else if (type.isListType()) {
                String listPath = path + "/*";
                Type ftype = ((ListType)type).getField().getType();
                if (ftype.isComplexType()) {
                    this.walkComplexType((ComplexType)ftype, listPath, addPrefix);
                } else {
                    this.walkSimpleType(ftype, listPath, addPrefix);
                }
            } else {
                ComplexType ctype = (ComplexType)type;
                this.walkComplexType(ctype, path, addPrefix);
            }
        }

        protected void walkSimpleType(Type type, String path, String addPrefix) {
            while (type instanceof SimpleTypeImpl) {
                type = type.getSuperType();
            }
            if (type instanceof StringType) {
                this.simplePaths.add(path);
                if (addPrefix != null) {
                    this.simplePaths.add(addPrefix + ":" + path);
                }
            } else if (type instanceof BinaryType) {
                this.binaryPaths.add(path);
                if (addPrefix != null) {
                    this.binaryPaths.add(addPrefix + ":" + path);
                }
            }
        }
    }
}

