/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.core.coding.decode;

import info.simplecloud.core.MetaData;
import info.simplecloud.core.Resource;
import info.simplecloud.core.annotations.Attribute;
import info.simplecloud.core.annotations.Complex;
import info.simplecloud.core.annotations.Extension;
import info.simplecloud.core.coding.ReflectionHelper;
import info.simplecloud.core.coding.decode.IDecodeHandler;
import info.simplecloud.core.coding.decode.IResourceDecoder;
import info.simplecloud.core.exceptions.FactoryNotFoundException;
import info.simplecloud.core.exceptions.InvalidUser;
import info.simplecloud.core.handlers.ComplexHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import x0.scimSchemasCore1.Response;
import x0.scimSchemasCore1.ResponseDocument;

public class XmlDecoder
implements IResourceDecoder {
    @Override
    public void decode(String resourceString, Resource resource) throws InvalidUser {
        try {
            if (!resource.getClass().isAnnotationPresent(Complex.class)) {
                throw new RuntimeException("Missing annotation complex on, '" + resource.getClass().getName() + "'");
            }
            Complex complex = resource.getClass().getAnnotation(Complex.class);
            Class<?> factory = ReflectionHelper.getFactory(complex.xmlDoc());
            Method parse = factory.getMethod("parse", String.class);
            XmlObject xmlDoc = (XmlObject)parse.invoke(null, resourceString);
            String name = complex.xmlType().getName();
            String getterName = "get";
            getterName = String.valueOf(getterName) + name.substring(name.lastIndexOf(46) + 1);
            Object xmlResource2 = xmlDoc.getClass().getMethod(getterName, new Class[0]).invoke((Object)xmlDoc, new Object[0]);
            this.internalDecode(xmlResource2, resource);
            for (Object extension : resource.getExtensions()) {
                if (!extension.getClass().isAnnotationPresent(Extension.class)) {
                    throw new RuntimeException("Extension '" + extension.getClass() + "' misses extension annotation");
                }
                Extension extensionMetaData = extension.getClass().getAnnotation(Extension.class);
                Method[] methodArray = extension.getClass().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.isAnnotationPresent(Attribute.class)) {
                        MetaData metaData = new MetaData(method.getAnnotation(Attribute.class));
                        XmlCursor cursor = xmlDoc.newCursor();
                        cursor.toFirstChild();
                        if (cursor.toChild(extensionMetaData.schema(), metaData.getName())) {
                            Object value = cursor.getObject();
                            if (value instanceof XmlAnySimpleType) {
                                value = ((XmlAnySimpleType)value).getStringValue();
                            }
                            IDecodeHandler decoder = metaData.getDecoder();
                            Object decodedValue = decoder.decodeXml(value, metaData.newInstance(), metaData.getInternalMetaData());
                            String setterName = "s" + method.getName().substring(1);
                            Method setter = extension.getClass().getMethod(setterName, decodedValue.getClass());
                            setter.invoke(extension, decodedValue);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException("Internal error, decoding xml", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error, decoding xml", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Internal error, decoding xml", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error, decoding xml", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Internal error, decoding xml", e);
        }
        catch (FactoryNotFoundException e) {
            throw new RuntimeException("Internal error, decoding xml", e);
        }
    }

    @Override
    public void decode(String resourcesListString, List<Resource> resources, Class<?> type) throws InvalidUser {
        try {
            x0.scimSchemasCore1.Resource[] xmlResourceArray;
            ResponseDocument doc = ResponseDocument.Factory.parse(resourcesListString);
            Response resp = doc.getResponse();
            Response.Resources xmlResources = resp.getResources();
            x0.scimSchemasCore1.Resource[] resourceArray = xmlResourceArray = xmlResources.getResourceArray();
            int n = xmlResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                x0.scimSchemasCore1.Resource res = resourceArray[n2];
                Resource resource = this.internalDecode(res, (Resource)type.newInstance());
                resources.add(resource);
                ++n2;
            }
        }
        catch (XmlException e) {
            throw new InvalidUser("Failed to parse resource set ", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Internal error, decoding xml", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error, decoding xml", e);
        }
    }

    private Resource internalDecode(Object resources, Resource data) throws InvalidUser {
        return (Resource)new ComplexHandler().decodeXml(resources, data, null);
    }
}

