/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.storage.sql.Activator;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class SQLStatement {
    public static final String DIALECT_WITH_NO_SEMICOLON = "noSemicolon";
    public static final String CATEGORY = "#CATEGORY:";
    public final String sql;
    public final List<Tag> tags;

    public SQLStatement(String sql, List<Tag> tags) {
        this.sql = sql;
        this.tags = tags == null ? Collections.emptyList() : tags;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("SQLStatement(");
        for (Tag tag : this.tags) {
            buf.append(tag.key);
            String value = tag.value;
            if (value != null) {
                buf.append(' ');
                buf.append(value);
            }
            buf.append(", ");
        }
        buf.append(this.sql);
        buf.append(')');
        return buf.toString();
    }

    public static Map<String, List<SQLStatement>> read(String filename, Map<String, List<SQLStatement>> statements) throws IOException {
        return SQLStatement.read(filename, statements, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<SQLStatement>> read(String filename, Map<String, List<SQLStatement>> statements, boolean allDDL) throws IOException {
        InputStream is = Activator.getResourceAsStream(filename);
        if (is == null) {
            throw new IOException("Cannot open: " + filename);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String category = null;
        LinkedList<Tag> tags = new LinkedList<Tag>();
        try {
            String line;
            block15: while ((line = reader.readLine()) != null) {
                int colonPos = line.indexOf(58);
                String key = colonPos < 0 ? "" : line.substring(0, colonPos + 1);
                String value = colonPos < 0 ? "" : line.substring(colonPos + 1).trim();
                switch (key) {
                    case "#CATEGORY:": {
                        category = value;
                        continue block15;
                    }
                    case "#TEST:": 
                    case "#IF:": 
                    case "#PROC:": 
                    case "#SET_IF_EMPTY:": 
                    case "#SET_IF_NOT_EMPTY:": {
                        if (value.length() == 0) {
                            value = null;
                        }
                        tags.add(new Tag(key, value));
                        continue block15;
                    }
                }
                if (line.startsWith("#")) continue;
                StringBuilder buf = new StringBuilder();
                boolean read = false;
                while (true) {
                    if (read) {
                        line = reader.readLine();
                    } else {
                        read = true;
                    }
                    if (line == null || line.trim().equals("")) {
                        if (buf.length() == 0) break;
                        String sql = buf.toString().trim();
                        SQLStatement statement = new SQLStatement(sql, tags);
                        List<SQLStatement> catStatements = statements.get(category);
                        if (catStatements == null) {
                            catStatements = new LinkedList<SQLStatement>();
                            statements.put(category, catStatements);
                        }
                        catStatements.add(statement);
                        break;
                    }
                    if (line.startsWith("#")) continue;
                    buf.append(line);
                    buf.append('\n');
                }
                tags = new LinkedList();
                if (line != null) continue;
                break;
            }
        }
        finally {
            reader.close();
        }
        return statements;
    }

    protected static String replaceVars(String sql, Map<String, Serializable> properties) {
        if (properties != null) {
            for (Map.Entry<String, Serializable> en : properties.entrySet()) {
                String key = "${" + en.getKey() + "}";
                String value = String.valueOf(en.getValue());
                sql = sql.replaceAll(Pattern.quote(key), Matcher.quoteReplacement(value));
            }
        }
        return sql;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void execute(List<SQLStatement> statements, String ddlMode, Map<String, Serializable> properties, Dialect dialect, Connection connection, JDBCLogger logger, ListCollector ddlCollector) throws SQLException {
        try (Statement st = connection.createStatement();){
            block34: for (SQLStatement statement : statements) {
                String msg;
                boolean test = false;
                String proc = null;
                HashSet<String> setIfEmpty = new HashSet<String>();
                HashSet<String> setIfNotEmpty = new HashSet<String>();
                for (Tag tag : statement.tags) {
                    switch (tag.key) {
                        case "#TEST:": {
                            test = true;
                            break;
                        }
                        case "#PROC:": {
                            proc = tag.value;
                            break;
                        }
                        case "#IF:": {
                            String expr = tag.value;
                            boolean res = false;
                            for (String key : expr.split(" OR: ")) {
                                Serializable value;
                                boolean neg = key.startsWith("!");
                                if (neg) {
                                    key = key.substring(1).trim();
                                }
                                if ((value = properties.get(key)) == null) {
                                    logger.log("Defaulting to false: " + key);
                                    value = Boolean.FALSE;
                                }
                                if (!(value instanceof Boolean)) {
                                    logger.error("Not a boolean condition: " + key);
                                    continue block34;
                                }
                                if ((Boolean)value == neg) continue;
                                res = true;
                                break;
                            }
                            if (res) break;
                            continue block34;
                        }
                        case "#SET_IF_EMPTY:": {
                            setIfEmpty.add(tag.value);
                            break;
                        }
                        case "#SET_IF_NOT_EMPTY:": {
                            setIfNotEmpty.add(tag.value);
                        }
                    }
                }
                String sql = statement.sql;
                if ((sql = SQLStatement.replaceVars(sql, properties)).startsWith("LOG.DEBUG")) {
                    msg = sql.substring("LOG.DEBUG".length()).trim();
                    logger.log(msg);
                    continue;
                }
                if (sql.startsWith("LOG.INFO")) {
                    msg = sql.substring("LOG.INFO".length()).trim();
                    logger.info(msg);
                    continue;
                }
                if (sql.startsWith("LOG.ERROR")) {
                    msg = sql.substring("LOG.ERROR".length()).trim();
                    logger.error(msg);
                    continue;
                }
                if (sql.startsWith("LOG.FATAL")) {
                    msg = sql.substring("LOG.FATAL".length()).trim();
                    logger.error(msg);
                    throw new SQLException("Fatal error: " + msg);
                }
                if (sql.endsWith(";") && properties.containsKey(DIALECT_WITH_NO_SEMICOLON)) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                try {
                    if (test) {
                        logger.log(sql.replace("\n", "\n    "));
                        ResultSet rs = st.executeQuery(sql);
                        Object object = null;
                        try {
                            boolean empty = !rs.next();
                            properties.put("emptyResult", Boolean.valueOf(empty));
                            logger.log("  -> emptyResult = " + empty);
                            if (empty) {
                                for (String prop : setIfEmpty) {
                                    properties.put(prop, Boolean.TRUE);
                                    logger.log("  -> " + prop + " = true");
                                }
                                continue;
                            }
                            for (String prop : setIfNotEmpty) {
                                logger.log("  -> " + prop + " = true");
                            }
                            continue;
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (rs == null) continue;
                            if (object != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                continue;
                            }
                            rs.close();
                            continue;
                        }
                    }
                    if (proc != null) {
                        ddlCollector.addAll(dialect.checkStoredProcedure(proc, sql, ddlMode, connection, logger, properties));
                        continue;
                    }
                    if (ddlCollector != null) {
                        ddlCollector.add(sql);
                        continue;
                    }
                    logger.log(sql.replace("\n", "\n    "));
                    st.execute(sql);
                }
                catch (SQLException e) {
                    throw new SQLException("Error executing: " + sql + " : " + e.getMessage(), e);
                    return;
                }
            }
        }
    }

    public static class ListCollector {
        private final List<String> list = new ArrayList<String>();

        public void add(String string) {
            this.list.add(string);
        }

        public void addAll(List<String> strings) {
            this.list.addAll(strings);
        }

        public List<String> getStrings() {
            return this.list;
        }
    }

    public static class Tag {
        public static final String TAG_TEST = "#TEST:";
        public static final String TAG_IF = "#IF:";
        public static final String TAG_PROC = "#PROC:";
        public static final String TAG_SET_IF_EMPTY = "#SET_IF_EMPTY:";
        public static final String TAG_SET_IF_NOT_EMPTY = "#SET_IF_NOT_EMPTY:";
        public static final String VAR_EMPTY_RESULT = "emptyResult";
        public final String key;
        public final String value;

        public Tag(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

