/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.collections.api.FavoritesManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.platform.web.common.locale.LocaleProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class FavoritesManagerImpl
extends DefaultComponent
implements FavoritesManager {
    @Override
    public void addToFavorites(DocumentModel document, CoreSession session) {
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        collectionManager.addToCollection(this.getFavorites(document, session), document, session);
    }

    @Override
    public boolean canAddToFavorites(DocumentModel document) {
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        return collectionManager.isCollectable(document);
    }

    protected DocumentModel createFavorites(CoreSession session, DocumentModel userWorkspace) {
        DocumentModel doc = session.createDocumentModel(userWorkspace.getPath().toString(), "Favorites", "Favorites");
        String title = null;
        try {
            title = I18NUtils.getMessageString((String)"messages", (String)"label.myFavorites.title", (Object[])new Object[0], (Locale)this.getLocale(session));
        }
        catch (MissingResourceException e) {
            title = "Favorites";
        }
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
        doc.setPropertyValue("dc:description", (Serializable)((Object)""));
        doc = session.createDocument(doc);
        ACPImpl acp = new ACPImpl();
        ACE denyEverything = new ACE("Everyone", "Everything", false);
        ACE allowEverything = new ACE(session.getPrincipal().getName(), "Everything", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{allowEverything, denyEverything});
        acp.addACL((ACL)acl);
        doc.setACP((ACP)acp, true);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentModel getFavorites(DocumentModel context, CoreSession session) {
        UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        DocumentModel userWorkspace = userWorkspaceService.getCurrentUserPersonalWorkspace(session, context);
        if (userWorkspace == null) {
            return null;
        }
        PathRef lookupRef = new PathRef(userWorkspace.getPath().toString(), "Favorites");
        if (session.exists((DocumentRef)lookupRef)) {
            return session.getChild(userWorkspace.getRef(), "Favorites");
        }
        FavoritesManagerImpl favoritesManagerImpl = this;
        synchronized (favoritesManagerImpl) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
            if (!session.exists((DocumentRef)lookupRef)) {
                boolean succeed = false;
                try {
                    this.createFavorites(session, userWorkspace);
                    succeed = true;
                }
                finally {
                    if (succeed) {
                        TransactionHelper.commitOrRollbackTransaction();
                        TransactionHelper.startTransaction();
                    }
                }
            }
            return session.getDocument((DocumentRef)lookupRef);
        }
    }

    protected Locale getLocale(CoreSession session) {
        Locale locale = null;
        locale = ((LocaleProvider)Framework.getLocalService(LocaleProvider.class)).getLocale(session);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return new Locale(Locale.getDefault().getLanguage());
    }

    @Override
    public boolean isFavorite(DocumentModel document, CoreSession session) {
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        return collectionManager.isInCollection(this.getFavorites(document, session), document, session);
    }

    @Override
    public void removeFromFavorites(DocumentModel document, CoreSession session) {
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        collectionManager.removeFromCollection(this.getFavorites(document, session), document, session);
    }
}

