/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.test;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteNotLockedException;
import org.nuxeo.ecm.platform.routing.test.WorkflowFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={WorkflowFeature.class})
@Ignore
public class AbstractGraphRouteTest {
    protected DocumentModel doc;
    protected DocumentModel routeDoc;
    protected static final String TYPE_ROUTE_NODE = "RouteNode";

    protected DocumentModel createRoute(String name, CoreSession session) throws PropertyException {
        DocumentModel route = session.createDocumentModel("/", name, "DocumentRoute");
        route.setPropertyValue("stepf:execution", (Serializable)((Object)DocumentRoutingConstants.ExecutionTypeValues.graph.name()));
        route.setPropertyValue("dc:title", (Serializable)((Object)name));
        route.setPropertyValue("docri:participatingDocuments", (Serializable)((Object)Collections.singletonList(this.doc.getId())));
        return session.createDocument(route);
    }

    protected DocumentModel createNode(DocumentModel route, String name, CoreSession session) throws PropertyException {
        DocumentModel node = session.createDocumentModel(route.getPathAsString(), name, TYPE_ROUTE_NODE);
        node.setPropertyValue("rnode:nodeId", (Serializable)((Object)name));
        return session.createDocument(node);
    }

    protected Map<String, Serializable> transition(String name, String target, String condition) {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("name", (Serializable)((Object)name));
        m.put("targetId", (Serializable)((Object)target));
        m.put("condition", (Serializable)((Object)condition));
        return m;
    }

    protected Map<String, Serializable> transition(String name, String target, String condition, String chainId) {
        Map<String, Serializable> m = this.transition(name, target, condition);
        m.put("chain", (Serializable)((Object)chainId));
        return m;
    }

    protected Map<String, Serializable> transition(String name, String target) {
        return this.transition(name, target, "true");
    }

    protected void setTransitions(DocumentModel node, Map<String, Serializable> ... transitions) {
        node.setPropertyValue("rnode:transitions", (Serializable)((Object)Arrays.asList(transitions)));
    }

    protected Map<String, Serializable> button(String name, String label, String filter) {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("name", (Serializable)((Object)name));
        m.put("label", (Serializable)((Object)label));
        m.put("filter", (Serializable)((Object)filter));
        return m;
    }

    protected void setButtons(DocumentModel node, Map<String, Serializable> ... buttons) {
        node.setPropertyValue("rnode:taskButtons", (Serializable)((Object)Arrays.asList(buttons)));
    }

    protected DocumentRoute instantiateAndRun(CoreSession session) {
        return this.instantiateAndRun(session, null);
    }

    protected DocumentRoute instantiateAndRun(CoreSession session, Map<String, Serializable> map) {
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        DocumentRoute route = (DocumentRoute)this.routeDoc.getAdapter(DocumentRoute.class);
        if (!route.isValidated()) {
            route = routing.validateRouteModel(route, session);
        }
        session.save();
        String id = routing.createNewInstance(route.getDocument().getName(), Collections.singletonList(this.doc.getId()), map, session, true);
        return (DocumentRoute)session.getDocument((DocumentRef)new IdRef(id)).getAdapter(DocumentRoute.class);
    }

    protected DocumentRoute instantiateAndRun(CoreSession session, List<String> docIds, Map<String, Serializable> map) {
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        DocumentRoute route = this.validate(this.routeDoc, session);
        String id = ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).createNewInstance(route.getDocument().getName(), docIds, map, session, true);
        return (DocumentRoute)session.getDocument((DocumentRef)new IdRef(id)).getAdapter(DocumentRoute.class);
    }

    protected DocumentRoute validate(DocumentModel routeDoc, CoreSession session) throws DocumentRouteNotLockedException {
        DocumentRoute route = (DocumentRoute)routeDoc.getAdapter(DocumentRoute.class);
        if (!route.isValidated()) {
            route = ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).validateRouteModel(route, session);
        }
        return route;
    }
}

