/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.test;

import java.io.Serializable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.content.template.service.ContentTemplateService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.ecm.platform.routing.test.CounterListener;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@Ignore
@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@Deploy(value={"org.nuxeo.ecm.platform.content.template", "org.nuxeo.ecm.automation.core", "org.nuxeo.ecm.directory", "org.nuxeo.ecm.platform.usermanager", "org.nuxeo.ecm.directory.types.contrib", "org.nuxeo.ecm.directory.sql", "org.nuxeo.ecm.platform.userworkspace.core", "org.nuxeo.ecm.platform.userworkspace.types", "org.nuxeo.ecm.platform.types.api", "org.nuxeo.ecm.platform.query.api", "org.nuxeo.ecm.platform.task.api", "org.nuxeo.ecm.platform.task.core", "org.nuxeo.ecm.platform.filemanager.api", "org.nuxeo.ecm.platform.filemanager.core", "org.nuxeo.ecm.platform.routing.core"})
@LocalDeploy(value={"org.nuxeo.ecm.platform.test:test-usermanagerimpl/directory-config.xml", "org.nuxeo.ecm.platform.routing.core.test:OSGI-INF/test-sql-directories-contrib.xml", "org.nuxeo.ecm.platform.routing.core.test:OSGI-INF/test-graph-types-contrib.xml", "org.nuxeo.ecm.platform.audit:OSGI-INF/core-type-contrib.xml"})
public class DocumentRoutingTestCase {
    public static final String ROOT_PATH = "/";
    public static final String WORKSPACES_PATH = "/default-domain/workspaces";
    public static final String TEST_BUNDLE = "org.nuxeo.ecm.platform.routing.core.test";
    public static final String ROUTE1 = "route1";
    @Inject
    protected CoreSession session;
    @Inject
    protected DocumentRoutingEngineService engineService;
    @Inject
    protected DocumentRoutingService service;
    @Inject
    protected WorkManager workManager;
    @Inject
    protected ContentTemplateService ctService;

    @Before
    public void setUp() throws Exception {
        CounterListener.resetCouner();
        this.service.invalidateRouteModelsCache();
        this.workManager.init();
        DocumentModel root = this.session.getRootDocument();
        this.ctService.executeFactoryForType(root);
        DocumentModel workspaces = this.session.getDocument((DocumentRef)new PathRef(WORKSPACES_PATH));
        Assert.assertNotNull((Object)workspaces);
        ACP acp = workspaces.getACP();
        ACL acl = acp.getOrCreateACL("local");
        acl.add(new ACE("bob", "ReadWrite", true));
        this.session.setACP(workspaces.getRef(), acp, true);
        this.session.saveDocument(workspaces);
        this.session.save();
    }

    public DocumentModel createDocumentRouteModel(CoreSession session, String name, String path) {
        DocumentModel route = this.createDocumentModel(session, name, "DocumentRoute", path);
        this.createDocumentModel(session, "step1", "DocumentRouteStep", route.getPathAsString());
        this.createDocumentModel(session, "step2", "DocumentRouteStep", route.getPathAsString());
        DocumentModel parallelFolder1 = this.createDocumentModel(session, "parallel1", "StepFolder", route.getPathAsString());
        parallelFolder1.setPropertyValue("stepf:execution", (Serializable)((Object)DocumentRoutingConstants.ExecutionTypeValues.parallel.name()));
        session.saveDocument(parallelFolder1);
        this.createDocumentModel(session, "step31", "DocumentRouteStep", parallelFolder1.getPathAsString());
        this.createDocumentModel(session, "step32", "DocumentRouteStep", parallelFolder1.getPathAsString());
        session.save();
        return route;
    }

    public DocumentModel createDocumentRouteModelWithConditionalFolder(CoreSession session, String name, String path) {
        DocumentModel route = this.createDocumentModel(session, name, "DocumentRoute", path);
        this.createDocumentModel(session, "step1", "DocumentRouteStep", route.getPathAsString());
        DocumentModel condFolder = this.createDocumentModel(session, "conditionalStep2", "ConditionalStepFolder", route.getPathAsString());
        this.createDocumentModel(session, "executeIfOption1", "DocumentRouteStep", condFolder.getPathAsString() + "/option1");
        this.createDocumentModel(session, "executeIfOption2", "DocumentRouteStep", condFolder.getPathAsString() + "/option2");
        this.createDocumentModel(session, "step3", "DocumentRouteStep", route.getPathAsString());
        session.save();
        return route;
    }

    public DocumentModel createDocumentModel(CoreSession session, String name, String type, String path) {
        DocumentModel route1 = session.createDocumentModel(path, name, type);
        route1.setPropertyValue("dc:title", (Serializable)((Object)name));
        return session.createDocument(route1);
    }

    public DocumentRoute createDocumentRoute(CoreSession session, String name) {
        DocumentModel model = this.createDocumentRouteModel(session, name, WORKSPACES_PATH);
        return (DocumentRoute)model.getAdapter(DocumentRoute.class);
    }

    public DocumentRoute createDocumentRouteWithConditionalFolder(CoreSession session, String name) {
        DocumentModel model = this.createDocumentRouteModelWithConditionalFolder(session, name, WORKSPACES_PATH);
        return (DocumentRoute)model.getAdapter(DocumentRoute.class);
    }

    protected DocumentModel createTestDocument(String name, CoreSession session) {
        return this.createDocumentModel(session, name, "Note", WORKSPACES_PATH);
    }
}

