/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.test;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.test.AbstractGraphRouteTest;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class GraphRouteTest
extends AbstractGraphRouteTest {
    protected static final String TYPE_ROUTE_NODE = "RouteNode";
    @Inject
    protected CoreFeature coreFeature;
    @Inject
    protected RuntimeHarness harness;
    @Inject
    protected CoreSession session;
    @Inject
    protected DocumentRoutingService routing;
    @Inject
    protected UserManager userManager;
    @Inject
    protected TaskService taskService;
    @Inject
    protected AutomationService automationService;

    @Before
    public void setUp() throws Exception {
        Assert.assertNotNull((Object)this.routing);
        this.routing.invalidateRouteModelsCache();
        this.doc = this.session.createDocumentModel("/", "file", "File");
        this.doc.setPropertyValue("dc:title", (Serializable)((Object)"file"));
        this.doc = this.session.createDocument(this.doc);
        this.routeDoc = this.createRoute("myroute", this.session);
    }

    @After
    public void tearDown() {
    }

    protected CoreSession openSession(NuxeoPrincipal principal) {
        return this.coreFeature.openCoreSession(principal);
    }

    protected Map<String, Serializable> keyvalue(String key, String value) {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("key", (Serializable)((Object)key));
        m.put("value", (Serializable)((Object)value));
        return m;
    }

    protected void setSubRouteVariables(DocumentModel node, Map<String, Serializable> ... keyvalues) {
        node.setPropertyValue("rnode:subRouteVariables", (Serializable)((Object)Arrays.asList(keyvalues)));
    }

    @Test
    public void testExceptionIfNoStartNode() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1 = this.session.saveDocument(node1);
        try {
            this.instantiateAndRun(this.session);
            Assert.fail((String)"Should throw because no start node");
        }
        catch (DocumentRouteException e) {
            String msg = e.getMessage();
            Assert.assertTrue((String)msg, (boolean)msg.contains("No start node for graph"));
        }
    }

    @Test
    public void testExceptionIfNoTrueTransition() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        node1 = this.session.saveDocument(node1);
        try {
            this.instantiateAndRun(this.session);
            Assert.fail((String)"Should throw because no transition is true");
        }
        catch (DocumentRouteException e) {
            String msg = e.getMessage();
            Assert.assertTrue((String)msg, (boolean)msg.contains("No transition evaluated to true"));
        }
    }

    @Test
    public void testExceptionIfTransitionIsNotBoolean() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node1", "'notaboolean'"));
        node1 = this.session.saveDocument(node1);
        try {
            this.instantiateAndRun(this.session);
            Assert.fail((String)"Should throw because transition condition is no bool");
        }
        catch (DocumentRouteException e) {
            String msg = e.getMessage();
            Assert.assertTrue((String)msg, (boolean)msg.contains("does not evaluate to a boolean"));
        }
    }

    @Test
    public void testOneNodeStartStop() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node1 = this.session.saveDocument(node1);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertTrue((boolean)route.isDone());
    }

    @Test
    public void testStartWithMap() throws Exception {
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node1 = this.session.saveDocument(node1);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("stringfield", (Serializable)((Object)"ABC"));
        DocumentRoute route = this.instantiateAndRun(this.session, Collections.singletonList(this.doc.getId()), map);
        Assert.assertTrue((boolean)route.isDone());
        String v = (String)((Object)route.getDocument().getPropertyValue("fctroute1:stringfield"));
        Assert.assertEquals((Object)"ABC", (Object)v);
    }

    @Test
    public void testExceptionIfLooping() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node1"));
        node1 = this.session.saveDocument(node1);
        try {
            this.instantiateAndRun(this.session);
            Assert.fail((String)"Should throw because execution is looping");
        }
        catch (DocumentRouteException e) {
            String msg = e.getMessage();
            Assert.assertTrue((String)msg, (boolean)msg.contains("Execution is looping"));
        }
    }

    @Test
    public void testAutomationChains() throws Exception {
        Assert.assertEquals((Object)"file", (Object)this.doc.getTitle());
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_title1"));
        node1.setPropertyValue("rnode:outputChain", (Serializable)((Object)"testchain_title2"));
        node1 = this.session.saveDocument(node1);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertTrue((boolean)route.isDone());
        this.doc.refresh();
        Assert.assertEquals((Object)"title 2", (Object)this.doc.getTitle());
    }

    @Test
    public void testAutomationChainVariableChange() throws Exception {
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_stringfield"));
        node1.setPropertyValue("rnode:outputChain", (Serializable)((Object)"testchain_stringfield2"));
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1 = this.session.saveDocument(node1);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertTrue((boolean)route.isDone());
        DocumentModel r = route.getDocument();
        String s = (String)((Object)r.getPropertyValue("fctroute1:stringfield"));
        Assert.assertEquals((Object)"foo", (Object)s);
        UserPrincipal admin = new UserPrincipal("admin", null, false, true);
        try (CoreSession ses = this.openSession((NuxeoPrincipal)admin);){
            DocumentModel c = (DocumentModel)ses.getChildren(r.getRef()).get(0);
            s = (String)((Object)c.getPropertyValue("stringfield2"));
            Assert.assertEquals((Object)"bar", (Object)s);
        }
    }

    @Test
    public void testSimpleTransition() throws Exception {
        Assert.assertEquals((Object)"file", (Object)this.doc.getTitle());
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "true", "testchain_title1"), this.transition("trans2", "node2", "false", "testchain_title2"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertTrue((boolean)route.isDone());
        this.doc.refresh();
        Assert.assertEquals((Object)"title 1", (Object)this.doc.getTitle());
        DocumentModel doc1 = ((GraphRoute)route).getNode("node1").getDocument();
        Assert.assertEquals((Object)1L, (Object)doc1.getPropertyValue("rnode:count"));
        Assert.assertNotNull((Object)doc1.getPropertyValue("rnode:startDate"));
        Assert.assertNotNull((Object)doc1.getPropertyValue("rnode:endDate"));
    }

    @Test
    public void testResume() throws Exception {
        Assert.assertEquals((Object)"file", (Object)this.doc.getTitle());
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans12", "node2", "true", "testchain_title1"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        this.setTransitions(node2, this.transition("trans23", "node3"));
        node2 = this.session.saveDocument(node2);
        DocumentModel node3 = this.createNode(this.routeDoc, "node3", this.session);
        node3.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node3 = this.session.saveDocument(node3);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertFalse((boolean)route.isDone());
        this.routing.resumeInstance(route.getDocument().getId(), "node2", null, null, this.session);
        route.getDocument().refresh();
        Assert.assertTrue((boolean)route.isDone());
    }

    @Test
    public void testCancel() throws Exception {
        Assert.assertEquals((Object)"file", (Object)this.doc.getTitle());
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans12", "node2", "true", "testchain_title1"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        this.setTransitions(node2, this.transition("trans23", "node3"));
        node2 = this.session.saveDocument(node2);
        DocumentModel node3 = this.createNode(this.routeDoc, "node3", this.session);
        node3.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node3 = this.session.saveDocument(node3);
        DocumentModelList cancelledTasks = this.session.query("Select * from TaskDoc where ecm:currentLifeCycleState = 'cancelled'");
        Assert.assertEquals((long)0L, (long)cancelledTasks.size());
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertFalse((boolean)route.isDone());
        List tasks = this.taskService.getTaskInstances(this.doc, (NuxeoPrincipal)null, this.session);
        Assert.assertEquals((long)1L, (long)tasks.size());
        route.cancel(this.session);
        route.getDocument().refresh();
        Assert.assertTrue((boolean)route.isCanceled());
        this.session.save();
        tasks = this.taskService.getTaskInstances(this.doc, (NuxeoPrincipal)null, this.session);
        Assert.assertEquals((long)0L, (long)tasks.size());
        cancelledTasks = this.session.query("Select * from TaskDoc where ecm:currentLifeCycleState = 'cancelled'");
        Assert.assertEquals((long)1L, (long)cancelledTasks.size());
        DocumentRef routeRef = route.getDocument().getRef();
        this.routing.cleanupDoneAndCanceledRouteInstances(this.session.getRepositoryName(), 0);
        this.session.save();
        Assert.assertFalse((boolean)this.session.exists(routeRef));
        for (DocumentModel cancelledTask : cancelledTasks) {
            Assert.assertFalse((boolean)this.session.exists(cancelledTask.getRef()));
        }
    }

    @Test
    public void testForkMergeAll() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "true", "testchain_title1"), this.transition("trans2", "node2", "true", "testchain_descr1"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_rights1"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertTrue((boolean)route.isDone());
        this.doc.refresh();
        Assert.assertEquals((Object)"title 1", (Object)this.doc.getTitle());
        Assert.assertEquals((Object)"descr 1", (Object)this.doc.getPropertyValue("dc:description"));
        Assert.assertEquals((Object)"rights 1", (Object)this.doc.getPropertyValue("dc:rights"));
    }

    @Test
    public void testForkMergeAll2() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2"), this.transition("trans2", "node3"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_title1"));
        this.setTransitions(node2, this.transition("trans1", "node4"));
        node2 = this.session.saveDocument(node2);
        DocumentModel node3 = this.createNode(this.routeDoc, "node3", this.session);
        node3.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_descr1"));
        this.setTransitions(node3, this.transition("trans2", "node4"));
        node3 = this.session.saveDocument(node3);
        DocumentModel node4 = this.createNode(this.routeDoc, "node4", this.session);
        node4.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node4.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_rights1"));
        node4.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node4 = this.session.saveDocument(node4);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertTrue((boolean)route.isDone());
        this.doc.refresh();
        Assert.assertEquals((Object)"title 1", (Object)this.doc.getTitle());
        Assert.assertEquals((Object)"descr 1", (Object)this.doc.getPropertyValue("dc:description"));
        Assert.assertEquals((Object)"rights 1", (Object)this.doc.getPropertyValue("dc:rights"));
    }

    @Test
    public void testForkMergeAllWithTasks() throws Exception {
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        Assert.assertNotNull((Object)user1);
        NuxeoPrincipal user2 = this.userManager.getPrincipal("myuser2");
        Assert.assertNotNull((Object)user2);
        NuxeoPrincipal user3 = this.userManager.getPrincipal("myuser3");
        Assert.assertNotNull((Object)user3);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2"), this.transition("trans2", "node3"), this.transition("trans3", "node4"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_title1"));
        this.setTransitions(node2, this.transition("trans1", "node5"));
        node2.setPropertyValue("rnode:outputChain", (Serializable)((Object)"testchain_rights1"));
        node2.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        node2.setPropertyValue("rnode:inputChain", (Serializable)((Object)"test_setGlobalvariable"));
        node2.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        String[] users = new String[]{user1.getName()};
        node2.setPropertyValue("rnode:taskAssignees", (Serializable)users);
        this.setButtons(node2, this.button("btn1", "label-btn1", "filterrr"));
        node2 = this.session.saveDocument(node2);
        DocumentModel node3 = this.createNode(this.routeDoc, "node3", this.session);
        node3.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_descr1"));
        this.setTransitions(node3, this.transition("trans2", "node5"));
        node3.setPropertyValue("rnode:outputChain", (Serializable)((Object)"testchain_rights1"));
        node3.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        node3.setPropertyValue("rnode:inputChain", (Serializable)((Object)"test_setGlobalvariable"));
        node3.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        String[] users2 = new String[]{user2.getName()};
        node3.setPropertyValue("rnode:taskAssignees", (Serializable)users2);
        this.setButtons(node1, this.button("btn2", "label-btn2", "filterrr"));
        node3 = this.session.saveDocument(node3);
        DocumentModel node4 = this.createNode(this.routeDoc, "node4", this.session);
        node4.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_descr1"));
        this.setTransitions(node4, this.transition("trans3", "node5"));
        node4.setPropertyValue("rnode:outputChain", (Serializable)((Object)"testchain_rights1"));
        node4.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        node4.setPropertyValue("rnode:inputChain", (Serializable)((Object)"test_setGlobalvariable"));
        node4.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        String[] users3 = new String[]{user3.getName()};
        node4.setPropertyValue("rnode:taskAssignees", (Serializable)users3);
        this.setButtons(node1, this.button("btn2", "label-btn2", "filterrr"));
        node4 = this.session.saveDocument(node4);
        DocumentModel node5 = this.createNode(this.routeDoc, "node5", this.session);
        node5.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node5.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_rights1"));
        node5.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node5 = this.session.saveDocument(node5);
        DocumentRoute route = this.instantiateAndRun(this.session);
        List tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        HashMap data = new HashMap();
        try (CoreSession sessionUser1 = this.openSession(user1);){
            Assert.assertNotNull((Object)sessionUser1.getDocument(route.getDocument().getRef()));
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "trans1");
        }
        tasks = this.taskService.getTaskInstances(this.doc, user2, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        data = new HashMap();
        var16_16 = null;
        try (CoreSession sessionUser2 = this.openSession(user2);){
            Assert.assertNotNull((Object)sessionUser2.getDocument(route.getDocument().getRef()));
            this.routing.endTask(sessionUser2, (Task)tasks.get(0), data, "trans2");
        }
        catch (Throwable throwable) {
            var16_16 = throwable;
            throw throwable;
        }
        UserPrincipal admin = new UserPrincipal("admin", null, false, true);
        try (CoreSession session = this.openSession((NuxeoPrincipal)admin);){
            route = (DocumentRoute)session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
            Assert.assertFalse((boolean)route.isDone());
        }
        tasks = this.taskService.getTaskInstances(this.doc, user3, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        data = new HashMap();
        var17_21 = null;
        try (CoreSession sessionUser3 = this.openSession(user3);){
            Assert.assertNotNull((Object)sessionUser3.getDocument(route.getDocument().getRef()));
            this.routing.endTask(sessionUser3, (Task)tasks.get(0), data, "trans3");
        }
        catch (Throwable throwable) {
            var17_21 = throwable;
            throw throwable;
        }
        admin = new UserPrincipal("admin", null, false, true);
        session = this.openSession((NuxeoPrincipal)admin);
        var17_21 = null;
        try {
            route = (DocumentRoute)session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
            Assert.assertTrue((boolean)route.isDone());
        }
        catch (Throwable throwable) {
            var17_21 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var17_21 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var17_21.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    @Test
    public void testForkMergeOne() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans12", "node2"), this.transition("trans13", "node3"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_title1"));
        this.setTransitions(node2, this.transition("trans25", "node5"));
        node2 = this.session.saveDocument(node2);
        DocumentModel node3 = this.createNode(this.routeDoc, "node3", this.session);
        node3.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_descr1"));
        this.setTransitions(node3, this.transition("trans34", "node4"));
        node3 = this.session.saveDocument(node3);
        DocumentModel node4 = this.createNode(this.routeDoc, "node4", this.session);
        node4.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_descr2"));
        this.setTransitions(node4, this.transition("trans45", "node5"));
        node4 = this.session.saveDocument(node4);
        DocumentModel node5 = this.createNode(this.routeDoc, "node5", this.session);
        node5.setPropertyValue("rnode:merge", (Serializable)((Object)"one"));
        node5.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_rights1"));
        node5.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node5 = this.session.saveDocument(node5);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertTrue((boolean)route.isDone());
        this.doc.refresh();
        Assert.assertEquals((Object)"title 1", (Object)this.doc.getTitle());
        Assert.assertEquals((Object)"descr 1", (Object)this.doc.getPropertyValue("dc:description"));
        Assert.assertEquals((Object)"rights 1", (Object)this.doc.getPropertyValue("dc:rights"));
    }

    @Test
    public void testForkMergeWithLoopTransition() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "true", "testchain_title1"), this.transition("trans2", "node2", "true", "testchain_descr1"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_rights1"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        this.setTransitions(node2, this.transition("transloop", "node1", "false"));
        node2 = this.session.saveDocument(node2);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertTrue((boolean)route.isDone());
        this.doc.refresh();
        Assert.assertEquals((Object)"title 1", (Object)this.doc.getTitle());
        Assert.assertEquals((Object)"descr 1", (Object)this.doc.getPropertyValue("dc:description"));
        Assert.assertEquals((Object)"rights 1", (Object)this.doc.getPropertyValue("dc:rights"));
    }

    @Test
    public void testForkMergeWithTasksAndLoopTransitions() throws Exception {
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        Assert.assertNotNull((Object)user1);
        NuxeoPrincipal user2 = this.userManager.getPrincipal("myuser2");
        Assert.assertNotNull((Object)user2);
        DocumentModel startNode = this.createNode(this.routeDoc, "startNode", this.session);
        startNode.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(startNode, this.transition("transToParallel1", "parallelNode1"), this.transition("transToParallel2", "parallelNode2"));
        startNode = this.session.saveDocument(startNode);
        DocumentModel parallelNode1 = this.createNode(this.routeDoc, "parallelNode1", this.session);
        parallelNode1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        String[] users1 = new String[]{user1.getName()};
        parallelNode1.setPropertyValue("rnode:taskAssignees", (Serializable)users1);
        this.setTransitions(parallelNode1, this.transition("transLoop", "parallelNode1", "NodeVariables[\"button\"] ==\"loop\""), this.transition("transToMerge", "mergeNode", "NodeVariables[\"button\"] ==\"toMerge\""));
        parallelNode1 = this.session.saveDocument(parallelNode1);
        DocumentModel parallelNode2 = this.createNode(this.routeDoc, "parallelNode2", this.session);
        parallelNode2.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        String[] users2 = new String[]{user2.getName()};
        parallelNode2.setPropertyValue("rnode:taskAssignees", (Serializable)users2);
        this.setTransitions(parallelNode2, this.transition("transLoop", "parallelNode2", "NodeVariables[\"button\"] ==\"loop\""), this.transition("transToMerge", "mergeNode", "NodeVariables[\"tasks\"].getNumberEndedWithStatus(\"toMerge\") ==1"));
        parallelNode2 = this.session.saveDocument(parallelNode2);
        DocumentModel mergeNode = this.createNode(this.routeDoc, "mergeNode", this.session);
        mergeNode.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        mergeNode.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        mergeNode.setPropertyValue("rnode:taskAssignees", (Serializable)users1);
        this.setTransitions(mergeNode, this.transition("transLoop", "startNode", "NodeVariables[\"button\"] ==\"loop\""), this.transition("transEnd", "endNode", "NodeVariables[\"button\"] ==\"end\""));
        mergeNode = this.session.saveDocument(mergeNode);
        DocumentModel endNode = this.createNode(this.routeDoc, "endNode", this.session);
        endNode.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        endNode = this.session.saveDocument(endNode);
        DocumentRoute route = this.instantiateAndRun(this.session);
        List tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        HashMap data = new HashMap();
        try (CoreSession sessionUser1 = this.openSession(user1);){
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "toMerge");
        }
        tasks = this.taskService.getTaskInstances(this.doc, user2, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        var14_14 = null;
        try (CoreSession sessionUser2 = this.openSession(user2);){
            this.routing.endTask(sessionUser2, (Task)tasks.get(0), data, "toMerge");
        }
        catch (Throwable throwable) {
            var14_14 = throwable;
            throw throwable;
        }
        tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        sessionUser1 = this.openSession(user1);
        var14_14 = null;
        try {
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "loop");
        }
        catch (Throwable throwable) {
            var14_14 = throwable;
            throw throwable;
        }
        finally {
            if (sessionUser1 != null) {
                if (var14_14 != null) {
                    try {
                        sessionUser1.close();
                    }
                    catch (Throwable throwable) {
                        var14_14.addSuppressed(throwable);
                    }
                } else {
                    sessionUser1.close();
                }
            }
        }
        tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        sessionUser1 = this.openSession(user1);
        var14_14 = null;
        try {
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "toMerge");
        }
        catch (Throwable throwable) {
            var14_14 = throwable;
            throw throwable;
        }
        finally {
            if (sessionUser1 != null) {
                if (var14_14 != null) {
                    try {
                        sessionUser1.close();
                    }
                    catch (Throwable throwable) {
                        var14_14.addSuppressed(throwable);
                    }
                } else {
                    sessionUser1.close();
                }
            }
        }
        tasks = this.taskService.getTaskInstances(this.doc, user2, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        sessionUser2 = this.openSession(user2);
        var14_14 = null;
        try {
            this.routing.endTask(sessionUser2, (Task)tasks.get(0), data, "toMerge");
        }
        catch (Throwable throwable) {
            var14_14 = throwable;
            throw throwable;
        }
        finally {
            if (sessionUser2 != null) {
                if (var14_14 != null) {
                    try {
                        sessionUser2.close();
                    }
                    catch (Throwable throwable) {
                        var14_14.addSuppressed(throwable);
                    }
                } else {
                    sessionUser2.close();
                }
            }
        }
        tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        sessionUser1 = this.openSession(user1);
        var14_14 = null;
        try {
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "end");
        }
        catch (Throwable throwable) {
            var14_14 = throwable;
            throw throwable;
        }
        finally {
            if (sessionUser1 != null) {
                if (var14_14 != null) {
                    try {
                        sessionUser1.close();
                    }
                    catch (Throwable throwable) {
                        var14_14.addSuppressed(throwable);
                    }
                } else {
                    sessionUser1.close();
                }
            }
        }
        this.session.save();
        route = (DocumentRoute)this.session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)route.isDone());
        GraphRoute graph = (GraphRoute)route.getDocument().getAdapter(GraphRoute.class);
        Assert.assertEquals((long)1L, (long)graph.getNode("parallelNode1").getEndedTasksInfo().size());
        Assert.assertEquals((long)1L, (long)graph.getNode("parallelNode1").getProcessedTasksInfo().size());
        Assert.assertEquals((long)1L, (long)graph.getNode("parallelNode2").getEndedTasksInfo().size());
        Assert.assertEquals((long)1L, (long)graph.getNode("parallelNode2").getProcessedTasksInfo().size());
    }

    @Test
    public void testTwoForkMergeWithLoopTransition() throws Exception {
        DocumentModel fork1 = this.createNode(this.routeDoc, "fork1", this.session);
        fork1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(fork1, this.transition("trans1", "fork2"), this.transition("trans2", "task3"));
        fork1 = this.session.saveDocument(fork1);
        DocumentModel fork2 = this.createNode(this.routeDoc, "fork2", this.session);
        this.setTransitions(fork2, this.transition("trans3", "task1"), this.transition("trans4", "task2"));
        fork2 = this.session.saveDocument(fork2);
        DocumentModel task1 = this.createNode(this.routeDoc, "task1", this.session);
        task1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        this.setTransitions(task1, this.transition("trans5", "merge1"));
        task1 = this.session.saveDocument(task1);
        DocumentModel task2 = this.createNode(this.routeDoc, "task2", this.session);
        task2.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        this.setTransitions(task2, this.transition("trans6", "merge1"));
        task2 = this.session.saveDocument(task2);
        DocumentModel task3 = this.createNode(this.routeDoc, "task3", this.session);
        task3.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        this.setTransitions(task3, this.transition("trans7", "merge2"));
        task3 = this.session.saveDocument(task3);
        DocumentModel merge1 = this.createNode(this.routeDoc, "merge1", this.session);
        merge1.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        this.setTransitions(merge1, this.transition("transloop", "merge2"));
        merge1 = this.session.saveDocument(merge1);
        DocumentModel merge2 = this.createNode(this.routeDoc, "merge2", this.session);
        merge2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        this.setTransitions(merge2, this.transition("transloop", "fork1", "false"), this.transition("trans8", "stop"));
        merge2 = this.session.saveDocument(merge2);
        DocumentModel stop = this.createNode(this.routeDoc, "stop", this.session);
        stop.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        stop = this.session.saveDocument(stop);
        DocumentRoute route = this.instantiateAndRun(this.session);
        GraphRoute graph = (GraphRoute)route;
        Assert.assertFalse((boolean)((GraphNode.Transition)graph.getNode((String)"fork1").getOutputTransitions().get((int)0)).loop);
        Assert.assertFalse((boolean)((GraphNode.Transition)graph.getNode((String)"fork1").getOutputTransitions().get((int)1)).loop);
        Assert.assertFalse((boolean)((GraphNode.Transition)graph.getNode((String)"fork2").getOutputTransitions().get((int)0)).loop);
        Assert.assertFalse((boolean)((GraphNode.Transition)graph.getNode((String)"fork2").getOutputTransitions().get((int)1)).loop);
        Assert.assertFalse((boolean)((GraphNode.Transition)graph.getNode((String)"task1").getOutputTransitions().get((int)0)).loop);
        Assert.assertFalse((boolean)((GraphNode.Transition)graph.getNode((String)"task2").getOutputTransitions().get((int)0)).loop);
        Assert.assertFalse((boolean)((GraphNode.Transition)graph.getNode((String)"task3").getOutputTransitions().get((int)0)).loop);
        Assert.assertFalse((boolean)((GraphNode.Transition)graph.getNode((String)"merge1").getOutputTransitions().get((int)0)).loop);
        Assert.assertTrue((boolean)((GraphNode.Transition)graph.getNode((String)"merge2").getOutputTransitions().get((int)0)).loop);
        Assert.assertFalse((boolean)((GraphNode.Transition)graph.getNode((String)"merge2").getOutputTransitions().get((int)1)).loop);
        Assert.assertEquals((Object)GraphNode.State.SUSPENDED, (Object)graph.getNode("task1").getState());
        Assert.assertEquals((Object)GraphNode.State.SUSPENDED, (Object)graph.getNode("task2").getState());
        Assert.assertEquals((Object)GraphNode.State.SUSPENDED, (Object)graph.getNode("task3").getState());
        this.routing.resumeInstance(route.getDocument().getId(), "task1", null, null, this.session);
        graph = (GraphRoute)this.session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertEquals((Object)GraphNode.State.READY, (Object)graph.getNode("task1").getState());
        Assert.assertEquals((Object)GraphNode.State.SUSPENDED, (Object)graph.getNode("task2").getState());
        Assert.assertEquals((Object)GraphNode.State.SUSPENDED, (Object)graph.getNode("task3").getState());
        this.routing.resumeInstance(route.getDocument().getId(), "task2", null, null, this.session);
        graph = (GraphRoute)this.session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertEquals((Object)GraphNode.State.READY, (Object)graph.getNode("task1").getState());
        Assert.assertEquals((Object)GraphNode.State.READY, (Object)graph.getNode("task2").getState());
        Assert.assertEquals((Object)GraphNode.State.SUSPENDED, (Object)graph.getNode("task3").getState());
        this.routing.resumeInstance(route.getDocument().getId(), "task3", null, null, this.session);
        graph = (GraphRoute)this.session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertEquals((Object)GraphNode.State.READY, (Object)graph.getNode("task1").getState());
        Assert.assertEquals((Object)GraphNode.State.READY, (Object)graph.getNode("task2").getState());
        Assert.assertEquals((Object)GraphNode.State.READY, (Object)graph.getNode("task3").getState());
        Assert.assertTrue((boolean)graph.isDone());
    }

    @Test
    @Ignore
    public void testForkWithLoopFromParallelToFork() throws Exception {
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        Assert.assertNotNull((Object)user1);
        NuxeoPrincipal user2 = this.userManager.getPrincipal("myuser2");
        Assert.assertNotNull((Object)user2);
        DocumentModel startNode = this.createNode(this.routeDoc, "startNode", this.session);
        startNode.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        startNode.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        String[] users1 = new String[]{user1.getName()};
        startNode.setPropertyValue("rnode:taskAssignees", (Serializable)users1);
        this.setTransitions(startNode, this.transition("transToParallel1", "parallelNode1", "NodeVariables[\"button\"] ==\"validate\""), this.transition("transToParallel2", "parallelNode2", "NodeVariables[\"button\"] ==\"validate\""));
        startNode = this.session.saveDocument(startNode);
        DocumentModel parallelNode1 = this.createNode(this.routeDoc, "parallelNode1", this.session);
        parallelNode1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        parallelNode1.setPropertyValue("rnode:taskAssignees", (Serializable)users1);
        this.setTransitions(parallelNode1, this.transition("transLoop", "startNode", "NodeVariables[\"button\"] ==\"loop\""), this.transition("transToMerge", "mergeNode", "NodeVariables[\"button\"] ==\"toMerge\""));
        parallelNode1 = this.session.saveDocument(parallelNode1);
        DocumentModel parallelNode2 = this.createNode(this.routeDoc, "parallelNode2", this.session);
        parallelNode2.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        String[] users2 = new String[]{user2.getName()};
        parallelNode2.setPropertyValue("rnode:taskAssignees", (Serializable)users2);
        this.setTransitions(parallelNode2, this.transition("transToMerge", "mergeNode", "NodeVariables[\"button\"] ==\"toMerge\""));
        parallelNode2 = this.session.saveDocument(parallelNode2);
        DocumentModel mergeNode = this.createNode(this.routeDoc, "mergeNode", this.session);
        mergeNode.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        startNode.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        mergeNode = this.session.saveDocument(mergeNode);
        DocumentRoute route = this.instantiateAndRun(this.session);
        List tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        HashMap data = new HashMap();
        try (CoreSession sessionUser1 = this.openSession(user1);){
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "validate");
        }
        tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        data = new HashMap();
        sessionUser1 = this.openSession(user1);
        var13_13 = null;
        try {
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "loop");
        }
        catch (Throwable throwable) {
            var13_13 = throwable;
            throw throwable;
        }
        finally {
            if (sessionUser1 != null) {
                if (var13_13 != null) {
                    try {
                        sessionUser1.close();
                    }
                    catch (Throwable throwable) {
                        var13_13.addSuppressed(throwable);
                    }
                } else {
                    sessionUser1.close();
                }
            }
        }
        tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        data = new HashMap();
        sessionUser1 = this.openSession(user1);
        var13_13 = null;
        try {
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "validate");
        }
        catch (Throwable throwable) {
            var13_13 = throwable;
            throw throwable;
        }
        finally {
            if (sessionUser1 != null) {
                if (var13_13 != null) {
                    try {
                        sessionUser1.close();
                    }
                    catch (Throwable throwable) {
                        var13_13.addSuppressed(throwable);
                    }
                } else {
                    sessionUser1.close();
                }
            }
        }
        tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        data = new HashMap();
        sessionUser1 = this.openSession(user1);
        var13_13 = null;
        try {
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "toMerge");
        }
        catch (Throwable throwable) {
            var13_13 = throwable;
            throw throwable;
        }
        finally {
            if (sessionUser1 != null) {
                if (var13_13 != null) {
                    try {
                        sessionUser1.close();
                    }
                    catch (Throwable throwable) {
                        var13_13.addSuppressed(throwable);
                    }
                } else {
                    sessionUser1.close();
                }
            }
        }
        tasks = this.taskService.getTaskInstances(this.doc, user2, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        var13_13 = null;
        try (CoreSession sessionUser2 = this.openSession(user2);){
            this.routing.endTask(sessionUser2, (Task)tasks.get(0), data, "toMerge");
        }
        catch (Throwable throwable) {
            var13_13 = throwable;
            throw throwable;
        }
        this.session.save();
        route = (DocumentRoute)this.session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)route.isDone());
    }

    @Test
    public void testRouteWithTasks() throws Exception {
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        Assert.assertNotNull((Object)user1);
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc.addFacet("FacetRoute1");
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "NodeVariables[\"button\"] == \"trans1\" && WorkflowFn.timeSinceWorkflowWasStarted()>=0", "testchain_title1"));
        node1.setPropertyValue("rnode:outputChain", (Serializable)((Object)"testchain_rights1"));
        node1.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        node1.setPropertyValue("rnode:inputChain", (Serializable)((Object)"test_setGlobalvariable"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:taskDocType", (Serializable)((Object)"MyTaskDoc"));
        String[] users = new String[]{user1.getName()};
        node1.setPropertyValue("rnode:taskAssignees", (Serializable)users);
        this.setButtons(node1, this.button("btn1", "label-btn1", "filterrr"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentModelList doneTasks = this.session.query("Select * from TaskDoc where ecm:currentLifeCycleState = 'ended'");
        Assert.assertEquals((long)0L, (long)doneTasks.size());
        DocumentRoute route = this.instantiateAndRun(this.session);
        List tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        HashMap data = new HashMap();
        try (CoreSession sessionUser1 = this.openSession(user1);){
            Assert.assertNotNull((Object)sessionUser1.getDocument(route.getDocument().getRef()));
            Task task1 = (Task)tasks.get(0);
            Assert.assertEquals((Object)"MyTaskDoc", (Object)task1.getDocument().getType());
            List docs = this.routing.getWorkflowInputDocuments(sessionUser1, task1);
            Assert.assertEquals((Object)this.doc.getId(), (Object)((DocumentModel)docs.get(0)).getId());
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "trans1");
        }
        UserPrincipal admin = new UserPrincipal("admin", null, false, true);
        try (CoreSession session = this.openSession((NuxeoPrincipal)admin);){
            DocumentRef routeRef = route.getDocument().getRef();
            route = (DocumentRoute)session.getDocument(routeRef).getAdapter(DocumentRoute.class);
            Assert.assertTrue((boolean)route.isDone());
            Assert.assertEquals((Object)"test", (Object)route.getDocument().getPropertyValue("fctroute1:globalVariable"));
            doneTasks = session.query("Select * from TaskDoc where ecm:currentLifeCycleState = 'ended'");
            Assert.assertEquals((long)1L, (long)doneTasks.size());
            this.routing.cleanupDoneAndCanceledRouteInstances(session.getRepositoryName(), 0);
            session.save();
            Assert.assertFalse((boolean)session.exists(routeRef));
            for (DocumentModel doneTask : doneTasks) {
                Assert.assertFalse((boolean)session.exists(doneTask.getRef()));
            }
        }
    }

    @Test
    public void testEvaluateTaskAssigneesFromVariable() throws Exception {
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        NuxeoPrincipal user2 = this.userManager.getPrincipal("myuser2");
        List<String> assignees = Arrays.asList(user1.getName(), user2.getName());
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc.addFacet("FacetRoute1");
        this.routeDoc.setPropertyValue("fctroute1:myassignees", (Serializable)((Object)assignees));
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_rights1"));
        node1.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        this.setTransitions(node1, this.transition("trans1", "node2", "true", "testchain_title1"));
        node1.setPropertyValue("rnode:taskAssigneesExpr", (Serializable)((Object)"WorkflowVariables[\"myassignees\"]"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute route = this.instantiateAndRun(this.session);
        List tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task ts = (Task)tasks.get(0);
        Assert.assertEquals((long)2L, (long)ts.getActors().size());
        Assert.assertTrue((boolean)this.session.hasPermission((Principal)user1, this.doc.getRef(), "Write"));
        Assert.assertTrue((boolean)this.session.hasPermission((Principal)user2, this.doc.getRef(), "Write"));
        HashMap data = new HashMap();
        try (CoreSession sessionUser2 = this.openSession(user2);){
            this.routing.endTask(sessionUser2, (Task)tasks.get(0), data, "trans1");
        }
        UserPrincipal admin = new UserPrincipal("admin", null, false, true);
        try (CoreSession session = this.openSession((NuxeoPrincipal)admin);){
            route = (DocumentRoute)session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
            Assert.assertTrue((boolean)route.isDone());
            Assert.assertFalse((boolean)session.hasPermission((Principal)user1, this.doc.getRef(), "Write"));
            Assert.assertFalse((boolean)session.hasPermission((Principal)user2, this.doc.getRef(), "Write"));
        }
    }

    @Test
    public void testComputedTaskAssignees() throws Exception {
        List tasks;
        DocumentRoute route;
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        NuxeoPrincipal user2 = this.userManager.getPrincipal("myuser2");
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_rights1"));
        node1.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        this.setTransitions(node1, this.transition("trans1", "node2", "true", "testchain_title1"));
        node1.setPropertyValue("rnode:taskAssigneesExpr", (Serializable)((Object)"\"myuser1\""));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        this.session.save();
        try (CoreSession session2 = this.openSession(user2);){
            route = this.instantiateAndRun(session2);
            tasks = this.taskService.getTaskInstances(this.doc, user1, session2);
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            Task ts = (Task)tasks.get(0);
            Assert.assertEquals((long)1L, (long)ts.getActors().size());
            session2.save();
        }
        var8_6 = null;
        try (CoreSession session1 = this.openSession(user1);){
            this.routing.endTask(session1, (Task)tasks.get(0), new HashMap(), "trans1");
        }
        catch (Throwable throwable) {
            var8_6 = throwable;
            throw throwable;
        }
        this.session.save();
        route = (DocumentRoute)this.session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)route.isDone());
        Assert.assertFalse((boolean)this.session.hasPermission((Principal)user1, this.doc.getRef(), "Write"));
    }

    @Test
    public void testDynamicallyComputeDueDate() throws PropertyException {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_rights1"));
        node1.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        this.setTransitions(node1, this.transition("trans1", "node2", "true", "testchain_title1"));
        node1.setPropertyValue("rnode:taskAssigneesExpr", (Serializable)((Object)"\"Administrator\""));
        node1.setPropertyValue("rnode:taskDueDateExpr", (Serializable)((Object)"CurrentDate.days(1)"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        this.session.save();
        this.instantiateAndRun(this.session);
        this.session.save();
        List tasks = this.taskService.getTaskInstances(this.doc, (NuxeoPrincipal)this.session.getPrincipal(), this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task ts = (Task)tasks.get(0);
        Calendar currentDate = Calendar.getInstance();
        Calendar taskDueDate = Calendar.getInstance();
        taskDueDate.setTime(ts.getDueDate());
        int tomorrow = currentDate.get(6) + 1;
        int due = taskDueDate.get(6);
        if (due != 1) {
            Assert.assertEquals((long)tomorrow, (long)due);
        }
    }

    @Test
    public void testWorkflowInitiatorAndTaskActor() throws Exception {
        DocumentRef routeDocRef;
        Object route;
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        NuxeoPrincipal user2 = this.userManager.getPrincipal("myuser2");
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc.addFacet("FacetRoute1");
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "true", "test_setGlobalVariableToWorkflowInitiator"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:taskAssignees", (Serializable)new String[]{user2.getName()});
        this.setButtons(node1, this.button("btn1", "label-btn1", "filterrr"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        this.session.save();
        try (CoreSession sessionUser1 = this.openSession(user1);){
            route = this.instantiateAndRun(sessionUser1);
            routeDocRef = route.getDocument().getRef();
        }
        List tasks = this.taskService.getTaskInstances(this.doc, user2, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        CoreSession sessionUser2 = this.openSession(user2);
        route = null;
        try {
            Assert.assertNotNull((Object)sessionUser2.getDocument(routeDocRef));
            Task task = (Task)tasks.get(0);
            List docs = this.routing.getWorkflowInputDocuments(sessionUser2, task);
            Assert.assertEquals((Object)this.doc.getId(), (Object)((DocumentModel)docs.get(0)).getId());
            HashMap data = new HashMap();
            this.routing.endTask(sessionUser2, (Task)tasks.get(0), data, "trans1");
        }
        catch (Throwable throwable) {
            route = throwable;
            throw throwable;
        }
        finally {
            if (sessionUser2 != null) {
                if (route != null) {
                    try {
                        sessionUser2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)route).addSuppressed(throwable);
                    }
                } else {
                    sessionUser2.close();
                }
            }
        }
        UserPrincipal admin = new UserPrincipal("admin", null, false, true);
        try (CoreSession sessionAdmin = this.openSession((NuxeoPrincipal)admin);){
            DocumentRoute route2 = (DocumentRoute)sessionAdmin.getDocument(routeDocRef).getAdapter(DocumentRoute.class);
            Assert.assertTrue((boolean)route2.isDone());
            Serializable v = route2.getDocument().getPropertyValue("fctroute1:globalVariable");
            Assert.assertEquals((Object)"myuser1", (Object)v);
        }
    }

    @Test
    public void testRestartWorkflowOperation() throws Exception {
        Assert.assertEquals((Object)"file", (Object)this.doc.getTitle());
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans12", "node2", "true", "testchain_title1"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        this.setTransitions(node2, this.transition("trans23", "node3"));
        node2 = this.session.saveDocument(node2);
        DocumentModel node3 = this.createNode(this.routeDoc, "node3", this.session);
        node3.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node3 = this.session.saveDocument(node3);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertFalse((boolean)route.isDone());
        List tasks = this.taskService.getTaskInstances(this.doc, (NuxeoPrincipal)null, this.session);
        Assert.assertEquals((long)1L, (long)tasks.size());
        OperationContext ctx = new OperationContext(this.session);
        OperationChain chain = new OperationChain("testChain");
        chain.add("WorkflowModel.BulkRestartInstances").set("workflowId", (Object)this.routeDoc.getTitle());
        this.automationService.run(ctx, chain);
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        DocumentModelList workflows = this.session.query(String.format("Select * from DocumentRoute where docri:participatingDocuments/* IN ('%s') and ecm:currentLifeCycleState = 'running'", this.doc.getId()));
        Assert.assertEquals((long)1L, (long)workflows.size());
        String restartedWorkflowId = ((DocumentModel)workflows.get(0)).getId();
        Assert.assertFalse((boolean)restartedWorkflowId.equals(route.getDocument().getId()));
        chain.add("WorkflowModel.BulkRestartInstances").set("workflowId", (Object)this.routeDoc.getTitle()).set("nodeId", (Object)"node2");
        this.automationService.run(ctx, chain);
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        workflows = this.session.query(String.format("Select * from DocumentRoute where docri:participatingDocuments/* IN ('%s') and ecm:currentLifeCycleState = 'running'", this.doc.getId()));
        Assert.assertEquals((long)1L, (long)workflows.size());
        Assert.assertFalse((boolean)restartedWorkflowId.equals(((DocumentModel)workflows.get(0)).getId()));
    }

    @Test
    public void testMergeOneWhenHavinOpenedTasks() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans12", "node2"), this.transition("trans13", "node3"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_title1"));
        node2.setPropertyValue("rnode:hasTask", (Serializable)((Object)"true"));
        this.setTransitions(node2, this.transition("trans25", "node5"));
        node2 = this.session.saveDocument(node2);
        DocumentModel node3 = this.createNode(this.routeDoc, "node3", this.session);
        node3.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_descr1"));
        this.setTransitions(node3, this.transition("trans34", "node4"));
        node3 = this.session.saveDocument(node3);
        DocumentModel node4 = this.createNode(this.routeDoc, "node4", this.session);
        node4.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_descr2"));
        this.setTransitions(node4, this.transition("trans45", "node5"));
        node4.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        node4.setPropertyValue("rnode:taskAssignees", (Serializable)new String[]{user1.getName()});
        node4 = this.session.saveDocument(node4);
        DocumentModel node5 = this.createNode(this.routeDoc, "node5", this.session);
        node5.setPropertyValue("rnode:merge", (Serializable)((Object)"one"));
        node5.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_rights1"));
        node5.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node5 = this.session.saveDocument(node5);
        DocumentRoute route = this.instantiateAndRun(this.session);
        this.session.save();
        List tasks = this.taskService.getAllTaskInstances(route.getDocument().getId(), this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        tasks = this.taskService.getAllTaskInstances(route.getDocument().getId(), user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        try (CoreSession session1 = this.openSession(user1);){
            this.routing.endTask(session1, (Task)tasks.get(0), new HashMap(), null);
        }
        this.session.save();
        route = (DocumentRoute)this.session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
        tasks = this.taskService.getAllTaskInstances(route.getDocument().getId(), this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        DocumentModelList cancelledTasks = this.session.query("Select * from TaskDoc where ecm:currentLifeCycleState = 'cancelled'");
        Assert.assertEquals((long)1L, (long)cancelledTasks.size());
    }

    @Test
    public void testForceResumeOnMerge() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans12", "node2"), this.transition("trans13", "node3"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_title1"));
        node2.setPropertyValue("rnode:hasTask", (Serializable)((Object)"true"));
        this.setTransitions(node2, this.transition("trans25", "node5"));
        node2 = this.session.saveDocument(node2);
        DocumentModel node3 = this.createNode(this.routeDoc, "node3", this.session);
        node3.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_descr1"));
        this.setTransitions(node3, this.transition("trans34", "node4"));
        node3 = this.session.saveDocument(node3);
        DocumentModel node4 = this.createNode(this.routeDoc, "node4", this.session);
        node4.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_descr2"));
        this.setTransitions(node4, this.transition("trans45", "node5"));
        node4 = this.session.saveDocument(node4);
        DocumentModel node5 = this.createNode(this.routeDoc, "node5", this.session);
        node5.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node5.setPropertyValue("rnode:inputChain", (Serializable)((Object)"testchain_rights1"));
        node5.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node5 = this.session.saveDocument(node5);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Map<String, Boolean> data = Collections.singletonMap("_FORCE_RESUME_", Boolean.TRUE);
        this.routing.resumeInstance(route.getDocument().getId(), "node2", data, null, this.session);
        this.session.save();
        Assert.assertEquals((Object)"done", (Object)this.session.getDocument(route.getDocument().getRef()).getCurrentLifeCycleState());
        this.routeDoc = this.session.getDocument(this.routeDoc.getRef());
        route = this.instantiateAndRun(this.session);
        GraphRoute graph = (GraphRoute)route;
        GraphNode nodeMerge = graph.getNode("node5");
        Assert.assertTrue((boolean)GraphNode.State.WAITING.equals((Object)nodeMerge.getState()));
        data = Collections.singletonMap("_FORCE_RESUME_", Boolean.TRUE);
        this.routing.resumeInstance(route.getDocument().getId(), "node5", data, null, this.session);
        this.session.save();
        Assert.assertEquals((Object)"running", (Object)this.session.getDocument(route.getDocument().getRef()).getCurrentLifeCycleState());
        nodeMerge.getDocument().setPropertyValue("rnode:merge", (Serializable)((Object)"one"));
        this.session.saveDocument(nodeMerge.getDocument());
        this.routing.resumeInstance(route.getDocument().getId(), "node5", data, null, this.session);
        this.session.save();
        Assert.assertEquals((Object)"done", (Object)this.session.getDocument(route.getDocument().getRef()).getCurrentLifeCycleState());
    }

    @Test
    public void testRouteWithExclusiveNode() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:executeOnlyFirstTransition", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans12", "node2", "true", "testchain_title1"), this.transition("trans13", "node3", "true", "testchain_title2"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        this.setTransitions(node2, this.transition("trans24", "node4", "true"));
        node2 = this.session.saveDocument(node2);
        DocumentModel node3 = this.createNode(this.routeDoc, "node3", this.session);
        this.setTransitions(node3, this.transition("trans34", "node4", "true"));
        node3 = this.session.saveDocument(node3);
        DocumentModel node4 = this.createNode(this.routeDoc, "node4", this.session);
        node4.setPropertyValue("rnode:merge", (Serializable)((Object)"one"));
        node4.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node4 = this.session.saveDocument(node4);
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertTrue((boolean)route.isDone());
        this.session.save();
        DocumentModel docR = this.session.getDocument(this.doc.getRef());
        Assert.assertEquals((Object)"title 1", (Object)docR.getTitle());
    }

    protected void createWorkflowWithSubRoute(String subRouteModelId) throws PropertyException {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans12", "node2"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:subRouteModelExpr", (Serializable)((Object)subRouteModelId));
        this.setTransitions(node2, this.transition("trans23", "node3"));
        this.setSubRouteVariables(node2, this.keyvalue("stringfield", "foo"), this.keyvalue("globalVariable", "expr:bar@{4+3}baz"));
        node2 = this.session.saveDocument(node2);
        DocumentModel node3 = this.createNode(this.routeDoc, "node3", this.session);
        node3.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node3 = this.session.saveDocument(node3);
    }

    @Test
    public void testSubRouteNotSuspending() throws Exception {
        DocumentModel subRouteDoc = this.createRoute("subroute", this.session);
        subRouteDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        subRouteDoc = this.session.saveDocument(subRouteDoc);
        DocumentModel subNode1 = this.createNode(subRouteDoc, "subnode1", this.session);
        subNode1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(subNode1, this.transition("trans12", "subnode2", "true", "testchain_title_subroute"));
        subNode1 = this.session.saveDocument(subNode1);
        DocumentModel subNode2 = this.createNode(subRouteDoc, "subnode2", this.session);
        subNode2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        subNode2 = this.session.saveDocument(subNode2);
        this.validate(subRouteDoc, this.session);
        this.createWorkflowWithSubRoute(subRouteDoc.getName());
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertTrue((boolean)route.isDone());
        this.doc.refresh();
        Assert.assertEquals((Object)(route.getDocument().getId() + " node2 foo bar7baz"), (Object)this.doc.getTitle());
    }

    public void createRouteAndSuspendingSubRoute() throws Exception {
        DocumentModel subRouteDoc = this.createRoute("subroute", this.session);
        subRouteDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        subRouteDoc = this.session.saveDocument(subRouteDoc);
        DocumentModel subNode1 = this.createNode(subRouteDoc, "subnode1", this.session);
        subNode1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(subNode1, this.transition("trans12", "subnode2", "true", "testchain_title_subroute"));
        subNode1 = this.session.saveDocument(subNode1);
        DocumentModel subNode2 = this.createNode(subRouteDoc, "subnode2", this.session);
        subNode2.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        this.setTransitions(subNode2, this.transition("trans23", "subnode3"));
        subNode2 = this.session.saveDocument(subNode2);
        DocumentModel subNode3 = this.createNode(subRouteDoc, "subnode3", this.session);
        subNode3.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        subNode3 = this.session.saveDocument(subNode3);
        this.validate(subRouteDoc, this.session);
        this.createWorkflowWithSubRoute(subRouteDoc.getName());
    }

    @Test
    public void testSubRouteSuspending() throws Exception {
        this.createRouteAndSuspendingSubRoute();
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertFalse((boolean)route.isDone());
        DocumentModel n2 = this.session.getChild(route.getDocument().getRef(), "node2");
        Assert.assertNotNull((Object)n2);
        Assert.assertEquals((Object)GraphNode.State.SUSPENDED.getLifeCycleState(), (Object)n2.getCurrentLifeCycleState());
        this.doc.refresh();
        Assert.assertEquals((Object)(route.getDocument().getId() + " node2 foo bar7baz"), (Object)this.doc.getTitle());
        String subid = (String)((Object)n2.getPropertyValue("rnode:subRouteInstanceId"));
        Assert.assertNotNull((Object)subid);
        DocumentModel subrdoc = this.session.getDocument((DocumentRef)new IdRef(subid));
        DocumentRoute subr = (DocumentRoute)subrdoc.getAdapter(DocumentRoute.class);
        Assert.assertFalse((boolean)subr.isDone());
        this.routing.resumeInstance(subid, "subnode2", null, null, this.session);
        subrdoc.refresh();
        Assert.assertTrue((boolean)subr.isDone());
        route.getDocument().refresh();
        Assert.assertTrue((boolean)route.isDone());
    }

    @Test
    public void testSubRouteCancel() throws Exception {
        this.createRouteAndSuspendingSubRoute();
        DocumentRoute route = this.instantiateAndRun(this.session);
        Assert.assertFalse((boolean)route.isDone());
        DocumentModel n2 = this.session.getChild(route.getDocument().getRef(), "node2");
        Assert.assertNotNull((Object)n2);
        Assert.assertEquals((Object)GraphNode.State.SUSPENDED.getLifeCycleState(), (Object)n2.getCurrentLifeCycleState());
        route.cancel(this.session);
        route.getDocument().refresh();
        Assert.assertTrue((boolean)route.isCanceled());
        String subid = (String)((Object)n2.getPropertyValue("rnode:subRouteInstanceId"));
        Assert.assertNotNull((Object)subid);
        DocumentModel subrdoc = this.session.getDocument((DocumentRef)new IdRef(subid));
        DocumentRoute subr = (DocumentRoute)subrdoc.getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)subr.isCanceled());
    }

    @Test
    public void testCancelTasksWhenWorkflowDone() throws Exception {
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node12", "NodeVariables[\"button\"] == \"trans1\"", "testchain_title1"), this.transition("trans1", "node22", "NodeVariables[\"button\"] == \"trans1\"", "testchain_title1"), this.transition("trans2", "node2", "true", ""));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        String[] users = new String[]{"Administrator"};
        node1.setPropertyValue("rnode:taskAssignees", (Serializable)users);
        node1 = this.session.saveDocument(node1);
        DocumentModel node12 = this.createNode(this.routeDoc, "node12", this.session);
        this.setTransitions(node1, this.transition("trans12", "node2", "NodeVariables[\"button\"] == \"trans12\"", "testchain_title1"));
        node12.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node12 = this.session.saveDocument(node12);
        DocumentModel node22 = this.createNode(this.routeDoc, "node22", this.session);
        this.setTransitions(node1, this.transition("trans22", "node2", "NodeVariables[\"button\"] == \"trans22\"", "testchain_title1"));
        node22.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node22 = this.session.saveDocument(node22);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute route = this.instantiateAndRun(this.session);
        this.session.save();
        List tasks = this.taskService.getAllTaskInstances(route.getDocument().getId(), this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.routing.endTask(this.session, (Task)tasks.get(0), new HashMap(), "trans1");
        route = (DocumentRoute)this.session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)route.isDone());
        this.session.save();
        tasks = this.taskService.getAllTaskInstances(route.getDocument().getId(), this.session);
        Assert.assertEquals((long)0L, (long)tasks.size());
        DocumentModelList cancelledTasks = this.session.query("Select * from TaskDoc where ecm:currentLifeCycleState = 'cancelled'");
        Assert.assertEquals((long)2L, (long)cancelledTasks.size());
    }

    @Test
    public void testRouteWithMultipleTasks() throws Exception {
        Task task2;
        Object docs;
        Task task1;
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        Assert.assertNotNull((Object)user1);
        NuxeoPrincipal user2 = this.userManager.getPrincipal("myuser2");
        Assert.assertNotNull((Object)user2);
        NuxeoPrincipal user3 = this.userManager.getPrincipal("myuser3");
        Assert.assertNotNull((Object)user3);
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc.addFacet("FacetRoute1");
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "NodeVariables[\"tasks\"].getNumberEndedWithStatus(\"trans1\") ==1", "testchain_title1"));
        node1.setPropertyValue("rnode:outputChain", (Serializable)((Object)"testchain_rights1"));
        node1.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        node1.setPropertyValue("rnode:inputChain", (Serializable)((Object)"test_setGlobalvariable"));
        node1.setPropertyValue("rnode:hasMultipleTasks", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:taskDocType", (Serializable)((Object)"MyTaskDoc"));
        String[] users = new String[]{user1.getName(), user2.getName(), user3.getName()};
        node1.setPropertyValue("rnode:taskAssignees", (Serializable)users);
        this.setButtons(node1, this.button("btn1", "label-btn1", "filterrr"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute route = this.instantiateAndRun(this.session);
        GraphRoute graph = (GraphRoute)route.getDocument().getAdapter(GraphRoute.class);
        List tasks = this.taskService.getAllTaskInstances(route.getDocument().getId(), "node1", this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((long)3L, (long)graph.getNode("node1").getTasksInfo().size());
        HashMap<String, String> data = new HashMap<String, String>();
        try (CoreSession sessionUser1 = this.openSession(user1);){
            Assert.assertNotNull((Object)sessionUser1.getDocument(route.getDocument().getRef()));
            tasks = this.taskService.getTaskInstances(this.doc, user1, sessionUser1);
            Assert.assertEquals((long)1L, (long)tasks.size());
            task1 = (Task)tasks.get(0);
            Assert.assertEquals((Object)"MyTaskDoc", (Object)task1.getDocument().getType());
            docs = this.routing.getWorkflowInputDocuments(sessionUser1, task1);
            Assert.assertEquals((Object)this.doc.getId(), (Object)((DocumentModel)docs.get(0)).getId());
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "faketrans1");
        }
        UserPrincipal admin = new UserPrincipal("admin", null, false, true);
        CoreSession session = this.openSession((NuxeoPrincipal)admin);
        docs = null;
        try {
            route = (DocumentRoute)session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
            graph = (GraphRoute)route.getDocument().getAdapter(GraphRoute.class);
            Assert.assertFalse((boolean)route.isDone());
            Assert.assertEquals((long)1L, (long)graph.getNode("node1").getEndedTasksInfo().size());
            Assert.assertEquals((long)1L, (long)graph.getNode("node1").getProcessedTasksInfo().size());
        }
        catch (Throwable throwable) {
            docs = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (docs != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)docs).addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
        data = new HashMap();
        data.put("comment", "testcomment");
        try (CoreSession sessionUser2 = this.openSession(user2);){
            Assert.assertNotNull((Object)sessionUser2.getDocument(route.getDocument().getRef()));
            tasks = this.taskService.getTaskInstances(this.doc, user2, sessionUser2);
            Assert.assertEquals((long)1L, (long)tasks.size());
            task2 = (Task)tasks.get(0);
            Assert.assertEquals((Object)"MyTaskDoc", (Object)task2.getDocument().getType());
            List docs2 = this.routing.getWorkflowInputDocuments(sessionUser2, task2);
            Assert.assertEquals((Object)this.doc.getId(), (Object)((DocumentModel)docs2.get(0)).getId());
            this.routing.endTask(sessionUser2, (Task)tasks.get(0), data, "trans1");
        }
        var15_20 = null;
        try (CoreSession session2 = this.openSession((NuxeoPrincipal)admin);){
            route = (DocumentRoute)session2.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
            graph = (GraphRoute)route.getDocument().getAdapter(GraphRoute.class);
            Assert.assertFalse((boolean)route.isDone());
            Assert.assertEquals((long)2L, (long)graph.getNode("node1").getEndedTasksInfo().size());
        }
        catch (Throwable docs2) {
            var15_20 = docs2;
            throw docs2;
        }
        tasks = this.taskService.getTaskInstances(this.doc, user3, this.session);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task task3 = (Task)tasks.get(0);
        this.routing.cancelTask(this.session, task3.getId());
        this.routing.resumeInstance(route.getDocument().getId(), "node1", null, null, this.session);
        route = (DocumentRoute)this.session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
        graph = (GraphRoute)route.getDocument().getAdapter(GraphRoute.class);
        Assert.assertTrue((boolean)route.isDone());
        Assert.assertEquals((long)3L, (long)graph.getNode("node1").getEndedTasksInfo().size());
        Assert.assertEquals((long)2L, (long)graph.getNode("node1").getProcessedTasksInfo().size());
        GraphNode graphNode1 = graph.getNode("node1");
        List tasksInfo = graphNode1.getTasksInfo();
        Assert.assertEquals((long)tasksInfo.size(), (long)3L);
        int task1Index = 0;
        int task2Index = 1;
        int task3Index = 2;
        for (GraphNode.TaskInfo taskInfo : tasksInfo) {
            if (taskInfo.getTaskDocId().equals(task1.getId())) {
                task1Index = tasksInfo.indexOf(taskInfo);
            }
            if (taskInfo.getTaskDocId().equals(task2.getId())) {
                task2Index = tasksInfo.indexOf(taskInfo);
            }
            if (!taskInfo.getTaskDocId().equals(task3.getId())) continue;
            task3Index = tasksInfo.indexOf(taskInfo);
        }
        Assert.assertEquals((Object)"myuser1", (Object)((GraphNode.TaskInfo)tasksInfo.get(task1Index)).getActor());
        Assert.assertEquals((Object)"myuser2", (Object)((GraphNode.TaskInfo)tasksInfo.get(task2Index)).getActor());
        Assert.assertEquals((Object)"Administrator", (Object)((GraphNode.TaskInfo)tasksInfo.get(task3Index)).getActor());
        Assert.assertEquals((Object)"faketrans1", (Object)((GraphNode.TaskInfo)tasksInfo.get(task1Index)).getStatus());
        Assert.assertEquals((Object)"trans1", (Object)((GraphNode.TaskInfo)tasksInfo.get(task2Index)).getStatus());
        Assert.assertEquals(null, (Object)((GraphNode.TaskInfo)tasksInfo.get(task3Index)).getStatus());
        Assert.assertEquals((Object)"testcomment", (Object)((GraphNode.TaskInfo)tasksInfo.get(task2Index)).getComment());
    }

    @Test
    public void testTasksReassignment() throws Exception {
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        Assert.assertNotNull((Object)user1);
        NuxeoPrincipal user2 = this.userManager.getPrincipal("myuser2");
        Assert.assertNotNull((Object)user2);
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc.addFacet("FacetRoute1");
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "NodeVariables[\"button\"] == \"trans1\"", "testchain_title1"));
        node1.setPropertyValue("rnode:outputChain", (Serializable)((Object)"testchain_rights1"));
        node1.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        node1.setPropertyValue("rnode:inputChain", (Serializable)((Object)"test_setGlobalvariable"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:allowTaskReassignment", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:taskDocType", (Serializable)((Object)"MyTaskDoc"));
        String[] users = new String[]{user1.getName()};
        node1.setPropertyValue("rnode:taskAssignees", (Serializable)users);
        this.setButtons(node1, this.button("btn1", "label-btn1", "filterrr"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute route = this.instantiateAndRun(this.session);
        this.session.save();
        List tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task task1 = (Task)tasks.get(0);
        HashMap data = new HashMap();
        try (CoreSession sessionUser1 = this.openSession(user1);){
            Assert.assertEquals((Object)"MyTaskDoc", (Object)task1.getDocument().getType());
            List docs = this.routing.getWorkflowInputDocuments(sessionUser1, task1);
            Assert.assertEquals((Object)this.doc.getId(), (Object)((DocumentModel)docs.get(0)).getId());
            Assert.assertTrue((boolean)sessionUser1.hasPermission(((DocumentModel)docs.get(0)).getRef(), "Write"));
            ArrayList<String> newActors = new ArrayList<String>();
            newActors.add("myuser2");
            this.routing.reassignTask(sessionUser1, task1.getId(), newActors, "Reassigned");
            sessionUser1.save();
            docs = this.routing.getWorkflowInputDocuments(sessionUser1, task1);
            Assert.assertFalse((boolean)sessionUser1.hasPermission(((DocumentModel)docs.get(0)).getRef(), "Write"));
            Assert.assertFalse((boolean)sessionUser1.hasPermission(task1.getDocument().getRef(), "Read"));
        }
        var11_11 = null;
        try (CoreSession sessionUser2 = this.openSession(user2);){
            tasks = this.taskService.getTaskInstances(this.doc, user2, sessionUser2);
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            Task task2 = (Task)tasks.get(0);
            Assert.assertEquals((long)1L, (long)task2.getActors().size());
            Assert.assertEquals((Object)"myuser2", task2.getActors().get(0));
            List docs = this.routing.getWorkflowInputDocuments(sessionUser2, task1);
            Assert.assertTrue((boolean)sessionUser2.hasPermission(((DocumentModel)docs.get(0)).getRef(), "Write"));
            this.routing.endTask(sessionUser2, (Task)tasks.get(0), data, "trans1");
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        UserPrincipal admin = new UserPrincipal("admin", null, false, true);
        try (CoreSession adminSession = this.openSession((NuxeoPrincipal)admin);){
            route = (DocumentRoute)adminSession.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
            Assert.assertTrue((boolean)route.isDone());
            Assert.assertEquals((Object)"test", (Object)route.getDocument().getPropertyValue("fctroute1:globalVariable"));
        }
    }

    @Test
    public void testTasksDelegation() throws Exception {
        List docs;
        Object docs2;
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        Assert.assertNotNull((Object)user1);
        NuxeoPrincipal user2 = this.userManager.getPrincipal("myuser2");
        Assert.assertNotNull((Object)user2);
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc.addFacet("FacetRoute1");
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "NodeVariables[\"button\"] == \"trans1\"", "testchain_title1"));
        node1.setPropertyValue("rnode:outputChain", (Serializable)((Object)"testchain_rights1"));
        node1.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        node1.setPropertyValue("rnode:inputChain", (Serializable)((Object)"test_setGlobalvariable"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:taskDocType", (Serializable)((Object)"MyTaskDoc"));
        String[] users = new String[]{user1.getName()};
        node1.setPropertyValue("rnode:taskAssignees", (Serializable)users);
        this.setButtons(node1, this.button("btn1", "label-btn1", "filterrr"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute route = this.instantiateAndRun(this.session);
        this.session.save();
        List tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task task1 = (Task)tasks.get(0);
        HashMap data = new HashMap();
        try (CoreSession sessionUser1 = this.openSession(user1);){
            Assert.assertEquals((Object)"MyTaskDoc", (Object)task1.getDocument().getType());
            docs2 = this.routing.getWorkflowInputDocuments(sessionUser1, task1);
            Assert.assertEquals((Object)this.doc.getId(), (Object)((DocumentModel)docs2.get(0)).getId());
            Assert.assertTrue((boolean)sessionUser1.hasPermission(((DocumentModel)docs2.get(0)).getRef(), "Write"));
            ArrayList<String> newActors = new ArrayList<String>();
            newActors.add("myuser2");
            this.routing.delegateTask(sessionUser1, task1.getId(), newActors, "Delegated");
            sessionUser1.save();
            docs2 = this.routing.getWorkflowInputDocuments(sessionUser1, task1);
            Assert.assertTrue((boolean)sessionUser1.hasPermission(((DocumentModel)docs2.get(0)).getRef(), "Write"));
            Assert.assertTrue((boolean)sessionUser1.hasPermission(task1.getDocument().getRef(), "Read"));
        }
        CoreSession sessionUser2 = this.openSession(user2);
        docs2 = null;
        try {
            tasks = this.taskService.getTaskInstances(this.doc, user2, sessionUser2);
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)0L, (long)tasks.size());
            tasks = this.taskService.getTaskInstances(this.doc, Arrays.asList("myuser2"), true, sessionUser2);
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            Task task2 = (Task)tasks.get(0);
            Assert.assertEquals((long)1L, (long)task2.getActors().size());
            Assert.assertEquals((Object)"myuser1", task2.getActors().get(0));
            Assert.assertEquals((long)1L, (long)task2.getDelegatedActors().size());
            Assert.assertEquals((Object)"myuser2", task2.getDelegatedActors().get(0));
            docs = this.routing.getWorkflowInputDocuments(sessionUser2, task2);
            Assert.assertTrue((boolean)sessionUser2.hasPermission(((DocumentModel)docs.get(0)).getRef(), "Write"));
            this.routing.endTask(sessionUser2, task2, data, "trans1");
        }
        catch (Throwable throwable) {
            docs2 = throwable;
            throw throwable;
        }
        finally {
            if (sessionUser2 != null) {
                if (docs2 != null) {
                    try {
                        sessionUser2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)docs2).addSuppressed(throwable);
                    }
                } else {
                    sessionUser2.close();
                }
            }
        }
        UserPrincipal admin = new UserPrincipal("admin", null, false, true);
        try (CoreSession adminSession = this.openSession((NuxeoPrincipal)admin);){
            route = (DocumentRoute)adminSession.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
            Assert.assertTrue((boolean)route.isDone());
            Assert.assertEquals((Object)"test", (Object)route.getDocument().getPropertyValue("fctroute1:globalVariable"));
            Assert.assertFalse((boolean)adminSession.hasPermission((Principal)user2, ((DocumentModel)docs.get(0)).getRef(), "Write"));
            Assert.assertFalse((boolean)adminSession.hasPermission((Principal)user1, ((DocumentModel)docs.get(0)).getRef(), "Write"));
        }
    }

    @Test
    public void testWorkflowOnMultipleDocuments() throws Exception {
        List docs;
        DocumentModel doc2 = this.session.createDocumentModel("/", "file", "File");
        doc2.setPropertyValue("dc:title", (Serializable)((Object)"file"));
        doc2 = this.session.createDocument(doc2);
        ArrayList<String> docIds = new ArrayList<String>();
        docIds.add(this.doc.getId());
        docIds.add(doc2.getId());
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        Assert.assertNotNull((Object)user1);
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc.addFacet("FacetRoute1");
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "NodeVariables[\"button\"] == \"trans1\"", "testchain_title1"));
        node1.setPropertyValue("rnode:outputChain", (Serializable)((Object)"testchain_title1"));
        node1.setPropertyValue("rnode:taskAssigneesPermission", (Serializable)((Object)"Write"));
        node1.setPropertyValue("rnode:inputChain", (Serializable)((Object)"test_setGlobalvariable"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:taskDocType", (Serializable)((Object)"MyTaskDoc"));
        String[] users = new String[]{user1.getName()};
        node1.setPropertyValue("rnode:taskAssignees", (Serializable)users);
        this.setButtons(node1, this.button("btn1", "label-btn1", "filterrr"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute route = this.instantiateAndRun(this.session, docIds, null);
        List tasks = this.taskService.getTaskInstances(this.doc, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = this.taskService.getTaskInstances(doc2, user1, this.session);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        try (CoreSession sessionUser1 = this.openSession(user1);){
            Task task1 = (Task)tasks.get(0);
            Assert.assertEquals((Object)"MyTaskDoc", (Object)task1.getDocument().getType());
            docs = this.routing.getWorkflowInputDocuments(sessionUser1, task1);
            Assert.assertEquals((long)2L, (long)docs.size());
            Assert.assertTrue((boolean)sessionUser1.hasPermission(((DocumentModel)docs.get(0)).getRef(), "Write"));
            Assert.assertTrue((boolean)sessionUser1.hasPermission(((DocumentModel)docs.get(1)).getRef(), "Write"));
            HashMap data = new HashMap();
            this.routing.endTask(sessionUser1, (Task)tasks.get(0), data, "trans1");
        }
        UserPrincipal admin = new UserPrincipal("admin", null, false, true);
        try (CoreSession adminSession = this.openSession((NuxeoPrincipal)admin);){
            route = (DocumentRoute)adminSession.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
            Assert.assertTrue((boolean)route.isDone());
            Assert.assertEquals((Object)"test", (Object)route.getDocument().getPropertyValue("fctroute1:globalVariable"));
            this.doc = adminSession.getDocument(this.doc.getRef());
            Assert.assertEquals((Object)"title 1", (Object)this.doc.getTitle());
            doc2 = adminSession.getDocument(doc2.getRef());
            Assert.assertEquals((Object)"title 1", (Object)doc2.getTitle());
            Assert.assertFalse((boolean)adminSession.hasPermission((Principal)user1, ((DocumentModel)docs.get(0)).getRef(), "Write"));
            Assert.assertFalse((boolean)adminSession.hasPermission((Principal)user1, ((DocumentModel)docs.get(1)).getRef(), "Write"));
        }
    }
}

