/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.test;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.api.security.impl.UserEntryImpl;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteTableElement;
import org.nuxeo.ecm.platform.routing.api.RouteFolderElement;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteAlredayLockedException;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteNotLockedException;
import org.nuxeo.ecm.platform.routing.test.DocumentRoutingTestCase;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TestDocumentRoutingService
extends DocumentRoutingTestCase {
    protected File tmp;

    @After
    public void tearDown() throws Exception {
        if (this.tmp != null) {
            this.tmp.delete();
        }
    }

    @Test
    @Deprecated
    public void testAddStepToDraftRoute() throws Exception {
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        this.session.save();
        Assert.assertNotNull((Object)route);
        DocumentModel step = this.session.createDocumentModel(route.getDocument().getPathAsString(), "step31bis", "DocumentRouteStep");
        step.setPropertyValue("dc:title", (Serializable)((Object)"step31bis"));
        DocumentModelList stepFolders = this.session.query("Select * From Document WHERE dc:title = 'parallel1'");
        Assert.assertEquals((long)1L, (long)stepFolders.size());
        DocumentModel parallel1 = (DocumentModel)stepFolders.get(0);
        this.service.lockDocumentRoute(route, this.session);
        this.service.addRouteElementToRoute(parallel1.getRef(), "step32", (DocumentRouteElement)step.getAdapter(DocumentRouteElement.class), this.session);
        this.service.unlockDocumentRouteUnrestrictedSession(route, this.session);
        DocumentModelList parallel1Childs = this.service.getOrderedRouteElement(parallel1.getId(), this.session);
        Assert.assertEquals((long)3L, (long)parallel1Childs.size());
        step = (DocumentModel)parallel1Childs.get(1);
        Assert.assertEquals((Object)"step31bis", (Object)step.getTitle());
        step = this.session.createDocumentModel(route.getDocument().getPathAsString(), "step33", "DocumentRouteStep");
        step.setPropertyValue("dc:title", (Serializable)((Object)"step33"));
        this.service.lockDocumentRoute(route, this.session);
        this.service.addRouteElementToRoute(parallel1.getRef(), null, (DocumentRouteElement)step.getAdapter(DocumentRouteElement.class), this.session);
        this.service.unlockDocumentRoute(route, this.session);
        parallel1Childs = this.service.getOrderedRouteElement(parallel1.getId(), this.session);
        Assert.assertEquals((long)4L, (long)parallel1Childs.size());
        step = (DocumentModel)parallel1Childs.get(3);
        Assert.assertEquals((Object)"step33", (Object)step.getTitle());
        step = this.session.createDocumentModel(route.getDocument().getPathAsString(), "step30", "DocumentRouteStep");
        step.setPropertyValue("dc:title", (Serializable)((Object)"step30"));
        this.service.lockDocumentRoute(route, this.session);
        this.service.addRouteElementToRoute(parallel1.getRef(), 0, (DocumentRouteElement)step.getAdapter(DocumentRouteElement.class), this.session);
        parallel1Childs = this.service.getOrderedRouteElement(parallel1.getId(), this.session);
        this.service.unlockDocumentRoute(route, this.session);
        Assert.assertEquals((long)5L, (long)parallel1Childs.size());
        step = (DocumentModel)parallel1Childs.get(0);
        Assert.assertEquals((Object)"step30", (Object)step.getTitle());
        step = this.session.createDocumentModel(route.getDocument().getPathAsString(), "step34", "DocumentRouteStep");
        step.setPropertyValue("dc:title", (Serializable)((Object)"step34"));
        this.service.lockDocumentRoute(route, this.session);
        this.service.addRouteElementToRoute(parallel1.getRef(), 5, (DocumentRouteElement)step.getAdapter(DocumentRouteElement.class), this.session);
        parallel1Childs = this.service.getOrderedRouteElement(parallel1.getId(), this.session);
        this.service.unlockDocumentRoute(route, this.session);
        Assert.assertEquals((long)6L, (long)parallel1Childs.size());
        step = (DocumentModel)parallel1Childs.get(5);
        Assert.assertEquals((Object)"step34", (Object)step.getTitle());
        step = this.session.createDocumentModel(route.getDocument().getPathAsString(), "step33bis", "DocumentRouteStep");
        step.setPropertyValue("dc:title", (Serializable)((Object)"step33bis"));
        this.service.lockDocumentRoute(route, this.session);
        this.service.addRouteElementToRoute(parallel1.getRef(), 5, (DocumentRouteElement)step.getAdapter(DocumentRouteElement.class), this.session);
        this.service.unlockDocumentRoute(route, this.session);
        parallel1Childs = this.service.getOrderedRouteElement(parallel1.getId(), this.session);
        Assert.assertEquals((long)7L, (long)parallel1Childs.size());
        step = (DocumentModel)parallel1Childs.get(5);
        Assert.assertEquals((Object)"step33bis", (Object)step.getTitle());
    }

    @Test
    @Deprecated
    public void testRemoveStep() throws Exception {
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        Assert.assertNotNull((Object)route);
        this.session.save();
        DocumentModel stepFolder = this.session.getDocument((DocumentRef)new PathRef("/default-domain/workspaces/route1/parallel1/"));
        DocumentModelList childs = this.service.getOrderedRouteElement(stepFolder.getId(), this.session);
        Assert.assertEquals((long)2L, (long)childs.size());
        DocumentModel step32 = this.session.getDocument((DocumentRef)new PathRef("/default-domain/workspaces/route1/parallel1/step32"));
        Assert.assertNotNull((Object)step32);
        this.service.lockDocumentRoute(route, this.session);
        this.service.removeRouteElement((DocumentRouteElement)step32.getAdapter(DocumentRouteElement.class), this.session);
        this.service.unlockDocumentRoute(route, this.session);
        childs = this.service.getOrderedRouteElement(stepFolder.getId(), this.session);
        Assert.assertEquals((long)1L, (long)childs.size());
    }

    @Test
    public void testSaveInstanceAsNewModel() throws Exception {
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        this.service.lockDocumentRoute(route, this.session);
        route = this.service.validateRouteModel(route, this.session);
        this.service.unlockDocumentRouteUnrestrictedSession(route, this.session);
        this.session.save();
        this.waitForAsyncExec();
        route = this.service.createNewInstance(route, new ArrayList(), this.session, true);
        Assert.assertNotNull((Object)route);
        this.session.save();
        try (CoreSession managersSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"routeManagers");){
            DocumentModel step = (DocumentModel)managersSession.getChildren(route.getDocument().getRef()).get(0);
            this.service.lockDocumentRoute(route, managersSession);
            this.service.removeRouteElement((DocumentRouteElement)step.getAdapter(DocumentRouteElement.class), managersSession);
            this.service.unlockDocumentRoute(route, managersSession);
            DocumentRoute newModel = this.service.saveRouteAsNewModel(route, managersSession);
            Assert.assertNotNull((Object)newModel);
            Assert.assertEquals((Object)"(COPY) route1", (Object)newModel.getDocument().getPropertyValue("dc:title"));
        }
    }

    @Test
    @Deprecated
    public void testRemoveStepFromLockedRoute() throws Exception {
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        Assert.assertNotNull((Object)route);
        this.session.save();
        DocumentModel stepFolder = this.session.getDocument((DocumentRef)new PathRef("/default-domain/workspaces/route1/parallel1/"));
        DocumentModelList childs = this.service.getOrderedRouteElement(stepFolder.getId(), this.session);
        Assert.assertEquals((long)2L, (long)childs.size());
        DocumentModel step32 = this.session.getDocument((DocumentRef)new PathRef("/default-domain/workspaces/route1/parallel1/step32"));
        Assert.assertNotNull((Object)step32);
        this.service.lockDocumentRoute(route, this.session);
        DocumentModel routeModel = route.getDocument();
        ACP acp = routeModel.getACP();
        ACL localACL = acp.getOrCreateACL("local");
        localACL.add(new ACE("Everyone", "Everything", true));
        acp.addACL(localACL);
        routeModel.setACP(acp, true);
        this.session.saveDocument(routeModel);
        this.session.save();
        try (CoreSession jdoeSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"jdoe");){
            Throwable e = null;
            try {
                this.service.lockDocumentRoute(route, jdoeSession);
            }
            catch (DocumentRouteAlredayLockedException e2) {
                e = e2;
            }
            Assert.assertNotNull((Object)e);
        }
        this.service.removeRouteElement((DocumentRouteElement)step32.getAdapter(DocumentRouteElement.class), this.session);
        this.service.unlockDocumentRoute(route, this.session);
        jdoeSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"jdoe");
        var9_9 = null;
        try {
            e = null;
            try {
                this.service.unlockDocumentRoute(route, jdoeSession);
            }
            catch (DocumentRouteNotLockedException e2) {
                e = e2;
            }
            Assert.assertNotNull((Object)e);
            childs = this.service.getOrderedRouteElement(stepFolder.getId(), jdoeSession);
            Assert.assertEquals((long)1L, (long)childs.size());
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (jdoeSession != null) {
                if (var9_9 != null) {
                    try {
                        jdoeSession.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    jdoeSession.close();
                }
            }
        }
    }

    @Test
    public void testCreateNewInstance() throws Exception {
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        Assert.assertNotNull((Object)route);
        this.session.save();
        List routes = this.service.getAvailableDocumentRoute(this.session);
        Assert.assertEquals((long)1L, (long)routes.size());
        DocumentRoute routeModel = (DocumentRoute)routes.get(0);
        DocumentModel doc1 = this.createTestDocument("test1", this.session);
        this.session.save();
        this.service.lockDocumentRoute(route, this.session);
        route = this.service.validateRouteModel(route, this.session);
        this.service.unlockDocumentRouteUnrestrictedSession(route, this.session);
        this.session.save();
        Assert.assertEquals((Object)"validated", (Object)route.getDocument().getCurrentLifeCycleState());
        Assert.assertEquals((Object)"validated", (Object)((DocumentModel)this.session.getChildren(route.getDocument().getRef()).get(0)).getCurrentLifeCycleState());
        this.session.save();
        this.waitForAsyncExec();
        DocumentRoute routeInstance = this.service.createNewInstance(routeModel, Collections.singletonList(doc1.getId()), this.session, true);
        Assert.assertTrue((boolean)routeInstance.isDone());
        String routeDocId = this.service.getRouteModelDocIdWithId(this.session, "route1");
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(routeDocId));
        route = (DocumentRoute)doc.getAdapter(DocumentRoute.class);
        Assert.assertNotNull((Object)route);
        routes = this.service.getAvailableDocumentRoute(this.session);
        Assert.assertEquals((long)2L, (long)routes.size());
    }

    @Test
    public void testGetAvailableDocumentRouteModel() {
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        Assert.assertNotNull((Object)route);
        this.session.save();
        List routes = this.service.getAvailableDocumentRoute(this.session);
        Assert.assertEquals((long)1L, (long)routes.size());
    }

    @Test
    public void testRouteModel() {
        DocumentModel folder = this.createDocumentModel(this.session, "TestFolder", "Folder", "/");
        this.session.save();
        Assert.assertNotNull((Object)folder);
        this.setPermissionToUser(folder, "jdoe", "Write");
        DocumentModel route = this.createDocumentRouteModel(this.session, "route1", folder.getPathAsString());
        this.session.save();
        Assert.assertNotNull((Object)route);
        this.service.lockDocumentRoute((DocumentRoute)route.getAdapter(DocumentRoute.class), this.session);
        route = this.service.validateRouteModel((DocumentRoute)route.getAdapter(DocumentRoute.class), this.session).getDocument();
        this.session.save();
        this.service.unlockDocumentRouteUnrestrictedSession((DocumentRoute)route.getAdapter(DocumentRoute.class), this.session);
        route = this.session.getDocument(route.getRef());
        Assert.assertEquals((Object)"validated", (Object)route.getCurrentLifeCycleState());
        try (CoreSession jdoeSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"jdoe");){
            Assert.assertFalse((boolean)jdoeSession.hasPermission(route.getRef(), "Write"));
            Assert.assertTrue((boolean)jdoeSession.hasPermission(route.getRef(), "Read"));
        }
    }

    @Test
    @Deprecated
    public void testConditionalFolderContainerModel() {
        DocumentRoute route = this.createDocumentRouteWithConditionalFolder(this.session, "route1");
        DocumentModel conditionalStepFolder = this.session.getChild(route.getDocument().getRef(), "conditionalStep2");
        DocumentModelList children = this.service.getOrderedRouteElement(conditionalStepFolder.getId(), this.session);
        Assert.assertEquals((Object)"DocumentRouteStep", (Object)((DocumentModel)children.get(0)).getType());
        DocumentModel branch1 = (DocumentModel)children.get(1);
        Assert.assertEquals((Object)"StepFolder", (Object)branch1.getType());
        Assert.assertEquals((Object)"executeIfOption1", (Object)((DocumentModel)this.session.getChildren(branch1.getRef()).get(0)).getName());
        DocumentModel branch2 = (DocumentModel)children.get(2);
        Assert.assertEquals((Object)"StepFolder", (Object)branch2.getType());
        Assert.assertEquals((Object)"executeIfOption2", (Object)((DocumentModel)this.session.getChildren(branch2.getRef()).get(0)).getName());
    }

    @Test
    public void testGetRouteElements() {
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        Assert.assertNotNull((Object)route);
        List elements = this.service.getRouteElements(route, this.session);
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)4L, (long)elements.size());
        for (DocumentRouteTableElement element : elements) {
            Assert.assertEquals((long)1L, (long)element.getRouteMaxDepth());
        }
        Assert.assertEquals((long)1L, (long)((DocumentRouteTableElement)elements.get(2)).getFirstChildFolders().size());
        Assert.assertEquals((long)0L, (long)((DocumentRouteTableElement)elements.get(3)).getFirstChildFolders().size());
        Assert.assertEquals((long)2L, (long)((RouteFolderElement)((DocumentRouteTableElement)elements.get(2)).getFirstChildFolders().get(0)).getTotalChildCount());
        Assert.assertEquals((long)4L, (long)((DocumentRouteTableElement)elements.get(0)).getRouteTable().getTotalChildCount());
    }

    @Test
    @Deprecated
    public void testExecuteSimpleRouteWithConditionalStep() {
        DocumentRoute route = this.createDocumentRouteWithConditionalFolder(this.session, "route1");
        DocumentModel conditionalStepFolder = this.session.getChild(route.getDocument().getRef(), "conditionalStep2");
        DocumentModelList children = this.service.getOrderedRouteElement(conditionalStepFolder.getId(), this.session);
        Assert.assertEquals((Object)"DocumentRouteStep", (Object)((DocumentModel)children.get(0)).getType());
        Assert.assertEquals((Object)"StepFolder", (Object)((DocumentModel)children.get(1)).getType());
        Assert.assertEquals((Object)"StepFolder", (Object)((DocumentModel)children.get(2)).getType());
        conditionalStepFolder.setPropertyValue("condstepf:posOfChildStepToRunNext", (Serializable)((Object)"1"));
        this.session.saveDocument(conditionalStepFolder);
        this.service.lockDocumentRoute(route, this.session);
        route = this.service.validateRouteModel(route, this.session);
        DocumentRef routeRef = route.getDocument().getRef();
        this.service.unlockDocumentRouteUnrestrictedSession(route, this.session);
        this.session.save();
        Assert.assertEquals((Object)"validated", (Object)route.getDocument().getCurrentLifeCycleState());
        Assert.assertEquals((Object)"validated", (Object)((DocumentModel)this.session.getChildren(routeRef).get(0)).getCurrentLifeCycleState());
        DocumentModel doc1 = this.createTestDocument("test1", this.session);
        this.session.save();
        this.waitForAsyncExec();
        try (CoreSession managerSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"routeManagers");){
            route = (DocumentRoute)managerSession.getDocument(routeRef).getAdapter(DocumentRoute.class);
            DocumentRoute routeInstance = this.service.createNewInstance(route, Collections.singletonList(doc1.getId()), managerSession, true);
            managerSession.save();
            this.waitForAsyncExec();
            Assert.assertTrue((boolean)routeInstance.isDone());
            children = managerSession.getChildren(routeInstance.getDocument().getRef(), "ConditionalStepFolder");
            children = this.service.getOrderedRouteElement(((DocumentModel)children.get(0)).getId(), managerSession);
            Assert.assertEquals((Object)"done", (Object)((DocumentModel)children.get(1)).getCurrentLifeCycleState());
            Assert.assertEquals((Object)"canceled", (Object)((DocumentModel)children.get(2)).getCurrentLifeCycleState());
        }
    }

    protected void setPermissionToUser(DocumentModel doc, String username, String ... perms) {
        ACP acp = doc.getACP();
        if (acp == null) {
            acp = new ACPImpl();
        }
        UserEntryImpl userEntry = new UserEntryImpl(username);
        for (String perm : perms) {
            userEntry.addPrivilege(perm, true, false);
        }
        acp.setRules("test", new UserEntry[]{userEntry});
        doc.setACP(acp, true);
        this.session.save();
    }

    protected void waitForAsyncExec() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        ((EventService)Framework.getService(EventService.class)).waitForAsyncCompletion();
    }
}

