/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.test.annotations.RepositoryInit;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.RouteModelResourceType;
import org.nuxeo.ecm.platform.routing.test.DocumentRoutingTestCase;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;

@Deploy(value={"org.nuxeo.ecm.platform.filemanager.core", "org.nuxeo.ecm.platform.query.api", "org.nuxeo.ecm.platform.task.core", "org.nuxeo.ecm.platform.routing.core.test"})
@RepositoryConfig(init=ImportRouteRepositoryInit.class, cleanup=Granularity.METHOD)
public class TestDocumentRoutingServiceImport
extends DocumentRoutingTestCase {
    protected static File tmp;

    @After
    public void tearDown() throws Exception {
        if (tmp != null) {
            tmp.delete();
            tmp = null;
        }
    }

    @Test
    public void testImportRouteModel() throws Exception {
        DocumentModel node;
        this.service.importAllRouteModels(this.session);
        DocumentModel modelsRoot = this.session.getDocument((DocumentRef)new PathRef("/document-route-models-root/"));
        Assert.assertNotNull((Object)modelsRoot);
        DocumentModel route = this.session.getDocument((DocumentRef)new PathRef("/document-route-models-root/myRoute"));
        Assert.assertNotNull((Object)route);
        String routeDocId = this.service.getRouteModelDocIdWithId(this.session, "myRoute");
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(routeDocId));
        DocumentRoute model = (DocumentRoute)doc.getAdapter(DocumentRoute.class);
        Assert.assertEquals((Object)route.getId(), (Object)model.getDocument().getId());
        ACL newAcl = route.getACP().getACL("testrouting");
        Assert.assertNotNull((Object)newAcl);
        Assert.assertEquals((long)1L, (long)newAcl.getACEs().length);
        Assert.assertEquals((Object)"testusername", (Object)newAcl.getACEs()[0].getUsername());
        Assert.assertTrue((boolean)StringUtils.isBlank((String)((String)((Object)route.getPropertyValue("dc:coverage")))));
        try {
            node = this.session.getDocument((DocumentRef)new PathRef("/document-route-models-root/myRoute/myNode"));
        }
        catch (DocumentNotFoundException e) {
            node = null;
        }
        Assert.assertNull(node);
        Assert.assertEquals((Object)"DocumentRoute", (Object)route.getType());
        DocumentModel step1 = this.session.getDocument((DocumentRef)new PathRef("/document-route-models-root/myRoute/Step1"));
        Assert.assertNotNull((Object)step1);
        Assert.assertEquals((Object)"RouteNode", (Object)step1.getType());
        DocumentModel step2 = this.session.getDocument((DocumentRef)new PathRef("/document-route-models-root/myRoute/Step2"));
        Assert.assertNotNull((Object)step2);
        Assert.assertEquals((Object)"RouteNode", (Object)step2.getType());
    }

    public static class ImportRouteRepositoryInit
    implements RepositoryInit {
        public void populate(CoreSession session) {
            try {
                this.populate0(session);
            }
            catch (IOException | URISyntaxException e) {
                throw new NuxeoException((Throwable)e);
            }
        }

        public void populate0(CoreSession session) throws IOException, URISyntaxException {
            DocumentModel root = this.createDocumentModel(session, "document-route-models-root", "DocumentRouteModelsRoot", "/");
            Assert.assertNotNull((Object)root);
            DocumentModel route = this.createDocumentModel(session, "myRoute", "DocumentRoute", "/document-route-models-root/");
            route.setPropertyValue("dc:coverage", (Serializable)((Object)"test"));
            route = session.saveDocument(route);
            ACP acp = route.getACP();
            ACL acl = acp.getOrCreateACL("testrouting");
            acl.add(new ACE("testusername", "Write", true));
            acp.addACL(acl);
            route.setACP(acp, true);
            route = session.saveDocument(route);
            Assert.assertNotNull((Object)route);
            Assert.assertEquals((Object)"test", (Object)route.getPropertyValue("dc:coverage"));
            DocumentModel node = this.createDocumentModel(session, "myNode", "RouteNode", "/document-route-models-root/myRoute");
            Assert.assertNotNull((Object)node);
            tmp = Framework.createTempFile((String)"nuxeoRoutingTest", (String)".zip");
            ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(tmp));
            URL url = this.getClass().getResource("/routes/myRoute");
            File dir = new File(url.toURI().getPath());
            this.zipTree("", dir, false, zout);
            zout.finish();
            zout.close();
            RouteModelResourceType resource = new RouteModelResourceType();
            resource.setId("test");
            resource.setPath(tmp.getPath());
            resource.setUrl(tmp.toURI().toURL());
            DocumentRoutingService service = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
            service.registerRouteResource(resource, null);
        }

        protected DocumentModel createDocumentModel(CoreSession session, String name, String type, String path) {
            DocumentModel doc = session.createDocumentModel(path, name, type);
            doc.setPropertyValue("dc:title", (Serializable)((Object)name));
            return session.createDocument(doc);
        }

        protected void zipTree(String prefix, File root, boolean includeRoot, ZipOutputStream zout) throws IOException {
            if (includeRoot) {
                prefix = prefix + root.getName() + '/';
                this.zipDirectory(prefix, zout);
            }
            for (String name : root.list()) {
                File file = new File(root, name);
                if (file.isDirectory()) {
                    this.zipTree(prefix, file, true, zout);
                    continue;
                }
                if (name.endsWith("~") || name.endsWith("#") || name.endsWith(".bak")) continue;
                name = prefix + name;
                this.zipFile(name, file, zout);
            }
        }

        protected void zipDirectory(String entryName, ZipOutputStream zout) throws IOException {
            ZipEntry zentry = new ZipEntry(entryName);
            zout.putNextEntry(zentry);
            zout.closeEntry();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void zipFile(String entryName, File file, ZipOutputStream zout) throws IOException {
            ZipEntry zentry = new ZipEntry(entryName);
            zentry.setTime(file.lastModified());
            zout.putNextEntry(zentry);
            try (FileInputStream in = new FileInputStream(file);){
                IOUtils.copy((InputStream)in, (OutputStream)zout);
            }
            zout.closeEntry();
        }
    }
}

