/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.test;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteStep;
import org.nuxeo.ecm.platform.routing.test.CounterListener;
import org.nuxeo.ecm.platform.routing.test.DocumentRoutingTestCase;
import org.nuxeo.ecm.platform.routing.test.WaitingStepRuntimePersister;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Deploy(value={"org.nuxeo.ecm.platform.routing.core.test"})
public class TestDocumentRoutingServiceWait
extends DocumentRoutingTestCase {
    protected File tmp;

    @After
    public void tearDown() throws Exception {
        if (this.tmp != null) {
            this.tmp.delete();
        }
    }

    @Test
    public void testAddSameNamedStepToRunningRoute() throws Exception {
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        DocumentModelList childrens = this.session.getChildren(route.getDocument().getRef());
        String firstStepId = ((DocumentModel)childrens.get(0)).getId();
        String secondStepId = ((DocumentModel)childrens.get(1)).getId();
        String folderId = ((DocumentModel)childrens.get(2)).getId();
        this.service.lockDocumentRoute(route, this.session);
        DocumentModel newStep = this.session.createDocumentModel(route.getDocument().getPathAsString(), "step1", "DocumentRouteStep");
        this.service.addRouteElementToRoute(route.getDocument().getRef(), null, (DocumentRouteElement)newStep.getAdapter(DocumentRouteElement.class), this.session);
        this.session.save();
        Assert.assertNotNull((Object)route);
        childrens = this.session.getChildren(route.getDocument().getRef());
        Assert.assertEquals((long)4L, (long)childrens.size());
        Assert.assertEquals((Object)firstStepId, (Object)((DocumentModel)childrens.get(0)).getId());
        Assert.assertEquals((Object)secondStepId, (Object)((DocumentModel)childrens.get(1)).getId());
        Assert.assertEquals((Object)folderId, (Object)((DocumentModel)childrens.get(2)).getId());
        Assert.assertTrue((!"step1".equals(((DocumentModel)childrens.get(3)).getName()) ? 1 : 0) != 0);
    }

    @Test
    public void testAddStepToRunningRoute() throws Exception {
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        this.service.lockDocumentRoute(route, this.session);
        this.service.validateRouteModel(route, this.session);
        this.service.unlockDocumentRouteUnrestrictedSession(route, this.session);
        route = this.service.createNewInstance(route, new ArrayList(), this.session, true);
        this.session.save();
        Assert.assertNotNull((Object)route);
        DocumentModel step = this.session.createDocumentModel(route.getDocument().getPathAsString(), "step31bis", "DocumentRouteStep");
        step.setPropertyValue("dc:title", (Serializable)((Object)"step31bis"));
        DocumentModelList stepFolders = this.session.query("Select * From Document WHERE dc:title = 'parallel1' and ecm:currentLifeCycleState = 'ready'");
        Assert.assertEquals((long)1L, (long)stepFolders.size());
        DocumentModel parallel1 = (DocumentModel)stepFolders.get(0);
        this.service.lockDocumentRoute(route, this.session);
        this.service.addRouteElementToRoute(parallel1.getRef(), "step32", (DocumentRouteElement)step.getAdapter(DocumentRouteElement.class), this.session);
        this.service.unlockDocumentRoute(route, this.session);
        Assert.assertNotNull((Object)route);
        Assert.assertFalse((boolean)route.isDone());
        List<String> waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)3L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)2L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        Assert.assertFalse((boolean)route.isDone());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        Assert.assertEquals((long)0L, (long)waiting.size());
        route = (DocumentRoute)this.session.getDocument(route.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)route.isDone());
    }

    @Test
    public void testDocumentRouteWithWaitState() throws Exception {
        CounterListener.resetCouner();
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        Assert.assertNotNull((Object)route);
        this.session.save();
        List routes = this.service.getAvailableDocumentRoute(this.session);
        Assert.assertEquals((long)1L, (long)routes.size());
        DocumentRoute routeModel = (DocumentRoute)routes.get(0);
        DocumentModel doc1 = this.createTestDocument("test1", this.session);
        this.session.save();
        this.service.lockDocumentRoute(route, this.session);
        route = this.service.validateRouteModel(route, this.session);
        this.service.unlockDocumentRouteUnrestrictedSession(route, this.session);
        Assert.assertEquals((Object)"validated", (Object)route.getDocument().getCurrentLifeCycleState());
        Assert.assertEquals((Object)"validated", (Object)((DocumentModel)this.session.getChildren(route.getDocument().getRef()).get(0)).getCurrentLifeCycleState());
        this.session.save();
        this.waitForAsyncExec();
        DocumentRoute routeInstance = this.service.createNewInstance(routeModel, Collections.singletonList(doc1.getId()), this.session, true);
        Assert.assertNotNull((Object)routeInstance);
        Assert.assertFalse((boolean)routeInstance.isDone());
        Assert.assertEquals((long)1L, (long)this.service.getDocumentRoutesForAttachedDocument(this.session, doc1.getId()).size());
        List<String> waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)2L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        Assert.assertFalse((boolean)routeInstance.isDone());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        Assert.assertEquals((long)0L, (long)waiting.size());
        routeInstance = (DocumentRoute)this.session.getDocument(routeInstance.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)routeInstance.isDone());
        Assert.assertEquals((long)20L, (long)CounterListener.getCounter());
    }

    @Test
    public void testCancelRoute() throws Exception {
        CounterListener.resetCouner();
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        Assert.assertNotNull((Object)route);
        this.session.save();
        List routes = this.service.getAvailableDocumentRoute(this.session);
        Assert.assertEquals((long)1L, (long)routes.size());
        DocumentRoute routeModel = (DocumentRoute)routes.get(0);
        DocumentModel doc1 = this.createTestDocument("test1", this.session);
        this.session.save();
        this.service.lockDocumentRoute(route, this.session);
        route = this.service.validateRouteModel(route, this.session);
        this.service.unlockDocumentRouteUnrestrictedSession(route, this.session);
        Assert.assertEquals((Object)"validated", (Object)route.getDocument().getCurrentLifeCycleState());
        Assert.assertEquals((Object)"validated", (Object)((DocumentModel)this.session.getChildren(route.getDocument().getRef()).get(0)).getCurrentLifeCycleState());
        this.session.save();
        this.waitForAsyncExec();
        DocumentRoute routeInstance = this.service.createNewInstance(routeModel, Collections.singletonList(doc1.getId()), this.session, true);
        Assert.assertNotNull((Object)routeInstance);
        Assert.assertFalse((boolean)routeInstance.isDone());
        Assert.assertEquals((long)1L, (long)this.service.getDocumentRoutesForAttachedDocument(this.session, doc1.getId()).size());
        List<String> waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        routeInstance.cancel(this.session);
        Assert.assertTrue((boolean)routeInstance.isCanceled());
        DocumentModelList children = this.session.getChildren(routeInstance.getDocument().getRef());
        do {
            for (DocumentModel doc : children) {
                Assert.assertTrue((boolean)doc.getCurrentLifeCycleState().equals("canceled"));
            }
            children = new DocumentModelListImpl();
            for (DocumentModel doc : children) {
                children.addAll((Collection)this.session.getChildren(doc.getRef()));
            }
        } while (!children.isEmpty());
    }

    @Test
    public void testDocumentRouteWithStepBack() throws Exception {
        CounterListener.resetCouner();
        DocumentRoute route = this.createDocumentRoute(this.session, "route1");
        Assert.assertNotNull((Object)route);
        this.session.save();
        List routes = this.service.getAvailableDocumentRoute(this.session);
        Assert.assertEquals((long)1L, (long)routes.size());
        DocumentRoute routeModel = (DocumentRoute)routes.get(0);
        DocumentModel doc1 = this.createTestDocument("test1", this.session);
        this.session.save();
        this.service.lockDocumentRoute(route, this.session);
        route = this.service.validateRouteModel(route, this.session);
        this.service.unlockDocumentRouteUnrestrictedSession(route, this.session);
        Assert.assertEquals((Object)"validated", (Object)route.getDocument().getCurrentLifeCycleState());
        Assert.assertEquals((Object)"validated", (Object)((DocumentModel)this.session.getChildren(route.getDocument().getRef()).get(0)).getCurrentLifeCycleState());
        this.session.save();
        this.waitForAsyncExec();
        DocumentRoute routeInstance = this.service.createNewInstance(routeModel, Collections.singletonList(doc1.getId()), this.session, true);
        Assert.assertNotNull((Object)routeInstance);
        Assert.assertFalse((boolean)routeInstance.isDone());
        Assert.assertEquals((long)1L, (long)this.service.getDocumentRoutesForAttachedDocument(this.session, doc1.getId()).size());
        List<String> waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        String firstStepId = waiting.get(0);
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        String secondStepId = waiting.get(0);
        DocumentRouteStep step = WaitingStepRuntimePersister.getStep(secondStepId, this.session);
        Assert.assertTrue((boolean)step.canUndoStep(this.session));
        step = step.undo(this.session);
        Assert.assertTrue((boolean)step.isReady());
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        routeInstance.run(this.session);
        DocumentRouteStep firstStep = WaitingStepRuntimePersister.getStep(firstStepId, this.session);
        DocumentRouteStep secondStep = WaitingStepRuntimePersister.getStep(secondStepId, this.session);
        secondStep = secondStep.undo(this.session);
        firstStep = firstStep.undo(this.session);
        Assert.assertTrue((boolean)secondStep.isReady());
        Assert.assertTrue((boolean)firstStep.isReady());
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        routeInstance.run(this.session);
        WaitingStepRuntimePersister.resumeStep(firstStepId, this.session);
        WaitingStepRuntimePersister.resumeStep(secondStepId, this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)2L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        Assert.assertFalse((boolean)routeInstance.isDone());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        Assert.assertEquals((long)0L, (long)waiting.size());
        routeInstance = (DocumentRoute)this.session.getDocument(routeInstance.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)routeInstance.isDone());
        Assert.assertFalse((boolean)routeInstance.canUndoStep(this.session));
    }

    @Test
    public void testDocumentRouteWithWaitStateAndSecurity() throws Exception {
        DocumentRef routeInstanceRef;
        CounterListener.resetCouner();
        try (CoreSession bobSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"bob");){
            DocumentRoute route = this.createDocumentRoute(bobSession, "route1");
            Assert.assertNotNull((Object)route);
            bobSession.save();
            List routes = this.service.getAvailableDocumentRoute(bobSession);
            Assert.assertEquals((long)1L, (long)routes.size());
            DocumentRoute routeModel = (DocumentRoute)routes.get(0);
            DocumentModel doc1 = this.createTestDocument("test1", bobSession);
            bobSession.save();
            this.service.lockDocumentRoute(route, bobSession);
            route = this.service.validateRouteModel(route, bobSession);
            this.service.unlockDocumentRouteUnrestrictedSession(route, bobSession);
            Assert.assertEquals((Object)"validated", (Object)route.getDocument().getCurrentLifeCycleState());
            Assert.assertEquals((Object)"validated", (Object)((DocumentModel)bobSession.getChildren(route.getDocument().getRef()).get(0)).getCurrentLifeCycleState());
            bobSession.save();
            this.waitForAsyncExec();
            DocumentRoute routeInstance = this.service.createNewInstance(routeModel, Collections.singletonList(doc1.getId()), bobSession, true);
            routeInstanceRef = routeInstance.getDocument().getRef();
        }
        var3_2 = null;
        try (CoreSession jackSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"jack");){
            Assert.assertFalse((boolean)jackSession.exists(routeInstanceRef));
        }
        catch (Throwable route) {
            var3_2 = route;
            throw route;
        }
        bobSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"bob");
        var3_2 = null;
        try {
            DocumentRoute routeInstance = (DocumentRoute)bobSession.getDocument(routeInstanceRef).getAdapter(DocumentRoute.class);
            List<String> waiting = WaitingStepRuntimePersister.getRunningStepIds();
            WaitingStepRuntimePersister.resumeStep(waiting.get(0), bobSession);
            waiting = WaitingStepRuntimePersister.getRunningStepIds();
            Assert.assertEquals((long)1L, (long)waiting.size());
            WaitingStepRuntimePersister.resumeStep(waiting.get(0), bobSession);
            waiting = WaitingStepRuntimePersister.getRunningStepIds();
            Assert.assertEquals((long)2L, (long)waiting.size());
            WaitingStepRuntimePersister.resumeStep(waiting.get(0), bobSession);
            waiting = WaitingStepRuntimePersister.getRunningStepIds();
            Assert.assertEquals((long)1L, (long)waiting.size());
            Assert.assertFalse((boolean)routeInstance.isDone());
            WaitingStepRuntimePersister.resumeStep(waiting.get(0), bobSession);
            Assert.assertEquals((long)0L, (long)waiting.size());
            routeInstance = (DocumentRoute)bobSession.getDocument(routeInstanceRef).getAdapter(DocumentRoute.class);
            Assert.assertTrue((boolean)routeInstance.isDone());
            Assert.assertEquals((long)20L, (long)CounterListener.getCounter());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (bobSession != null) {
                if (var3_2 != null) {
                    try {
                        bobSession.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    bobSession.close();
                }
            }
        }
    }

    @Test
    public void testExecuteRouteWithWaitStateAndConditionalStep() throws Exception {
        DocumentRoute route = this.createDocumentRouteWithConditionalFolder(this.session, "route1");
        this.session.save();
        Assert.assertNotNull((Object)route);
        this.session.save();
        List routes = this.service.getAvailableDocumentRoute(this.session);
        Assert.assertEquals((long)1L, (long)routes.size());
        DocumentRoute routeModel = (DocumentRoute)routes.get(0);
        DocumentModel doc1 = this.createTestDocument("test1", this.session);
        this.session.save();
        this.service.lockDocumentRoute(route, this.session);
        route = this.service.validateRouteModel(route, this.session);
        this.service.unlockDocumentRouteUnrestrictedSession(route, this.session);
        Assert.assertEquals((Object)"validated", (Object)route.getDocument().getCurrentLifeCycleState());
        Assert.assertEquals((Object)"validated", (Object)((DocumentModel)this.session.getChildren(route.getDocument().getRef()).get(0)).getCurrentLifeCycleState());
        this.session.save();
        this.waitForAsyncExec();
        DocumentRoute routeInstance = this.service.createNewInstance(routeModel, Collections.singletonList(doc1.getId()), this.session, true);
        Assert.assertNotNull((Object)routeInstance);
        Assert.assertFalse((boolean)routeInstance.isDone());
        Assert.assertEquals((long)1L, (long)this.service.getDocumentRoutesForAttachedDocument(this.session, doc1.getId()).size());
        List<String> waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeDecisionalStep(waiting.get(0), this.session, "2");
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        Assert.assertEquals((Object)"executeIfOption2", (Object)this.session.getDocument((DocumentRef)new IdRef(waiting.get(0))).getName());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)1L, (long)waiting.size());
        WaitingStepRuntimePersister.resumeStep(waiting.get(0), this.session);
        waiting = WaitingStepRuntimePersister.getRunningStepIds();
        Assert.assertEquals((long)0L, (long)waiting.size());
        routeInstance = (DocumentRoute)this.session.getDocument(routeInstance.getDocument().getRef()).getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)routeInstance.isDone());
    }

    protected void waitForAsyncExec() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        ((EventService)Framework.getService(EventService.class)).waitForAsyncCompletion();
    }
}

