/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingPersister;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRoutingTreePersister;
import org.nuxeo.ecm.platform.routing.test.DocumentRoutingTestCase;

public class TestDocumentRoutingTreePersister
extends DocumentRoutingTestCase {
    protected DocumentRoutingPersister persister;

    @Before
    public void createPersister() throws Exception {
        this.persister = new DocumentRoutingTreePersister();
    }

    @Test
    public void testGetOrCreateRootOfDocumentRouteInstanceStructure() throws Exception {
        DocumentModel doc = this.persister.getOrCreateRootOfDocumentRouteInstanceStructure(this.session);
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((Object)doc.getPathAsString(), (Object)"/document-route-instances-root");
        this.session.save();
        try (CoreSession membersSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"members");){
            Assert.assertFalse((boolean)membersSession.hasPermission(doc.getRef(), "Read"));
        }
    }

    @Test
    public void testDocumentRouteInstancesRootCreation() throws Exception {
        DocumentModel firstDoc = this.session.createDocumentModel("/", "aaa", "File");
        firstDoc = this.session.createDocument(firstDoc);
        this.session.save();
        DocumentModel doc = this.persister.getOrCreateRootOfDocumentRouteInstanceStructure(this.session);
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((Object)doc.getPathAsString(), (Object)"/document-route-instances-root");
        this.session.save();
        try (CoreSession membersSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"members");){
            Assert.assertFalse((boolean)membersSession.hasPermission(doc.getRef(), "Read"));
        }
    }

    @Test
    public void testGetParentFolderForDocumentRouteInstance() {
        DocumentModel parent = this.persister.getParentFolderForDocumentRouteInstance(null, this.session);
        Assert.assertNotNull((Object)parent);
        Assert.assertTrue((boolean)parent.getPathAsString().startsWith("/document-route-instances-root"));
    }

    @Test
    public void testCreateDocumentRouteInstanceFromDocumentRouteModel() {
        DocumentModel model = this.createDocumentRouteModel(this.session, "route1", "/");
        List docsId = new ArrayList<String>();
        docsId.add("1");
        model.setPropertyValue("docri:participatingDocuments", (Serializable)((Object)docsId));
        DocumentModel instance = this.persister.createDocumentRouteInstanceFromDocumentRouteModel(model, this.session);
        Assert.assertNotNull((Object)instance);
        Assert.assertTrue((boolean)instance.getPathAsString().startsWith("/document-route-instances-root"));
        docsId = (List)((Object)instance.getPropertyValue("docri:participatingDocuments"));
        Assert.assertEquals((Object)"1", docsId.get(0));
        try (CoreSession managersSession = CoreInstance.openCoreSession((String)this.session.getRepositoryName(), (String)"routeManagers");){
            Assert.assertEquals((long)3L, (long)managersSession.getChildren(instance.getRef()).size());
        }
    }

    @Test
    public void testSaveDocumentRouteInstanceAsNewModel() {
        DocumentModel model = this.createDocumentRouteModel(this.session, "route1", "/");
        DocumentModel instance = this.persister.createDocumentRouteInstanceFromDocumentRouteModel(model, this.session);
        DocumentModel newModel = this.persister.saveDocumentRouteInstanceAsNewModel(instance, this.session.getRootDocument(), null, this.session);
        Assert.assertNotNull((Object)newModel);
    }
}

