/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.test;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEscalationService;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.test.AbstractGraphRouteTest;
import org.nuxeo.ecm.platform.routing.test.WorkflowFeature;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={WorkflowFeature.class})
public class WorkflowEscalationTest
extends AbstractGraphRouteTest {
    @Inject
    protected CoreSession session;
    @Inject
    protected FeaturesRunner featuresRunner;
    @Inject
    protected RuntimeHarness harness;
    @Inject
    protected DocumentRoutingService routing;
    @Inject
    protected DocumentRoutingEngineService routingService;
    @Inject
    protected UserManager userManager;
    @Inject
    protected TaskService taskService;
    @Inject
    protected AutomationService automationService;
    @Inject
    protected DocumentRoutingEscalationService escalationService;
    @Inject
    protected WorkManager workManager;

    @Before
    public void setUp() throws Exception {
        Assert.assertNotNull((Object)this.routing);
        this.routing.invalidateRouteModelsCache();
        this.doc = this.session.createDocumentModel("/", "file", "File");
        this.doc.setPropertyValue("dc:title", (Serializable)((Object)"file"));
        this.doc = this.session.createDocument(this.doc);
        this.routeDoc = this.createRoute("myroute", this.session);
    }

    @Test
    public void testEscalationDeleteTask() throws Exception {
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "true", "testchain_title1"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:taskDueDateExpr", (Serializable)((Object)"CurrentDate.days(-1)"));
        this.setEscalationRules(node1, this.escalationRule("rule1", "WorkflowFn.timeSinceDueDateIsOver() >=3600000", "test_resumeWf", false));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute routeInstance = this.instantiateAndRun(this.session);
        String routeInstanceId = routeInstance.getDocument().getId();
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        Task taskToBeRemoved = (Task)this.routing.getTasks(this.doc, null, routeInstanceId, null, this.session).get(0);
        this.session.removeDocument(taskToBeRemoved.getDocument().getRef());
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        List nodes = this.escalationService.queryForSuspendedNodesWithEscalation(this.session);
        Assert.assertEquals((long)1L, (long)nodes.size());
        DocumentModel nodeDoc = this.session.getDocument((DocumentRef)new IdRef((String)nodes.get(0)));
        GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
        Assert.assertEquals((Object)"node1", (Object)node.getId());
        List rules = this.escalationService.computeEscalationRulesToExecute(node);
        Assert.assertEquals((long)1L, (long)rules.size());
        this.escalationService.scheduleExecution((GraphNode.EscalationRule)rules.get(0), this.session);
        TransactionHelper.commitOrRollbackTransaction();
        this.workManager.awaitCompletion("escalation", 3L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)this.workManager.getQueueSize("escalation", null));
        TransactionHelper.startTransaction();
    }

    @Test
    public void testEscalationSingleExecution() throws Exception {
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "NodeVariables[\"button\"] == \"trans1\"", "testchain_title1"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:taskDueDateExpr", (Serializable)((Object)"CurrentDate.days(-1)"));
        this.setEscalationRules(node1, this.escalationRule("rule1", "WorkflowFn.timeSinceDueDateIsOver() >=3600000", "testchain_title1", false));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute routeInstance = this.instantiateAndRun(this.session);
        String routeInstanceId = routeInstance.getDocument().getId();
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        List nodes = this.escalationService.queryForSuspendedNodesWithEscalation(this.session);
        Assert.assertEquals((long)1L, (long)nodes.size());
        DocumentModel nodeDoc = this.session.getDocument((DocumentRef)new IdRef((String)nodes.get(0)));
        GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
        Assert.assertEquals((Object)"node1", (Object)node.getId());
        List rules = this.escalationService.computeEscalationRulesToExecute(node);
        Assert.assertEquals((long)1L, (long)rules.size());
        this.escalationService.scheduleExecution((GraphNode.EscalationRule)rules.get(0), this.session);
        TransactionHelper.commitOrRollbackTransaction();
        this.workManager.awaitCompletion("escalation", 3L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)this.workManager.getQueueSize("escalation", null));
        TransactionHelper.startTransaction();
        nodeDoc = this.session.getDocument((DocumentRef)new IdRef((String)nodes.get(0)));
        node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
        Assert.assertTrue((boolean)((GraphNode.EscalationRule)node.getEscalationRules().get(0)).isExecuted());
        this.doc = this.session.getDocument(this.doc.getRef());
        Assert.assertEquals((Object)"title 1", (Object)this.doc.getTitle());
        nodes = this.escalationService.queryForSuspendedNodesWithEscalation(this.session);
        Assert.assertEquals((long)0L, (long)nodes.size());
        this.routingService.cancel(routeInstance, this.session);
        routeInstance = (DocumentRoute)this.session.getDocument((DocumentRef)new IdRef(routeInstanceId)).getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)routeInstance.isCanceled());
    }

    @Test
    public void testEscalationMultipleExecution() throws Exception {
        NuxeoPrincipal user1 = this.userManager.getPrincipal("myuser1");
        Assert.assertNotNull((Object)user1);
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "NodeVariables[\"button\"] == \"trans1\"", "testchain_title1"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        this.setEscalationRules(node1, this.escalationRule("rule1", "( (WorkflowFn.ruleAlreadyExecuted() && WorkflowFn.timeSinceRuleHasBeenFalse() >0 ) || !WorkflowFn.ruleAlreadyExecuted()) && WorkflowFn.timeSinceTaskWasStarted() >=0", "testchain_title1", true), this.escalationRule("rule2", "true", "testchain_title2", false), this.escalationRule("rule3", "true", "testchain_stringfield", false), this.escalationRule("rule4", "true", "testchain_stringfield2", false));
        String[] users = new String[]{user1.getName()};
        node1.setPropertyValue("rnode:taskAssignees", (Serializable)users);
        this.setButtons(node1, this.button("btn1", "label-btn1", "filterr"));
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute route = this.instantiateAndRun(this.session);
        String routeInstanceId = route.getDocument().getId();
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        List nodes = this.escalationService.queryForSuspendedNodesWithEscalation(this.session);
        Assert.assertEquals((long)1L, (long)nodes.size());
        DocumentModel nodeDoc = this.session.getDocument((DocumentRef)new IdRef((String)nodes.get(0)));
        GraphNode node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
        Assert.assertEquals((Object)"node1", (Object)node.getId());
        List rules = this.escalationService.computeEscalationRulesToExecute(node);
        Assert.assertEquals((long)4L, (long)rules.size());
        this.escalationService.scheduleExecution((GraphNode.EscalationRule)rules.get(0), this.session);
        TransactionHelper.commitOrRollbackTransaction();
        this.workManager.awaitCompletion("escalation", 3L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)this.workManager.getQueueSize("escalation", null));
        TransactionHelper.startTransaction();
        this.doc = this.session.getDocument(this.doc.getRef());
        Assert.assertEquals((Object)"title 1", (Object)this.doc.getTitle());
        nodeDoc = this.session.getDocument((DocumentRef)new IdRef(node.getDocument().getId()));
        node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
        rules = this.escalationService.computeEscalationRulesToExecute(node);
        Assert.assertEquals((long)4L, (long)rules.size());
        this.escalationService.scheduleExecution((GraphNode.EscalationRule)rules.get(1), this.session);
        TransactionHelper.commitOrRollbackTransaction();
        this.workManager.awaitCompletion("escalation", 3L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)this.workManager.getQueueSize("escalation", null));
        TransactionHelper.startTransaction();
        this.doc = this.session.getDocument(this.doc.getRef());
        Assert.assertEquals((Object)"title 2", (Object)this.doc.getTitle());
        nodeDoc = this.session.getDocument((DocumentRef)new IdRef(node.getDocument().getId()));
        node = (GraphNode)nodeDoc.getAdapter(GraphNode.class);
        rules = this.escalationService.computeEscalationRulesToExecute(node);
        Assert.assertEquals((long)3L, (long)rules.size());
        this.escalationService.scheduleExecution((GraphNode.EscalationRule)rules.get(1), this.session);
        this.escalationService.scheduleExecution((GraphNode.EscalationRule)rules.get(2), this.session);
        TransactionHelper.commitOrRollbackTransaction();
        this.workManager.awaitCompletion("escalation", 3L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)this.workManager.getQueueSize("escalation", null));
        TransactionHelper.startTransaction();
        DocumentModel r = this.session.getDocument(route.getDocument().getRef());
        nodeDoc = this.session.getDocument((DocumentRef)new IdRef(node.getDocument().getId()));
        Assert.assertEquals((Object)"foo", (Object)r.getPropertyValue("fctroute1:stringfield"));
        Assert.assertEquals((Object)"bar", (Object)nodeDoc.getPropertyValue("fctnd1:stringfield2"));
        this.routingService.cancel(route, this.session);
        DocumentRoute routeInstance = (DocumentRoute)this.session.getDocument((DocumentRef)new IdRef(routeInstanceId)).getAdapter(DocumentRoute.class);
        Assert.assertTrue((boolean)routeInstance.isCanceled());
    }

    protected void setEscalationRules(DocumentModel node, Map<String, Serializable> ... rules) {
        node.setPropertyValue("rnode:escalationRules", (Serializable)((Object)Arrays.asList(rules)));
    }

    protected Map<String, Serializable> escalationRule(String id, String condition, String chain, boolean multipleExecution) {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("name", (Serializable)((Object)id));
        m.put("condition", (Serializable)((Object)condition));
        m.put("chain", (Serializable)((Object)chain));
        m.put("multipleExecution", Boolean.valueOf(multipleExecution));
        return m;
    }
}

