/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.test;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.test.AbstractGraphRouteTest;
import org.nuxeo.ecm.platform.routing.test.WorkflowFeature;
import org.nuxeo.ecm.webengine.test.WebEngineFeatureCore;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={WorkflowFeature.class, WebEngineFeatureCore.class})
public class WorkflowOperationsTest
extends AbstractGraphRouteTest {
    @Inject
    protected CoreSession session;
    @Inject
    protected DocumentRoutingService routing;
    @Inject
    protected AutomationService automationService;

    @Before
    public void setUp() throws Exception {
        Assert.assertNotNull((Object)this.routing);
        this.routing.invalidateRouteModelsCache();
        this.doc = this.session.createDocumentModel("/", "file", "File");
        this.doc.setPropertyValue("dc:title", (Serializable)((Object)"file"));
        this.doc = this.session.createDocument(this.doc);
        this.routeDoc = this.createRoute("myroute", this.session);
    }

    @Test
    public void testStartWorkflowOperation() throws Exception {
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node1 = this.session.saveDocument(node1);
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc.addFacet("FacetRoute1");
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        this.validate(this.routeDoc, this.session);
        OperationContext ctx = new OperationContext();
        ctx.setCoreSession(this.session);
        ctx.setInput((Object)this.doc);
        Properties jsonProperties = new Properties();
        jsonProperties.put((Object)"stringfield", (Object)"test");
        jsonProperties.put((Object)"myassignees", (Object)"[\"x\", \"y\"]");
        jsonProperties.put((Object)"datefield", (Object)((String)Scripting.newExpression((String)"org.nuxeo.ecm.core.schema.utils.DateParser.formatW3CDateTime(CurrentDate.date)").eval(ctx)));
        OperationChain startWorkflowChain = new OperationChain("startWorkflow");
        startWorkflowChain.add("Context.StartWorkflow").set("id", (Object)"myroute").set("variables", (Object)jsonProperties);
        this.automationService.run(ctx, startWorkflowChain);
        this.session.save();
        DocumentModel routeInstance = this.session.getDocument((DocumentRef)new IdRef((String)ctx.get((Object)"WorkflowId")));
        GraphRoute graph = (GraphRoute)routeInstance.getAdapter(GraphRoute.class);
        Map vars = graph.getVariables();
        Assert.assertEquals((Object)routeInstance.getPropertyValue("fctroute1:stringfield"), (Object)"test");
        Assert.assertEquals(vars.get("stringfield"), (Object)"test");
        String[] assignesVar = (String[])vars.get("myassignees");
        Assert.assertEquals((long)2L, (long)assignesVar.length);
        Assert.assertEquals((Object)"x", (Object)assignesVar[0]);
        Assert.assertEquals((Object)"y", (Object)assignesVar[1]);
        Calendar varDate = Calendar.getInstance();
        varDate.setTime((Date)graph.getVariables().get("datefield"));
        Assert.assertEquals((long)Calendar.getInstance().get(5), (long)varDate.get(5));
        OperationChain setWorkflowVar = new OperationChain("setVar");
        setWorkflowVar.add("Context.SetWorkflowVar").set("name", (Object)"stringfield").set("value", (Object)"test1");
        this.automationService.run(ctx, setWorkflowVar);
        this.session.save();
        routeInstance = this.session.getDocument(routeInstance.getRef());
        graph = (GraphRoute)routeInstance.getAdapter(GraphRoute.class);
        Assert.assertEquals(graph.getVariables().get("stringfield"), (Object)"test1");
        ctx = new OperationContext();
        ctx.setCoreSession(this.session);
        ctx.setInput((Object)this.doc);
        setWorkflowVar = new OperationChain("setWVar");
        setWorkflowVar.add("Context.SetWorkflowVar").set("workflowInstanceId", (Object)routeInstance.getId()).set("name", (Object)"stringfield").set("value", (Object)"test2");
        this.automationService.run(ctx, setWorkflowVar);
        this.session.save();
        routeInstance = this.session.getDocument(routeInstance.getRef());
        graph = (GraphRoute)routeInstance.getAdapter(GraphRoute.class);
        Assert.assertEquals(graph.getVariables().get("stringfield"), (Object)"test2");
    }

    @Test
    public void testTasksOperations() throws Exception {
        this.routeDoc.setPropertyValue("docri:variablesFacet", (Serializable)((Object)"FacetRoute1"));
        this.routeDoc.addFacet("FacetRoute1");
        this.routeDoc = this.session.saveDocument(this.routeDoc);
        DocumentModel node1 = this.createNode(this.routeDoc, "node1", this.session);
        node1.setPropertyValue("rnode:variablesFacet", (Serializable)((Object)"FacetNode1"));
        node1.addFacet("FacetNode1");
        node1.setPropertyValue("rnode:start", (Serializable)Boolean.TRUE);
        this.setTransitions(node1, this.transition("trans1", "node2", "NodeVariables[\"button\"] == \"trans1\"", "testchain_title1"));
        node1.setPropertyValue("rnode:hasTask", (Serializable)Boolean.TRUE);
        node1.setPropertyValue("rnode:taskDocType", (Serializable)((Object)"MyTaskDoc"));
        String[] users = new String[]{((NuxeoPrincipal)this.session.getPrincipal()).getName()};
        node1.setPropertyValue("rnode:taskAssignees", (Serializable)users);
        node1 = this.session.saveDocument(node1);
        DocumentModel node2 = this.createNode(this.routeDoc, "node2", this.session);
        node2.setPropertyValue("rnode:merge", (Serializable)((Object)"all"));
        node2.setPropertyValue("rnode:stop", (Serializable)Boolean.TRUE);
        node2 = this.session.saveDocument(node2);
        DocumentRoute instance = this.instantiateAndRun(this.session);
        this.session.save();
        OperationContext ctx = new OperationContext();
        ctx.setCoreSession(this.session);
        ctx.setInput((Object)this.doc);
        List tasks = (List)this.automationService.run(ctx, "Workflow.GetOpenTasks", new HashMap());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        ctx = new OperationContext();
        ctx.setCoreSession(this.session);
        DocumentModelListImpl docs = new DocumentModelListImpl();
        docs.add((Object)this.doc);
        ctx.setInput((Object)docs);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", users[0]);
        params.put("nodeId", "node1");
        params.put("processId", instance.getDocument().getId());
        tasks = (List)this.automationService.run(ctx, "Workflow.GetOpenTasks", params);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        ctx = new OperationContext();
        ctx.setCoreSession(this.session);
        ctx.setInput((Object)tasks);
        Properties workflowVars = new Properties();
        workflowVars.put((Object)"stringfield", (Object)"completeTaskTest");
        workflowVars.put((Object)"myassignees", (Object)"[\"xx\", \"yy\"]");
        Properties nodeVars = new Properties();
        nodeVars.put((Object)"stringfield2", (Object)"testNodeVar");
        OperationChain completeTask = new OperationChain("WorkflowTask.Complete");
        completeTask.add("WorkflowTask.Complete").set("status", (Object)"trans1").set("workflowVariables", (Object)workflowVars).set("nodeVariables", (Object)nodeVars);
        this.automationService.run(ctx, completeTask);
        this.session.save();
        DocumentModel routeInstance = this.session.getDocument((DocumentRef)new IdRef(instance.getDocument().getId()));
        GraphRoute graph = (GraphRoute)routeInstance.getAdapter(GraphRoute.class);
        Map vars = graph.getVariables();
        Assert.assertEquals((Object)routeInstance.getPropertyValue("fctroute1:stringfield"), (Object)"completeTaskTest");
        Assert.assertEquals(vars.get("stringfield"), (Object)"completeTaskTest");
        String[] assignesVar = (String[])vars.get("myassignees");
        Assert.assertEquals((long)2L, (long)assignesVar.length);
        Assert.assertEquals((Object)"xx", (Object)assignesVar[0]);
        Assert.assertEquals((Object)"yy", (Object)assignesVar[1]);
        GraphNode n1 = graph.getNode("node1");
        Assert.assertEquals((Object)"testNodeVar", n1.getVariables().get("stringfield2"));
        ctx = new OperationContext();
        ctx.setCoreSession(this.session);
        ctx.setInput((Object)this.doc);
        tasks = (List)this.automationService.run(ctx, "Workflow.GetOpenTasks", new HashMap());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }
}

