/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit;

import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.ecm.core.test.TransactionalFeature;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.test.PlatformFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ManagementFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.SimpleFeature;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Features(value={ManagementFeature.class, PlatformFeature.class})
@Deploy(value={"org.nuxeo.runtime.datasource", "org.nuxeo.runtime.metrics", "org.nuxeo.ecm.core.persistence", "org.nuxeo.ecm.platform.audit"})
@LocalDeploy(value={"org.nuxeo.ecm.platform.audit:nxaudit-ds.xml"})
public class AuditFeature
extends SimpleFeature {
    public void initialize(FeaturesRunner runner) throws Exception {
        ((TransactionalFeature)runner.getFeature(TransactionalFeature.class)).addWaiter(new TransactionalFeature.Waiter(){

            public boolean await(long deadline) throws InterruptedException {
                return ((AuditLogger)Framework.getService(AuditLogger.class)).await(deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        });
    }

    public void stop(FeaturesRunner runner) throws Exception {
        this.clear();
    }

    protected void clear() {
        boolean started = !TransactionHelper.isTransactionActive() && TransactionHelper.startTransaction();
        try {
            this.doClear();
        }
        finally {
            if (started) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    public void doClear() {
        try (EntityManager em = ((PersistenceProviderFactory)Framework.getService(PersistenceProviderFactory.class)).newProvider("nxaudit-logs").acquireEntityManager();){
            em.createNativeQuery("delete from nxp_logs_mapextinfos").executeUpdate();
            em.createNativeQuery("delete from nxp_logs_extinfo").executeUpdate();
            em.createNativeQuery("delete from nxp_logs").executeUpdate();
        }
    }
}

