/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit;

import java.net.URL;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.nuxeo.ecm.core.persistence.EntityManagerFactoryProvider;
import org.nuxeo.ecm.core.persistence.HibernateConfiguration;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;

public abstract class PersistenceTestCase {
    protected static final Log log = LogFactory.getLog(PersistenceTestCase.class);
    protected PersistenceProvider persistenceProvider;
    protected EntityManager entityManager;

    protected void handleBeforeSetup(HibernateConfiguration config) {
    }

    protected void handleAfterSetup(EntityManager entityManager) {
    }

    @Before
    public void setUp() throws Exception {
        URL resource = this.getClass().getResource("/hibernate-tests.xml");
        HibernateConfiguration config = HibernateConfiguration.load((URL)resource);
        this.persistenceProvider = new PersistenceProvider((EntityManagerFactoryProvider)config);
        this.handleBeforeSetup(config);
        this.persistenceProvider.openPersistenceUnit();
        this.entityManager = this.persistenceProvider.acquireEntityManagerWithActiveTransaction();
        this.handleAfterSetup(this.entityManager);
    }

    @After
    public void tearDown() {
        this.persistenceProvider.releaseEntityManagerWithRollback(this.entityManager);
    }
}

