/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.test.annotations.RepositoryInit;
import org.nuxeo.ecm.platform.audit.AuditFeature;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.DocumentHistoryReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={AuditFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.platform.audit.tests:test-pageprovider-contrib.xml"})
@RepositoryConfig(init=Pfouh.class)
public class TestDocumentAuditPageProvider {
    protected static final Calendar testDate = Calendar.getInstance();
    @Inject
    AuditReader reader;
    @Inject
    CoreSession session;
    protected static Pfouh pfouh;
    @Inject
    DocumentHistoryReader history;

    @Test
    public void testDocumentHistoryPageProvider() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("DOCUMENT_HISTORY_PROVIDER");
        Assert.assertNotNull((Object)ppdef);
        PageProvider pp = pps.getPageProvider("DOCUMENT_HISTORY_PROVIDER", null, Long.valueOf(20L), Long.valueOf(0L), new HashMap(), new Object[]{TestDocumentAuditPageProvider.pfouh.doc});
        DocumentModel searchDoc = this.session.createDocumentModel("BasicAuditSearch");
        searchDoc.setPathInfo("/", "auditsearch");
        searchDoc = this.session.createDocument(searchDoc);
        pp.setSearchDocumentModel(searchDoc);
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertEquals((long)19L, (long)entries.size());
        long startId = ((LogEntry)entries.get(entries.size() - 1)).getId();
        pp = pps.getPageProvider("DOCUMENT_HISTORY_PROVIDER", null, Long.valueOf(20L), Long.valueOf(0L), new HashMap(), new Object[]{TestDocumentAuditPageProvider.pfouh.proxy});
        pp.setSearchDocumentModel(searchDoc);
        entries = pp.getCurrentPage();
        int proxyEntriesCount = 16;
        Assert.assertEquals((long)proxyEntriesCount, (long)entries.size());
        Assert.assertEquals((long)startId, (long)((LogEntry)entries.get(proxyEntriesCount - 1)).getId());
        Assert.assertEquals((long)(startId + (long)proxyEntriesCount + 1L), (long)((LogEntry)entries.get(0)).getId());
        pp = pps.getPageProvider("DOCUMENT_HISTORY_PROVIDER", null, Long.valueOf(20L), Long.valueOf(0L), new HashMap(), new Object[]{TestDocumentAuditPageProvider.pfouh.versions.get(0)});
        pp.setSearchDocumentModel(searchDoc);
        entries = pp.getCurrentPage();
        int version1EntriesCount = 9;
        if (version1EntriesCount == entries.size()) {
            Assert.assertEquals((long)startId, (long)((LogEntry)entries.get(version1EntriesCount - 1)).getId());
            Assert.assertEquals((long)(startId + (long)version1EntriesCount - 1L), (long)((LogEntry)entries.get(0)).getId());
        } else {
            Assert.assertEquals((String)entries.toString(), (long)(version1EntriesCount - 1), (long)entries.size());
        }
        pp = pps.getPageProvider("DOCUMENT_HISTORY_PROVIDER", null, Long.valueOf(20L), Long.valueOf(0L), new HashMap(), new Object[]{TestDocumentAuditPageProvider.pfouh.versions.get(1)});
        pp.setSearchDocumentModel(searchDoc);
        entries = pp.getCurrentPage();
        int versin2EntriesCount = 15;
        Assert.assertEquals((long)versin2EntriesCount, (long)entries.size());
        Assert.assertEquals((long)startId, (long)((LogEntry)entries.get(versin2EntriesCount - 1)).getId());
        Assert.assertEquals((long)(startId + (long)versin2EntriesCount), (long)((LogEntry)entries.get(0)).getId());
    }

    @Test
    public void testDocumentHistoryReader() throws Exception {
        List entries = this.history.getDocumentHistory(TestDocumentAuditPageProvider.pfouh.versions.get(1), 0L, 20L);
        Assert.assertNotNull((Object)entries);
        int versin2EntriesCount = 15;
        Assert.assertEquals((long)versin2EntriesCount, (long)entries.size());
    }

    public static class Pfouh
    implements RepositoryInit {
        protected boolean verbose;
        DocumentModel doc;
        DocumentModel proxy;
        List<DocumentModel> versions;

        public Pfouh() {
            pfouh = this;
            this.verbose = false;
        }

        protected static void sleep(long millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void populate(CoreSession session) {
            int i;
            DocumentModel section = session.createDocumentModel("/", "section", "Folder");
            section = session.createDocument(section);
            this.doc = session.createDocumentModel("/", "doc", "File");
            this.doc.setPropertyValue("dc:title", (Serializable)((Object)"TestDoc"));
            this.doc = session.createDocument(this.doc);
            Pfouh.sleep(10L);
            for (i = 0; i < 5; ++i) {
                this.doc.setPropertyValue("dc:description", (Serializable)((Object)("Update " + i)));
                this.doc.getContextData().put((Object)"comment", (Object)("Update " + i));
                this.doc = session.saveDocument(this.doc);
                session.save();
                Pfouh.sleep(10L);
            }
            this.doc.putContextData("VersioningOption", (Serializable)VersioningOption.MINOR);
            this.doc = session.saveDocument(this.doc);
            session.save();
            Pfouh.sleep(10L);
            for (i = 5; i < 10; ++i) {
                this.doc.setPropertyValue("dc:description", (Serializable)((Object)("Update " + i)));
                this.doc.getContextData().put((Object)"comment", (Object)("Update " + i));
                this.doc = session.saveDocument(this.doc);
                session.save();
                Pfouh.sleep(10L);
            }
            this.proxy = session.publishDocument(this.doc, section);
            session.save();
            Pfouh.sleep(10L);
            for (i = 10; i < 15; ++i) {
                this.doc.setPropertyValue("dc:description", (Serializable)((Object)("Update " + i)));
                this.doc.getContextData().put((Object)"comment", (Object)("Update " + i));
                this.doc = session.saveDocument(this.doc);
                session.save();
                Pfouh.sleep(10L);
            }
            this.versions = session.getVersions(this.doc.getRef());
            Assert.assertEquals((long)2L, (long)this.versions.size());
        }
    }
}

