/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit;

import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.inject.Inject;
import org.jboss.el.ExpressionFactoryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.platform.el.ExpressionContext;
import org.nuxeo.ecm.platform.el.ExpressionEvaluator;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
public class TestExtendedInfoEvaluation {
    @Inject
    protected CoreSession session;
    protected ExpressionEvaluator evaluatorUnderTest;

    @Before
    public void setUp() {
        this.evaluatorUnderTest = new ExpressionEvaluator((ExpressionFactory)new ExpressionFactoryImpl());
    }

    protected DocumentModel doCreateDocument() {
        DocumentModel rootDocument = this.session.getRootDocument();
        DocumentModel model = this.session.createDocumentModel(rootDocument.getPathAsString(), "youps", "File");
        model.setProperty("dublincore", "title", (Object)"huum");
        return this.session.createDocument(model);
    }

    @Test
    public void testBean() {
        ExpressionContext context = new ExpressionContext();
        DocumentModel source = this.doCreateDocument();
        DocumentEventContext eventContext = new DocumentEventContext(this.session, this.session.getPrincipal(), source);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("test", "test");
        eventContext.setProperties(properties);
        this.evaluatorUnderTest.bindValue((ELContext)context, "context", (Object)eventContext);
        DocumentModel value = (DocumentModel)this.evaluatorUnderTest.evaluateExpression((ELContext)context, "${context.arguments[0]}", DocumentModel.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)source, (Object)value);
        String test = (String)this.evaluatorUnderTest.evaluateExpression((ELContext)context, "${context.properties.test}", String.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"test", (Object)test);
    }
}

