/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.SimplePrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.UnboundEventContext;
import org.nuxeo.ecm.core.test.DefaultRepositoryInit;
import org.nuxeo.ecm.core.test.TransactionalFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.platform.audit.AuditFeature;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.ecm.platform.audit.service.DefaultAuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.extension.AdapterDescriptor;
import org.nuxeo.ecm.platform.audit.service.management.AuditEventMetricFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ObjectNameFactory;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={AuditFeature.class})
@RepositoryConfig(init=MyInit.class, cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.platform.audit:test-audit-contrib.xml"})
public class TestNXAuditEventsService {
    protected static MyInit repo;
    @Inject
    Logs serviceUnderTest;
    protected MBeanServer mbeanServer;
    @Inject
    protected EventService eventService;
    @Inject
    CoreSession session;
    @Inject
    TransactionalFeature txFeature;

    @Before
    public void setUp() throws Exception {
        this.mbeanServer = ((ServerLocator)Framework.getLocalService(ServerLocator.class)).lookupServer();
    }

    public void waitForAsyncCompletion() throws InterruptedException {
        this.txFeature.nextTransaction(20L, TimeUnit.SECONDS);
    }

    @Test
    public void testAuditContribution() throws Exception {
        NXAuditEventsService auditService = (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
        Assert.assertNotNull((Object)auditService);
        Set registeredAdapters = auditService.getDocumentAdapters();
        Assert.assertEquals((long)1L, (long)registeredAdapters.size());
        AdapterDescriptor ad = (AdapterDescriptor)registeredAdapters.iterator().next();
        Assert.assertEquals((Object)"myadapter", (Object)ad.getName());
    }

    @Test
    public void testLogDocumentMessageWithoutCategory() throws InterruptedException {
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), TestNXAuditEventsService.repo.source);
        Event event = ctx.newEvent("documentSecurityUpdated");
        event.setInline(false);
        event.setImmediate(true);
        this.eventService.fireEvent(event);
        this.waitForAsyncCompletion();
        List entries = this.serviceUnderTest.getLogEntriesFor(TestNXAuditEventsService.repo.source.getId());
        Assert.assertEquals((long)2L, (long)entries.size());
        for (LogEntry entry : entries) {
            if ("documentSecurityUpdated".equals(entry.getEventId())) {
                Assert.assertEquals((Object)"eventDocumentCategory", (Object)entry.getCategory());
                Assert.assertNull((Object)entry.getComment());
                Assert.assertEquals((Object)"project", (Object)entry.getDocLifeCycle());
                Assert.assertEquals((Object)"/youps", (Object)entry.getDocPath());
                Assert.assertEquals((Object)"File", (Object)entry.getDocType());
                Assert.assertEquals((Object)"documentSecurityUpdated", (Object)entry.getEventId());
                Assert.assertEquals((Object)"Administrator", (Object)entry.getPrincipalName());
            } else {
                Assert.assertEquals((Object)"documentCreated", (Object)entry.getEventId());
            }
            Assert.assertEquals((Object)"test", (Object)entry.getRepositoryId());
        }
    }

    @Test
    public void testLogDocumentMessageWithCategory() throws InterruptedException {
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), TestNXAuditEventsService.repo.source);
        ctx.setProperty("category", (Serializable)((Object)"myCategory"));
        Event event = ctx.newEvent("documentSecurityUpdated");
        event.setInline(false);
        event.setImmediate(true);
        this.eventService.fireEvent(event);
        this.waitForAsyncCompletion();
        List entries = this.serviceUnderTest.getLogEntriesFor(TestNXAuditEventsService.repo.source.getId());
        Assert.assertEquals((long)2L, (long)entries.size());
        for (LogEntry entry : entries) {
            if ("documentSecurityUpdated".equals(entry.getEventId())) {
                Assert.assertEquals((Object)"myCategory", (Object)entry.getCategory());
                Assert.assertNull((Object)entry.getComment());
                Assert.assertEquals((Object)"project", (Object)entry.getDocLifeCycle());
                Assert.assertEquals((Object)"/youps", (Object)entry.getDocPath());
                Assert.assertEquals((Object)"File", (Object)entry.getDocType());
                Assert.assertEquals((Object)"documentSecurityUpdated", (Object)entry.getEventId());
                Assert.assertEquals((Object)"Administrator", (Object)entry.getPrincipalName());
            } else {
                Assert.assertEquals((Object)"documentCreated", (Object)entry.getEventId());
            }
            Assert.assertEquals((Object)"test", (Object)entry.getRepositoryId());
        }
    }

    @Test
    public void testLogMiscMessage() throws InterruptedException {
        DefaultAuditBackend backend = (DefaultAuditBackend)this.serviceUnderTest;
        List eventIds = backend.getLoggedEventIds();
        int n = eventIds.size();
        EventContextImpl ctx = new EventContextImpl(new Object[0]);
        Event event = ctx.newEvent("documentModified");
        event.setInline(false);
        event.setImmediate(true);
        this.eventService.fireEvent(event);
        this.waitForAsyncCompletion();
        eventIds = backend.getLoggedEventIds();
        Assert.assertEquals((long)(n + 1), (long)eventIds.size());
    }

    @Test
    public void testsyncLogCreation() throws Exception {
        DocumentModel rootDocument = this.session.getRootDocument();
        long count = this.serviceUnderTest.syncLogCreationEntries(this.session.getRepositoryName(), rootDocument.getPathAsString(), Boolean.valueOf(true));
        Assert.assertEquals((long)14L, (long)count);
        String query = String.format("log.docUUID = '%s' and log.eventId = 'documentCreated'", rootDocument.getId());
        List entries = this.serviceUnderTest.nativeQueryLogs(query, 1, 1);
        Assert.assertEquals((long)1L, (long)entries.size());
        LogEntry entry = (LogEntry)entries.get(0);
        Assert.assertEquals((Object)"eventDocumentCategory", (Object)entry.getCategory());
        Assert.assertNull((Object)entry.getComment());
        Assert.assertEquals((Object)"/", (Object)entry.getDocPath());
        Assert.assertEquals((Object)"Root", (Object)entry.getDocType());
        Assert.assertEquals((Object)"documentCreated", (Object)entry.getEventId());
        Assert.assertEquals((Object)"system", (Object)entry.getPrincipalName());
    }

    @Test
    public void simplePincipalNameIsLoggedAsPrincipalName() throws Exception {
        SimplePrincipal principal = new SimplePrincipal("testuser");
        UnboundEventContext ctx = new UnboundEventContext((Principal)principal, new HashMap());
        this.eventService.fireEvent(ctx.newEvent("loginSuccess"));
        this.waitForAsyncCompletion();
        Assert.assertEquals((long)1L, (long)this.serviceUnderTest.getEventsCount("loginSuccess").intValue());
        LogEntry logEntry = (LogEntry)this.serviceUnderTest.nativeQueryLogs("log.eventId ='loginSuccess'", 1, 1).get(0);
        Assert.assertEquals((Object)"testuser", (Object)logEntry.getPrincipalName());
    }

    @Test
    public void testExtendedInfos() throws InterruptedException {
        DocumentModel rootDocument = this.session.getRootDocument();
        DocumentModel model = this.session.createDocumentModel(rootDocument.getPathAsString(), "youps", "File");
        model.setProperty("dublincore", "title", (Object)"huum");
        model = this.session.createDocument(model);
        long count = this.serviceUnderTest.syncLogCreationEntries(this.session.getRepositoryName(), model.getPathAsString(), Boolean.valueOf(true));
        Assert.assertEquals((long)1L, (long)count);
        String query = String.format("log.docUUID = '%s' and log.eventId = 'documentCreated'", model.getId());
        List entries = this.serviceUnderTest.nativeQueryLogs(query, 1, 1);
        Assert.assertEquals((long)1L, (long)entries.size());
        LogEntry entry = (LogEntry)entries.get(0);
        Assert.assertEquals((Object)"eventDocumentCategory", (Object)entry.getCategory());
        Assert.assertEquals((Object)"test", (Object)entry.getRepositoryId());
        Assert.assertEquals((Object)"huum", (Object)((ExtendedInfo)entry.getExtendedInfos().get("title")).getSerializableValue());
        Assert.assertEquals((Object)"/", (Object)((ExtendedInfo)entry.getExtendedInfos().get("parentPath")).getSerializableValue());
        this.session.removeDocument(model.getRef());
        this.session.save();
        this.waitForAsyncCompletion();
        FilterMapEntry filterByDocRemoved = new FilterMapEntry();
        filterByDocRemoved.setColumnName("eventId");
        filterByDocRemoved.setOperator("=");
        filterByDocRemoved.setQueryParameterName("eventId");
        filterByDocRemoved.setObject((Object)"documentRemoved");
        HashMap<String, FilterMapEntry> filterMap = new HashMap<String, FilterMapEntry>();
        filterMap.put("eventId", filterByDocRemoved);
        entries = this.serviceUnderTest.getLogEntriesFor(model.getId(), filterMap, true);
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertNull(((LogEntry)entries.get(0)).getExtendedInfos().get("title"));
        Assert.assertEquals((Object)"/", (Object)((ExtendedInfo)((LogEntry)entries.get(0)).getExtendedInfos().get("parentPath")).getSerializableValue());
    }

    protected Set<ObjectName> doQuery(String name) {
        String qualifiedName = ObjectNameFactory.getQualifiedName((String)name);
        ObjectName objectName = ObjectNameFactory.getObjectName((String)qualifiedName);
        return this.mbeanServer.queryNames(objectName, null);
    }

    public void TODOtestCount() throws Exception {
        DocumentModel rootDocument = this.session.getRootDocument();
        DocumentModel model = this.session.createDocumentModel(rootDocument.getPathAsString(), "youps", "File");
        model.setProperty("dublincore", "title", (Object)"huum");
        this.session.createDocument(model);
        this.session.save();
        this.waitForAsyncCompletion();
        ObjectName objectName = AuditEventMetricFactory.getObjectName((String)"documentCreated");
        Long count = (Long)this.mbeanServer.getAttribute(objectName, "count");
        Assert.assertEquals((Object)new Long(1L), (Object)count);
    }

    public static class MyInit
    extends DefaultRepositoryInit {
        protected DocumentModel source;

        public MyInit() {
            repo = this;
        }

        public void populate(CoreSession session) {
            super.populate(session);
            DocumentModel rootDocument = session.getRootDocument();
            DocumentModel model = session.createDocumentModel(rootDocument.getPathAsString(), "youps", "File");
            model.setProperty("dublincore", "title", (Object)"huum");
            session.createDocument(model);
            this.source = session.getDocument((DocumentRef)new PathRef("/youps"));
        }
    }
}

