/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.audit.AuditFeature;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.AuditPageProvider;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.document.DocumentHistoryPageProvider;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={AuditFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.platform.audit:test-audit-contrib.xml", "org.nuxeo.ecm.platform.audit:test-pageprovider-contrib.xml"})
public class TestPageProvider {
    protected static final List<String> entriesIdx = Arrays.asList("3", "7", "7", "8", "1", "8", "7", "9");
    protected static final Calendar testDate = Calendar.getInstance();
    @Inject
    AuditFeature audit;
    @Inject
    CoreSession session;

    @Before
    public void createTestEntries() {
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        Assert.assertNotNull((Object)reader);
        this.audit.clear();
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        Assert.assertNotNull((Object)logger);
        ArrayList<LogEntryImpl> entries = new ArrayList<LogEntryImpl>();
        for (String suffix : entriesIdx) {
            LogEntryImpl entry = new LogEntryImpl();
            entry.setCategory("category" + suffix);
            entry.setEventId("event" + suffix);
            Calendar eventDate = (Calendar)testDate.clone();
            eventDate.add(6, Integer.parseInt(suffix));
            entry.setEventDate(eventDate.getTime());
            entry.setDocType("docType" + suffix);
            entry.setDocUUID("uuid");
            entries.add(entry);
        }
        logger.addLogEntries(entries);
        List res = reader.nativeQuery("select count(log.eventId) from LogEntry log", 1, 20);
        int count = ((Long)res.get(0)).intValue();
        Assert.assertEquals((long)entries.size(), (long)count);
    }

    @Test
    public void testSimpleProvider() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("GetAllEntries");
        Assert.assertNotNull((Object)ppdef);
        GenericPageProviderDescriptor gppdef = (GenericPageProviderDescriptor)ppdef;
        Assert.assertEquals((Object)AuditPageProvider.class.getSimpleName(), (Object)gppdef.getPageProviderClass().getSimpleName());
        PageProvider pp = pps.getPageProvider("GetAllEntries", null, Long.valueOf(5L), Long.valueOf(0L), new HashMap(), new Object[0]);
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)5L, (long)entries.size());
        Assert.assertEquals((Object)("category" + entriesIdx.get(0)), (Object)((LogEntry)entries.get(0)).getCategory());
        Assert.assertEquals((Object)("category" + entriesIdx.get(3)), (Object)((LogEntry)entries.get(3)).getCategory());
        Assert.assertEquals((Object)("category" + entriesIdx.get(4)), (Object)((LogEntry)entries.get(4)).getCategory());
        long nbPages = pp.getNumberOfPages();
        Assert.assertEquals((long)2L, (long)nbPages);
        pp.nextPage();
        entries = pp.getCurrentPage();
        Assert.assertEquals((long)3L, (long)entries.size());
        Assert.assertEquals((Object)("category" + entriesIdx.get(5)), (Object)((LogEntry)entries.get(0)).getCategory());
        Assert.assertEquals((Object)("category" + entriesIdx.get(7)), (Object)((LogEntry)entries.get(2)).getCategory());
    }

    @Test
    public void testProviderWithParams() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("GetAllEntriesInCategory");
        Assert.assertNotNull((Object)ppdef);
        GenericPageProviderDescriptor gppdef = (GenericPageProviderDescriptor)ppdef;
        Assert.assertEquals((Object)AuditPageProvider.class.getSimpleName(), (Object)gppdef.getPageProviderClass().getSimpleName());
        PageProvider pp = pps.getPageProvider("GetAllEntriesInCategory", null, Long.valueOf(2L), Long.valueOf(0L), new HashMap(), new Object[]{"category7"});
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)("event" + entriesIdx.get(1)), (Object)((LogEntry)entries.get(0)).getEventId());
        Assert.assertEquals((Object)"category7", (Object)((LogEntry)entries.get(0)).getCategory());
        Assert.assertEquals((Object)("event" + entriesIdx.get(2)), (Object)((LogEntry)entries.get(1)).getEventId());
        Assert.assertEquals((Object)"category7", (Object)((LogEntry)entries.get(1)).getCategory());
        long nbPages = pp.getNumberOfPages();
        Assert.assertEquals((long)2L, (long)nbPages);
        pp.nextPage();
        entries = pp.getCurrentPage();
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((Object)("event" + entriesIdx.get(6)), (Object)((LogEntry)entries.get(0)).getEventId());
        Assert.assertEquals((Object)"category7", (Object)((LogEntry)entries.get(0)).getCategory());
    }

    @Test
    public void testProviderWithWhereClause() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("GetAllEntriesForDocumentInCategory");
        Assert.assertNotNull((Object)ppdef);
        GenericPageProviderDescriptor gppdef = (GenericPageProviderDescriptor)ppdef;
        Assert.assertEquals((Object)AuditPageProvider.class.getSimpleName(), (Object)gppdef.getPageProviderClass().getSimpleName());
        PageProvider pp = pps.getPageProvider("GetAllEntriesForDocumentInCategory", (DocumentModel)null, null, Long.valueOf(2L), Long.valueOf(0L), new HashMap(), new Object[]{"uuid"});
        DocumentModel searchDoc = this.session.createDocumentModel("File");
        searchDoc.setPathInfo("/", "dummy");
        searchDoc.setPropertyValue("dc:title", (Serializable)((Object)"category7"));
        searchDoc = this.session.createDocument(searchDoc);
        pp.setSearchDocumentModel(searchDoc);
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)("event" + entriesIdx.get(1)), (Object)((LogEntry)entries.get(0)).getEventId());
        Assert.assertEquals((Object)"category7", (Object)((LogEntry)entries.get(0)).getCategory());
        Assert.assertEquals((Object)("event" + entriesIdx.get(2)), (Object)((LogEntry)entries.get(1)).getEventId());
        Assert.assertEquals((Object)"category7", (Object)((LogEntry)entries.get(1)).getCategory());
        long nbPages = pp.getNumberOfPages();
        Assert.assertEquals((long)2L, (long)nbPages);
        pp.nextPage();
        entries = pp.getCurrentPage();
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((Object)("event" + entriesIdx.get(6)), (Object)((LogEntry)entries.get(0)).getEventId());
        Assert.assertEquals((Object)"category7", (Object)((LogEntry)entries.get(0)).getCategory());
    }

    @Test
    public void testProviderWithWhereClause2() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("GetAllEntriesForDocumentInCategories");
        Assert.assertNotNull((Object)ppdef);
        GenericPageProviderDescriptor gppdef = (GenericPageProviderDescriptor)ppdef;
        Assert.assertEquals((Object)AuditPageProvider.class.getSimpleName(), (Object)gppdef.getPageProviderClass().getSimpleName());
        PageProvider pp = pps.getPageProvider("GetAllEntriesForDocumentInCategories", null, Long.valueOf(2L), Long.valueOf(0L), new HashMap(), new Object[]{"uuid"});
        DocumentModel searchDoc = this.session.createDocumentModel("File");
        searchDoc.setPathInfo("/", "dummy");
        ArrayList<String> cats = new ArrayList<String>();
        cats.add("category7");
        cats.add("category3");
        searchDoc.setPropertyValue("dc:subjects", (Serializable)cats);
        searchDoc = this.session.createDocument(searchDoc);
        pp.setSearchDocumentModel(searchDoc);
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)2L, (long)entries.size());
        long nbPages = pp.getNumberOfPages();
        Assert.assertEquals((long)2L, (long)nbPages);
        pp.nextPage();
        entries = pp.getCurrentPage();
        Assert.assertEquals((long)2L, (long)entries.size());
    }

    @Test
    public void testProviderWithBetweenDates() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("GetAllEntriesBetween2Dates");
        Assert.assertNotNull((Object)ppdef);
        GenericPageProviderDescriptor gppdef = (GenericPageProviderDescriptor)ppdef;
        Assert.assertEquals((Object)AuditPageProvider.class.getSimpleName(), (Object)gppdef.getPageProviderClass().getSimpleName());
        PageProvider pp = pps.getPageProvider("GetAllEntriesBetween2Dates", null, Long.valueOf(6L), Long.valueOf(0L), new HashMap(), new Object[]{"uuid"});
        DocumentModel searchDoc = this.session.createDocumentModel("File");
        searchDoc.setPathInfo("/", "dummy");
        Calendar startDate = (Calendar)testDate.clone();
        startDate.add(6, 7);
        Calendar endDate = (Calendar)testDate.clone();
        endDate.add(6, 9);
        searchDoc.setPropertyValue("dc:issued", (Serializable)startDate);
        searchDoc.setPropertyValue("dc:valid", (Serializable)endDate);
        searchDoc = this.session.createDocument(searchDoc);
        pp.setSearchDocumentModel(searchDoc);
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)6L, (long)entries.size());
        long nbPages = pp.getNumberOfPages();
        Assert.assertEquals((long)1L, (long)nbPages);
        searchDoc = this.session.createDocumentModel("File");
        searchDoc.setPathInfo("/", "dummy2");
        searchDoc = this.session.createDocument(searchDoc);
        pp.setSearchDocumentModel(searchDoc);
        entries = pp.getCurrentPage();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)6L, (long)entries.size());
        nbPages = pp.getNumberOfPages();
        Assert.assertEquals((long)2L, (long)nbPages);
        pp.nextPage();
        entries = pp.getCurrentPage();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)2L, (long)entries.size());
        searchDoc = this.session.createDocumentModel("File");
        searchDoc.setPathInfo("/", "dummy3");
        endDate = (Calendar)testDate.clone();
        endDate.add(6, 4);
        searchDoc.setPropertyValue("dc:valid", (Serializable)endDate);
        searchDoc = this.session.createDocument(searchDoc);
        pp.setSearchDocumentModel(searchDoc);
        entries = pp.getCurrentPage();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)2L, (long)entries.size());
        nbPages = pp.getNumberOfPages();
        Assert.assertEquals((long)1L, (long)nbPages);
        searchDoc = this.session.createDocumentModel("File");
        searchDoc.setPathInfo("/", "dummy3");
        startDate = (Calendar)testDate.clone();
        startDate.add(6, 4);
        searchDoc.setPropertyValue("dc:issued", (Serializable)startDate);
        searchDoc = this.session.createDocument(searchDoc);
        pp.setSearchDocumentModel(searchDoc);
        entries = pp.getCurrentPage();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)6L, (long)entries.size());
        nbPages = pp.getNumberOfPages();
        Assert.assertEquals((long)1L, (long)nbPages);
    }

    @Test
    public void testDocumentHistoryPageProvider() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("DOCUMENT_HISTORY_PROVIDER");
        Assert.assertNotNull((Object)ppdef);
        GenericPageProviderDescriptor gppdef = (GenericPageProviderDescriptor)ppdef;
        Assert.assertEquals((Object)DocumentHistoryPageProvider.class.getSimpleName(), (Object)gppdef.getPageProviderClass().getSimpleName());
        PageProvider pp = pps.getPageProvider("DOCUMENT_HISTORY_PROVIDER", null, Long.valueOf(6L), Long.valueOf(0L), new HashMap(), new Object[]{"uuid"});
        DocumentModel searchDoc = this.session.createDocumentModel("BasicAuditSearch");
        searchDoc.setPathInfo("/", "auditsearch");
        Calendar startDate = (Calendar)testDate.clone();
        startDate.add(6, 7);
        Calendar endDate = (Calendar)testDate.clone();
        endDate.add(6, 9);
        searchDoc.setPropertyValue("bas:startDate", (Serializable)startDate);
        searchDoc.setPropertyValue("bas:endDate", (Serializable)endDate);
        searchDoc = this.session.createDocument(searchDoc);
        pp.setSearchDocumentModel(searchDoc);
        Assert.assertNotNull((Object)pp);
        List entries = pp.getCurrentPage();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)6L, (long)entries.size());
        long nbPages = pp.getNumberOfPages();
        Assert.assertEquals((long)1L, (long)nbPages);
    }
}

