/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.platform.audit.AuditFeature;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={AuditFeature.class})
public class TestTransactedAudit {
    @Inject
    protected CoreSession repo;

    @Before
    public void isInjected() {
        Assert.assertThat((Object)this.repo, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void canLogMultipleLifecycleTransitionsInSameTx() throws InterruptedException {
        DocumentModel doc = this.repo.createDocumentModel("/", "a-file", "File");
        doc = this.repo.createDocument(doc);
        String initialLifeCycle = doc.getCurrentLifeCycleState();
        doc.followTransition("delete");
        String deletedLifeCycle = doc.getCurrentLifeCycleState();
        doc.followTransition("undelete");
        String undeletedLifeCycle = doc.getCurrentLifeCycleState();
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        Assert.assertThat((Object)((AuditLogger)Framework.getLocalService(AuditLogger.class)).await(10L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        List trail = reader.getLogEntriesFor(doc.getId());
        Assert.assertThat((Object)trail, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)trail.size(), (Matcher)CoreMatchers.is((Object)3));
        boolean seenDocCreated = false;
        boolean seenDocDeleted = false;
        boolean seenDocUndeleted = false;
        for (LogEntry entry : trail) {
            String lifeCycle = entry.getDocLifeCycle();
            String id = entry.getEventId();
            if ("documentCreated".equals(id)) {
                if (!initialLifeCycle.equals(lifeCycle)) continue;
                seenDocCreated = true;
                continue;
            }
            if (!"lifecycle_transition_event".equals(id)) continue;
            if (undeletedLifeCycle.equals(lifeCycle)) {
                seenDocUndeleted = true;
                continue;
            }
            if (!deletedLifeCycle.equals(lifeCycle)) continue;
            seenDocDeleted = true;
        }
        Assert.assertThat((Object)seenDocUndeleted, (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)seenDocDeleted, (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)seenDocCreated, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testLogDate() throws InterruptedException {
        DocumentModel doc = this.repo.createDocumentModel("/", "a-file", "File");
        doc = this.repo.createDocument(doc);
        Thread.sleep(1000L);
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        Assert.assertThat((Object)((AuditLogger)Framework.getLocalService(AuditLogger.class)).await(10L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        ((EventService)Framework.getLocalService(EventService.class)).waitForAsyncCompletion();
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        List trail = reader.getLogEntriesFor(doc.getId());
        Assert.assertThat((Object)trail, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)trail.size(), (Matcher)CoreMatchers.is((Object)1));
        Date eventDate = null;
        Date logDate = null;
        for (LogEntry entry : trail) {
            String id = entry.getEventId();
            if (!"documentCreated".equals(id)) continue;
            eventDate = entry.getEventDate();
            logDate = entry.getLogDate();
        }
        Assert.assertNotNull(eventDate);
        Assert.assertNotNull(logDate);
        Assert.assertTrue((boolean)logDate.after(eventDate));
    }
}

