/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.platform.audit.AuditFeature;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.io.LogEntryJsonWriter;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@Features(value={AuditFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.platform.audit.tests:test-pageprovider-contrib.xml"})
public class LogEntryJsonWriterTest
extends AbstractJsonWriterTest.External<LogEntryJsonWriter, LogEntry> {
    @Inject
    private PageProviderService pps;
    @Inject
    private CoreSession session;

    public LogEntryJsonWriterTest() {
        super(LogEntryJsonWriter.class, LogEntry.class);
    }

    @Test
    public void test() throws Exception {
        DocumentModel root = this.session.getDocument((DocumentRef)new PathRef("/"));
        PageProvider pp = this.pps.getPageProvider("DOCUMENT_HISTORY_PROVIDER", null, Long.valueOf(20L), Long.valueOf(0L), new HashMap(), new Object[]{root});
        List entries = pp.getCurrentPage();
        JsonAssert json = this.jsonAssert(entries.get(0));
        json.properties(14);
        json.has("entity-type").isEquals("logEntry");
        json.has("id").isInt();
        json.has("category").isEquals("eventDocumentCategory");
        json.has("principalName").isEquals("system");
        json.has("docPath").isEquals("/");
        json.has("docType").isEquals("Root");
        json.has("docUUID").isEquals(root.getId());
        json.has("eventId").isText();
        json.has("repositoryId").isEquals("test");
        json.has("eventDate").isText();
        json.has("logDate").isText();
        try {
            json.has("comment").isText();
        }
        catch (AssertionError e) {
            json.has("comment").isNull();
        }
        try {
            json.has("docLifeCycle").isText();
        }
        catch (AssertionError e) {
            json.has("docLifeCycle").isNull();
        }
        json.has("extended").properties(0);
    }
}

