/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.platform.audit.AuditFeature;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntryList;
import org.nuxeo.ecm.platform.audit.io.LogEntryListJsonWriter;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@Features(value={AuditFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.platform.audit.tests:test-pageprovider-contrib.xml"})
public class LogEntryListJsonWriterTest
extends AbstractJsonWriterTest.External<LogEntryListJsonWriter, List<LogEntry>> {
    @Inject
    private PageProviderService pps;
    @Inject
    private CoreSession session;

    public LogEntryListJsonWriterTest() {
        super(LogEntryListJsonWriter.class, List.class, (Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{LogEntry.class}));
    }

    @Test
    public void test() throws Exception {
        DocumentModel root = this.session.getDocument((DocumentRef)new PathRef("/"));
        HashMap properties = new HashMap();
        String name = "DOCUMENT_HISTORY_PROVIDER";
        PageProvider pp = this.pps.getPageProvider(name, null, Long.valueOf(3L), Long.valueOf(0L), properties, new Object[]{root});
        LogEntryList list = new LogEntryList(pp);
        JsonAssert json = this.jsonAssert(list);
        json.properties(17);
        json.has("entity-type").isEquals("logEntries");
        json.has("isPaginable").isTrue();
        json.has("resultsCount").isInt();
        json.has("pageSize").isEquals(pp.getPageSize());
        json.has("maxPageSize").isEquals(pp.getMaxPageSize());
        json.has("currentPageSize").isEquals(pp.getCurrentPageSize());
        json.has("currentPageIndex").isEquals(0);
        json.has("numberOfPages").isEquals(pp.getNumberOfPages());
        json.has("isPreviousPageAvailable").isEquals(pp.isPreviousPageAvailable());
        json.has("isNextPageAvailable").isEquals(pp.isNextPageAvailable());
        json.has("isLastPageAvailable").isEquals(pp.isLastPageAvailable());
        json.has("isSortable").isEquals(pp.isSortable());
        json.has("hasError").isEquals(pp.hasError());
        json.has("errorMessage").isNull();
        json.has("pageIndex").isEquals(pp.getCurrentPageIndex());
        json.has("pageCount").isEquals(pp.getResultsCount());
        json = json.has("entries").isArray();
        json = json.has(0).isObject();
        json.has("entity-type").isEquals("logEntry");
    }
}

