/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.job;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.platform.audit.AuditFeature;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.job.JobHistoryHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={AuditFeature.class})
public class TestJobHistoryHelper {
    @Test
    public void testLogger() throws Exception {
        StringBuffer query = new StringBuffer("from LogEntry log where ");
        query.append(" log.category='");
        query.append("MyExport");
        query.append("'  ORDER BY log.eventDate DESC");
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        List result = reader.nativeQuery(query.toString(), 1, 1);
        Assert.assertEquals((long)0L, (long)result.size());
        JobHistoryHelper helper = new JobHistoryHelper("MyExport");
        helper.logJobStarted();
        helper.logJobFailed("some error");
        helper.logJobEnded();
        result = reader.nativeQuery(query.toString(), 1, 10);
        Assert.assertEquals((long)3L, (long)result.size());
    }

    @Test
    public void testLoggerHelper() throws Exception {
        JobHistoryHelper helper = new JobHistoryHelper("MyExport2");
        helper.logJobStarted();
        Date exportDate = helper.getLastSuccessfulRun();
        Assert.assertNull((Object)exportDate);
        helper.logJobFailed("some other error");
        exportDate = helper.getLastSuccessfulRun();
        Assert.assertNull((Object)exportDate);
        helper.logJobEnded();
        exportDate = helper.getLastSuccessfulRun();
        Assert.assertNotNull((Object)exportDate);
        Thread.sleep(3000L);
        long t0 = System.currentTimeMillis();
        exportDate = helper.getLastSuccessfulRun();
        long loggedT0 = exportDate.getTime();
        Assert.assertTrue((loggedT0 < t0 ? 1 : 0) != 0);
        helper.logJobEnded();
        exportDate = helper.getLastSuccessfulRun();
        long loggedT1 = exportDate.getTime();
        long elapsed = loggedT1 - loggedT0;
        int min = 3000;
        if (SystemUtils.IS_OS_WINDOWS) {
            min = 2000;
        }
        Assert.assertTrue((String)(elapsed + " should be >= " + min), (elapsed >= (long)min ? 1 : 0) != 0);
    }
}

